/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.examples;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.cfg.LoadingConfiguration;
import com.github.fge.jsonschema.cfg.LoadingConfigurationBuilder;
import com.github.fge.jsonschema.examples.ExampleBase;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.report.ProcessingReport;
import java.io.IOException;

public final class Example10
extends ExampleBase {
    private static final String URI_BASE = "xxx://foo.bar/path/to/";

    public static void main(String ... args) throws IOException, ProcessingException {
        LoadingConfigurationBuilder builder = LoadingConfiguration.newBuilder();
        JsonNode node = Example10.loadResource("/split/fstab.json");
        String uri = "xxx://foo.bar/path/to/fstab.json";
        builder.preloadSchema(uri, node);
        node = Example10.loadResource("/split/mntent.json");
        uri = "xxx://foo.bar/path/to/mntent.json";
        builder.preloadSchema(uri, node);
        JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().setLoadingConfiguration(builder.freeze()).freeze();
        JsonSchema schema = factory.getJsonSchema("xxx://foo.bar/path/to/fstab.json");
        JsonNode good = Example10.loadResource("/fstab-good.json");
        JsonNode bad = Example10.loadResource("/fstab-bad.json");
        JsonNode bad2 = Example10.loadResource("/fstab-bad2.json");
        ProcessingReport report = schema.validate(good);
        Example10.printReport(report);
        report = schema.validate(bad);
        Example10.printReport(report);
        report = schema.validate(bad2);
        Example10.printReport(report);
    }
}

