/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.taskdefs.compilers;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import shadow.org.apache.tools.ant.BuildException;
import shadow.org.apache.tools.ant.taskdefs.LogOutputStream;
import shadow.org.apache.tools.ant.taskdefs.compilers.DefaultCompilerAdapter;
import shadow.org.apache.tools.ant.types.Commandline;
import shadow.org.apache.tools.ant.util.FileUtils;
import shadow.org.apache.tools.ant.util.JavaEnvUtils;

public class Javac12
extends DefaultCompilerAdapter {
    protected static final String CLASSIC_COMPILER_CLASSNAME = "sun.tools.javac.Main";

    public boolean execute() throws BuildException {
        this.attributes.log("Using classic compiler", 3);
        Commandline cmd = this.setupJavacCommand(true);
        LogOutputStream logstr = new LogOutputStream(this.attributes, 1);
        try {
            Class<?> c = Class.forName(CLASSIC_COMPILER_CLASSNAME);
            Constructor<?> cons = c.getConstructor(OutputStream.class, String.class);
            Object compiler = cons.newInstance(logstr, "javac");
            Method compile = c.getMethod("compile", String[].class);
            Boolean ok = (Boolean)compile.invoke(compiler, new Object[]{cmd.getArguments()});
            boolean bl = ok;
            return bl;
        }
        catch (ClassNotFoundException ex) {
            throw new BuildException("Cannot use classic compiler , as it is not available. \n A common solution is to set the environment variable JAVA_HOME to your jdk directory.\nIt is currently set to \"" + JavaEnvUtils.getJavaHome() + "\"", this.location);
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException("Error starting classic compiler: ", ex, this.location);
        }
        finally {
            FileUtils.close(logstr);
        }
    }
}

