/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image.coil;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Spanned;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import coil.Coil;
import coil.ImageLoader;
import coil.request.Disposable;
import coil.request.ImageRequest;
import coil.target.Target;
import io.noties.markwon.AbstractMarkwonPlugin;
import io.noties.markwon.MarkwonConfiguration;
import io.noties.markwon.MarkwonSpansFactory;
import io.noties.markwon.SpanFactory;
import io.noties.markwon.image.AsyncDrawable;
import io.noties.markwon.image.AsyncDrawableLoader;
import io.noties.markwon.image.AsyncDrawableScheduler;
import io.noties.markwon.image.DrawableUtils;
import io.noties.markwon.image.ImageSpanFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.commonmark.node.Image;

public class CoilImagesPlugin
extends AbstractMarkwonPlugin {
    private final CoilAsyncDrawableLoader coilAsyncDrawableLoader;

    @NonNull
    public static CoilImagesPlugin create(final @NonNull Context context) {
        return CoilImagesPlugin.create(new CoilStore(){

            @Override
            @NonNull
            public ImageRequest load(@NonNull AsyncDrawable drawable) {
                return new ImageRequest.Builder(context).data((Object)drawable.getDestination()).build();
            }

            @Override
            public void cancel(@NonNull Disposable disposable) {
                disposable.dispose();
            }
        }, Coil.imageLoader((Context)context));
    }

    @NonNull
    public static CoilImagesPlugin create(final @NonNull Context context, @NonNull ImageLoader imageLoader) {
        return CoilImagesPlugin.create(new CoilStore(){

            @Override
            @NonNull
            public ImageRequest load(@NonNull AsyncDrawable drawable) {
                return new ImageRequest.Builder(context).data((Object)drawable.getDestination()).build();
            }

            @Override
            public void cancel(@NonNull Disposable disposable) {
                disposable.dispose();
            }
        }, imageLoader);
    }

    @NonNull
    public static CoilImagesPlugin create(@NonNull CoilStore coilStore, @NonNull ImageLoader imageLoader) {
        return new CoilImagesPlugin(coilStore, imageLoader);
    }

    CoilImagesPlugin(@NonNull CoilStore coilStore, @NonNull ImageLoader imageLoader) {
        this.coilAsyncDrawableLoader = new CoilAsyncDrawableLoader(coilStore, imageLoader);
    }

    public void configureSpansFactory(@NonNull MarkwonSpansFactory.Builder builder) {
        builder.setFactory(Image.class, (SpanFactory)new ImageSpanFactory());
    }

    public void configureConfiguration(@NonNull MarkwonConfiguration.Builder builder) {
        builder.asyncDrawableLoader((AsyncDrawableLoader)this.coilAsyncDrawableLoader);
    }

    public void beforeSetText(@NonNull TextView textView, @NonNull Spanned markdown) {
        AsyncDrawableScheduler.unschedule((TextView)textView);
    }

    public void afterSetText(@NonNull TextView textView) {
        AsyncDrawableScheduler.schedule((TextView)textView);
    }

    private static class CoilAsyncDrawableLoader
    extends AsyncDrawableLoader {
        private final CoilStore coilStore;
        private final ImageLoader imageLoader;
        private final Map<AsyncDrawable, Disposable> cache = new HashMap<AsyncDrawable, Disposable>(2);

        CoilAsyncDrawableLoader(@NonNull CoilStore coilStore, @NonNull ImageLoader imageLoader) {
            this.coilStore = coilStore;
            this.imageLoader = imageLoader;
        }

        public void load(@NonNull AsyncDrawable drawable) {
            AtomicBoolean loaded = new AtomicBoolean(false);
            AsyncDrawableTarget target = new AsyncDrawableTarget(drawable, loaded);
            ImageRequest request = this.coilStore.load(drawable).newBuilder().target((Target)target).build();
            Disposable disposable = this.imageLoader.enqueue(request);
            if (!loaded.get()) {
                loaded.set(true);
                this.cache.put(drawable, disposable);
            }
        }

        public void cancel(@NonNull AsyncDrawable drawable) {
            Disposable disposable = this.cache.remove(drawable);
            if (disposable != null) {
                this.coilStore.cancel(disposable);
            }
        }

        @Nullable
        public Drawable placeholder(@NonNull AsyncDrawable drawable) {
            return null;
        }

        private class AsyncDrawableTarget
        implements Target {
            private final AsyncDrawable drawable;
            private final AtomicBoolean loaded;

            private AsyncDrawableTarget(@NonNull AsyncDrawable drawable, AtomicBoolean loaded) {
                this.drawable = drawable;
                this.loaded = loaded;
            }

            public void onSuccess(@NonNull Drawable loadedDrawable) {
                if (CoilAsyncDrawableLoader.this.cache.remove(this.drawable) != null || !this.loaded.get()) {
                    this.loaded.set(true);
                    if (this.drawable.isAttached()) {
                        DrawableUtils.applyIntrinsicBoundsIfEmpty((Drawable)loadedDrawable);
                        this.drawable.setResult(loadedDrawable);
                    }
                }
            }

            public void onStart(@Nullable Drawable placeholder) {
                if (placeholder != null && this.drawable.isAttached()) {
                    DrawableUtils.applyIntrinsicBoundsIfEmpty((Drawable)placeholder);
                    this.drawable.setResult(placeholder);
                }
            }

            public void onError(@Nullable Drawable errorDrawable) {
                if (CoilAsyncDrawableLoader.this.cache.remove(this.drawable) != null && errorDrawable != null && this.drawable.isAttached()) {
                    DrawableUtils.applyIntrinsicBoundsIfEmpty((Drawable)errorDrawable);
                    this.drawable.setResult(errorDrawable);
                }
            }
        }
    }

    public static interface CoilStore {
        @NonNull
        public ImageRequest load(@NonNull AsyncDrawable var1);

        public void cancel(@NonNull Disposable var1);
    }
}

