/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.helper;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.ISODateTimeFormat;

public enum JodaHelper implements Helper<ReadableInstant>
{
    jodaPattern{

        @Override
        protected CharSequence safeApply(ReadableInstant time, Options options) {
            String pattern = (String)options.param(0, (Object)"M d y, H:m:s z");
            return DateTimeFormat.forPattern((String)pattern).print(time);
        }
    }
    ,
    jodaStyle{

        @Override
        protected CharSequence safeApply(ReadableInstant time, Options options) {
            String style = (String)options.param(0, (Object)"MM");
            return DateTimeFormat.forStyle((String)style).print(time);
        }
    }
    ,
    jodaISO{

        @Override
        protected CharSequence safeApply(ReadableInstant time, Options options) {
            boolean includeMillis = (Boolean)options.param(1, (Object)false);
            if (includeMillis) {
                return ISODateTimeFormat.dateTime().print(time);
            }
            return ISODateTimeFormat.dateTimeNoMillis().print(time);
        }
    };


    public Object apply(ReadableInstant time, Options options) throws IOException {
        return this.safeApply(time, options);
    }

    protected abstract CharSequence safeApply(ReadableInstant var1, Options var2);
}

