/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.reader;

import com.github.kongchen.swagger.docgen.jaxrs.BeanParamInjectParamExtention;
import com.github.kongchen.swagger.docgen.jaxrs.JaxrsParameterExtension;
import com.github.kongchen.swagger.docgen.reader.SpringMvcApiReader;
import com.github.kongchen.swagger.docgen.spring.SpringSwaggerExtension;
import com.sun.jersey.api.core.InjectParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import io.swagger.annotations.ResponseHeader;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.jersey.SwaggerJerseyJaxrs;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.util.ParameterProcessor;
import io.swagger.util.PathUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.BeanParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.maven.plugin.logging.Log;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;

public abstract class AbstractReader {
    protected final Log LOG;
    protected Swagger swagger;
    private Set<Type> typesToSkip = new HashSet<Type>();

    public Set<Type> getTypesToSkip() {
        return this.typesToSkip;
    }

    public void setTypesToSkip(List<Type> typesToSkip) {
        this.typesToSkip = new HashSet<Type>(typesToSkip);
    }

    public void setTypesToSkip(Set<Type> typesToSkip) {
        this.typesToSkip = typesToSkip;
    }

    public void addTypeToSkippedTypes(Type type) {
        this.typesToSkip.add(type);
    }

    public AbstractReader(Swagger swagger, Log LOG) {
        this.swagger = swagger;
        this.LOG = LOG;
        this.updateExtensionChain();
    }

    private void updateExtensionChain() {
        ArrayList<Object> extensions = new ArrayList<Object>();
        Class<?> clazz = this.getClass();
        if (clazz == SpringMvcApiReader.class || SpringMvcApiReader.class.isAssignableFrom(clazz)) {
            extensions.add((Object)new SpringSwaggerExtension());
        } else {
            extensions.add((Object)new BeanParamInjectParamExtention());
            extensions.add(new SwaggerJerseyJaxrs());
            extensions.add((Object)new JaxrsParameterExtension());
        }
        SwaggerExtensions.setExtensions(extensions);
    }

    protected List<SecurityRequirement> getSecurityRequirements(Api api) {
        ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
        for (Authorization auth : api.authorizations()) {
            if (auth.value().isEmpty()) continue;
            SecurityRequirement security = new SecurityRequirement();
            security.setName(auth.value());
            for (AuthorizationScope scope : auth.scopes()) {
                if (scope.scope().isEmpty()) continue;
                security.addScope(scope.scope());
            }
            securities.add(security);
        }
        return securities;
    }

    protected String parseOperationPath(String operationPath, Map<String, String> regexMap) {
        return PathUtils.parsePath((String)operationPath, regexMap);
    }

    protected void updateOperationParameters(List<Parameter> parentParameters, Map<String, String> regexMap, Operation operation) {
        if (parentParameters != null) {
            for (Parameter param : parentParameters) {
                operation.parameter(param);
            }
        }
        for (Parameter param : operation.getParameters()) {
            String pattern = regexMap.get(param.getName());
            if (pattern == null) continue;
            param.setPattern(pattern);
        }
    }

    protected Map<String, Property> parseResponseHeaders(ResponseHeader[] headers) {
        if (headers == null) {
            return null;
        }
        HashMap<String, ArrayProperty> responseHeaders = null;
        for (ResponseHeader header : headers) {
            Property property;
            Class cls;
            if (header.name().isEmpty()) continue;
            if (responseHeaders == null) {
                responseHeaders = new HashMap<String, ArrayProperty>();
            }
            if ((cls = header.response()).equals(Void.class) || cls.equals(Void.TYPE) || (property = ModelConverters.getInstance().readAsProperty((Type)cls)) == null) continue;
            Object responseProperty = header.responseContainer().equalsIgnoreCase("list") ? new ArrayProperty(property) : (header.responseContainer().equalsIgnoreCase("map") ? new MapProperty(property) : property);
            responseProperty.setDescription(header.description());
            responseHeaders.put(header.name(), (ArrayProperty)responseProperty);
        }
        return responseHeaders;
    }

    protected Set<Map<String, Object>> parseCustomExtensions(Extension[] extensions) {
        if (extensions == null) {
            return Collections.emptySet();
        }
        HashSet<Map<String, Object>> resultSet = new HashSet<Map<String, Object>>();
        for (Extension extension : extensions) {
            if (extension == null) continue;
            HashMap<String, String> extensionProperties = new HashMap<String, String>();
            for (ExtensionProperty extensionProperty : extension.properties()) {
                String name = extensionProperty.name();
                if (name.isEmpty()) continue;
                String value = extensionProperty.value();
                extensionProperties.put(name, value);
            }
            if (!extension.name().isEmpty()) {
                HashMap<String, HashMap<String, String>> wrapper = new HashMap<String, HashMap<String, String>>();
                wrapper.put(extension.name(), extensionProperties);
                resultSet.add(wrapper);
                continue;
            }
            resultSet.add(extensionProperties);
        }
        return resultSet;
    }

    protected void updatePath(String operationPath, String httpMethod, Operation operation) {
        if (httpMethod == null) {
            return;
        }
        Path path = this.swagger.getPath(operationPath);
        if (path == null) {
            path = new Path();
            this.swagger.path(operationPath, path);
        }
        path.set(httpMethod, operation);
    }

    protected void updateTagsForOperation(Operation operation, ApiOperation apiOperation) {
        if (apiOperation == null) {
            return;
        }
        for (String tag : apiOperation.tags()) {
            if (tag.isEmpty()) continue;
            operation.tag(tag);
            this.swagger.tag(new Tag().name(tag));
        }
    }

    protected boolean canReadApi(boolean readHidden, Api api) {
        return api != null && readHidden || api != null && !api.hidden();
    }

    protected Set<Tag> extractTags(Api api) {
        String tagString;
        LinkedHashSet<Tag> output = new LinkedHashSet<Tag>();
        boolean hasExplicitTags = false;
        for (String tag : api.tags()) {
            if (tag.isEmpty()) continue;
            hasExplicitTags = true;
            output.add(new Tag().name(tag));
        }
        if (!hasExplicitTags && !(tagString = api.value().replace("/", "")).isEmpty()) {
            Tag tag = new Tag().name(tagString);
            if (!api.description().isEmpty()) {
                tag.description(api.description());
            }
            output.add(tag);
        }
        return output;
    }

    protected void updateOperationProtocols(ApiOperation apiOperation, Operation operation) {
        String[] protocols;
        for (String protocol : protocols = apiOperation.protocols().split(",")) {
            String trimmed = protocol.trim();
            if (trimmed.isEmpty()) continue;
            operation.scheme(Scheme.forValue((String)trimmed));
        }
    }

    protected Map<String, Tag> updateTagsForApi(Map<String, Tag> parentTags, Api api) {
        HashMap<String, Tag> tagsMap = new HashMap<String, Tag>();
        for (Tag tag : this.extractTags(api)) {
            tagsMap.put(tag.getName(), tag);
        }
        if (parentTags != null) {
            tagsMap.putAll(parentTags);
        }
        for (Tag tag : tagsMap.values()) {
            this.swagger.tag(tag);
        }
        return tagsMap;
    }

    protected boolean isPrimitive(Type cls) {
        boolean isPrimitive = false;
        Property property = ModelConverters.getInstance().readAsProperty(cls);
        if (property == null) {
            isPrimitive = false;
        } else if ("integer".equals(property.getType())) {
            isPrimitive = true;
        } else if ("string".equals(property.getType())) {
            isPrimitive = true;
        } else if ("number".equals(property.getType())) {
            isPrimitive = true;
        } else if ("boolean".equals(property.getType())) {
            isPrimitive = true;
        } else if ("array".equals(property.getType())) {
            isPrimitive = true;
        } else if ("file".equals(property.getType())) {
            isPrimitive = true;
        }
        return isPrimitive;
    }

    protected void updateOperation(String[] apiConsumes, String[] apiProduces, Map<String, Tag> tags, List<SecurityRequirement> securities, Operation operation) {
        if (operation == null) {
            return;
        }
        if (operation.getConsumes() == null) {
            for (String string : apiConsumes) {
                operation.consumes(string);
            }
        }
        if (operation.getProduces() == null) {
            for (String string : apiProduces) {
                operation.produces(string);
            }
        }
        if (operation.getTags() == null) {
            for (String tagString : tags.keySet()) {
                operation.tag(tagString);
            }
        }
        for (SecurityRequirement security : securities) {
            operation.security(security);
        }
    }

    private boolean isApiParamHidden(List<Annotation> parameterAnnotations) {
        for (Annotation parameterAnnotation : parameterAnnotations) {
            if (!(parameterAnnotation instanceof ApiParam)) continue;
            return ((ApiParam)parameterAnnotation).hidden();
        }
        return false;
    }

    private boolean hasValidAnnotations(List<Annotation> parameterAnnotations) {
        ArrayList<Class<RequestPart>> validParameterAnnotations = new ArrayList<Class<RequestPart>>();
        validParameterAnnotations.add(ModelAttribute.class);
        validParameterAnnotations.add(BeanParam.class);
        validParameterAnnotations.add(InjectParam.class);
        validParameterAnnotations.add(ApiParam.class);
        validParameterAnnotations.add(PathParam.class);
        validParameterAnnotations.add(QueryParam.class);
        validParameterAnnotations.add(HeaderParam.class);
        validParameterAnnotations.add(FormParam.class);
        validParameterAnnotations.add(RequestParam.class);
        validParameterAnnotations.add(RequestBody.class);
        validParameterAnnotations.add(PathVariable.class);
        validParameterAnnotations.add(RequestHeader.class);
        validParameterAnnotations.add(RequestPart.class);
        boolean hasValidAnnotation = false;
        for (Annotation potentialAnnotation : parameterAnnotations) {
            if (!validParameterAnnotations.contains(potentialAnnotation.annotationType())) continue;
            hasValidAnnotation = true;
            break;
        }
        return hasValidAnnotation;
    }

    protected List<Parameter> getParameters(Type type, List<Annotation> annotations) {
        if (!this.hasValidAnnotations(annotations) || this.isApiParamHidden(annotations)) {
            return Collections.emptyList();
        }
        Iterator chain = SwaggerExtensions.chain();
        List<Object> parameters = new ArrayList<Parameter>();
        Class cls = TypeUtils.getRawType((Type)type, (Type)type);
        this.LOG.debug((CharSequence)("Looking for path/query/header/form/cookie params in " + cls));
        if (chain.hasNext()) {
            SwaggerExtension extension = (SwaggerExtension)chain.next();
            this.LOG.debug((CharSequence)("trying extension " + extension));
            parameters = extension.extractParameters(annotations, type, this.typesToSkip, chain);
        }
        if (!parameters.isEmpty()) {
            for (Parameter parameter : parameters) {
                ParameterProcessor.applyAnnotations((Swagger)this.swagger, (Parameter)parameter, (Type)type, annotations);
                Parameter parameter2 = this.fixCollectionFormatForArrayTypes(cls, parameter);
            }
        } else {
            Parameter param;
            this.LOG.debug((CharSequence)("Looking for body params in " + cls));
            if (!this.typesToSkip.contains(type) && (param = ParameterProcessor.applyAnnotations((Swagger)this.swagger, null, (Type)type, annotations)) != null) {
                parameters.add(param);
            }
        }
        return parameters;
    }

    private Parameter fixCollectionFormatForArrayTypes(Class<?> cls, Parameter parameter) {
        if (!(parameter instanceof AbstractSerializableParameter)) {
            return parameter;
        }
        AbstractSerializableParameter p = (AbstractSerializableParameter)parameter;
        String in = p.getIn();
        if (!"query".equals(in) && !"formData".equals(in)) {
            return parameter;
        }
        if (p.getItems() != null && "csv".equals(p.getCollectionFormat()) && (Collection.class.isAssignableFrom(cls) || cls.isArray())) {
            p.collectionFormat("multi");
            parameter = p;
        }
        return parameter;
    }

    protected void updateApiResponse(Operation operation, ApiResponses responseAnnotation) {
        for (ApiResponse apiResponse : responseAnnotation.value()) {
            Map<String, Property> responseHeaders = this.parseResponseHeaders(apiResponse.responseHeaders());
            Class responseClass = apiResponse.response();
            Response response = new Response().description(apiResponse.message()).headers(responseHeaders);
            if (responseClass.equals(Void.class)) {
                Response apiOperationResponse;
                if (operation.getResponses() != null && (apiOperationResponse = (Response)operation.getResponses().get(String.valueOf(apiResponse.code()))) != null) {
                    response.setSchema(apiOperationResponse.getSchema());
                }
            } else {
                Response response2;
                Map responses;
                Map models = ModelConverters.getInstance().read((Type)responseClass);
                for (String string : models.keySet()) {
                    RefProperty schema = new RefProperty().asDefault(string);
                    if (apiResponse.responseContainer().equals("List")) {
                        response.schema((Property)new ArrayProperty((Property)schema));
                    } else {
                        response.schema((Property)schema);
                    }
                    this.swagger.model(string, (Model)models.get(string));
                }
                models = ModelConverters.getInstance().readAll((Type)responseClass);
                for (Map.Entry entry : models.entrySet()) {
                    this.swagger.model((String)entry.getKey(), (Model)entry.getValue());
                }
                if (response.getSchema() == null && (responses = operation.getResponses()) != null && (response2 = (Response)responses.get(String.valueOf(apiResponse.code()))) != null) {
                    response.setSchema(response2.getSchema());
                }
            }
            if (apiResponse.code() == 0) {
                operation.defaultResponse(response);
                continue;
            }
            operation.response(apiResponse.code(), response);
        }
    }

    protected String[] updateOperationProduces(String[] parentProduces, String[] apiProduces, Operation operation) {
        if (parentProduces != null) {
            HashSet<String> both = new HashSet<String>(Arrays.asList(apiProduces));
            both.addAll(Arrays.asList(parentProduces));
            if (operation.getProduces() != null) {
                both.addAll(new HashSet(operation.getProduces()));
            }
            apiProduces = both.toArray(new String[both.size()]);
        }
        return apiProduces;
    }

    protected String[] updateOperationConsumes(String[] parentConsumes, String[] apiConsumes, Operation operation) {
        if (parentConsumes != null) {
            HashSet<String> both = new HashSet<String>(Arrays.asList(apiConsumes));
            both.addAll(Arrays.asList(parentConsumes));
            if (operation.getConsumes() != null) {
                both.addAll(operation.getConsumes());
            }
            apiConsumes = both.toArray(new String[both.size()]);
        }
        return apiConsumes;
    }

    protected void readImplicitParameters(Method method, Operation operation) {
        ApiImplicitParams implicitParams = (ApiImplicitParams)AnnotationUtils.findAnnotation((Method)method, ApiImplicitParams.class);
        if (implicitParams == null) {
            return;
        }
        for (ApiImplicitParam param : implicitParams.value()) {
            Class<?> cls;
            try {
                cls = Class.forName(param.dataType());
            }
            catch (ClassNotFoundException e) {
                cls = method.getDeclaringClass();
            }
            Parameter p = this.readImplicitParam(param, cls);
            if (p == null) continue;
            operation.addParameter(p);
        }
    }

    protected Parameter readImplicitParam(ApiImplicitParam param, Class<?> apiClass) {
        PathParameter parameter;
        if (param.paramType().equalsIgnoreCase("path")) {
            parameter = new PathParameter();
        } else if (param.paramType().equalsIgnoreCase("query")) {
            parameter = new QueryParameter();
        } else if (param.paramType().equalsIgnoreCase("form") || param.paramType().equalsIgnoreCase("formData")) {
            parameter = new FormParameter();
        } else if (param.paramType().equalsIgnoreCase("body")) {
            parameter = new BodyParameter();
        } else if (param.paramType().equalsIgnoreCase("header")) {
            parameter = new HeaderParameter();
        } else {
            return null;
        }
        return ParameterProcessor.applyAnnotations((Swagger)this.swagger, (Parameter)parameter, apiClass, Arrays.asList(param));
    }
}

