/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.AttributedString;
import java.text.Bidi;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LayoutProcessor {
    private static final int DEFAULT_FLAGS = -1;
    private static final Map<BaseFont, java.awt.Font> awtFontMap = new ConcurrentHashMap<BaseFont, java.awt.Font>();
    private static final Map<TextAttribute, Object> globalTextAttributes = new ConcurrentHashMap<TextAttribute, Object>();
    private static boolean enabled = false;
    private static int flags = -1;

    private LayoutProcessor() {
        throw new UnsupportedOperationException("static class");
    }

    public static void enable() {
        enabled = true;
    }

    public static void enable(int flags) {
        if (enabled) {
            throw new UnsupportedOperationException("LayoutProcessor is already enabled");
        }
        enabled = true;
        LayoutProcessor.flags = flags;
    }

    public static void enableKernLiga() {
        LayoutProcessor.enableKernLiga(-1);
    }

    public static void enableKernLiga(int flags) {
        if (enabled) {
            throw new UnsupportedOperationException("LayoutProcessor is already enabled");
        }
        LayoutProcessor.setKerning();
        LayoutProcessor.setLigatures();
        enabled = true;
        LayoutProcessor.flags = flags;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setKerning() {
        globalTextAttributes.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
    }

    public static void setKerning(Font font) {
        HashMap<TextAttribute, Object> textAttributes = new HashMap<TextAttribute, Object>();
        textAttributes.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
        LayoutProcessor.setTextAttributes(font, textAttributes);
    }

    public static void setLigatures() {
        globalTextAttributes.put(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON);
    }

    public static void setLigatures(Font font) {
        HashMap<TextAttribute, Object> textAttributes = new HashMap<TextAttribute, Object>();
        textAttributes.put(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON);
        LayoutProcessor.setTextAttributes(font, textAttributes);
    }

    public static void setRunDirectionRtl(Font font) {
        LayoutProcessor.setRunDirection(font, TextAttribute.RUN_DIRECTION_RTL);
    }

    public static void setRunDirectionLtr(Font font) {
        LayoutProcessor.setRunDirection(font, TextAttribute.RUN_DIRECTION_LTR);
    }

    private static void setRunDirection(Font font, Boolean runDirection) {
        HashMap<TextAttribute, Object> textAttributes = new HashMap<TextAttribute, Object>();
        textAttributes.put(TextAttribute.RUN_DIRECTION, runDirection);
        LayoutProcessor.setTextAttributes(font, textAttributes);
    }

    private static void setTextAttributes(Font font, Map<TextAttribute, Object> textAttributes) {
        BaseFont baseFont = font.getBaseFont();
        java.awt.Font awtFont = awtFontMap.get(baseFont);
        if (awtFont != null) {
            awtFont = awtFont.deriveFont(textAttributes);
            awtFontMap.put(baseFont, awtFont);
        }
    }

    public static int getFlags() {
        return flags;
    }

    public static boolean isSet(int queryFlags) {
        return flags != -1 && (flags & queryFlags) == queryFlags;
    }

    public static boolean supportsFont(BaseFont baseFont) {
        return enabled && awtFontMap.get(baseFont) != null;
    }

    public static void loadFont(BaseFont baseFont, String filename) {
        if (!enabled) {
            return;
        }
        InputStream inputStream = null;
        try {
            java.awt.Font awtFont = awtFontMap.get(baseFont);
            if (awtFont == null) {
                File file = new File(filename);
                if (!file.exists() && FontFactory.isRegistered(filename)) {
                    filename = (String)FontFactory.getFontImp().getFontPath(filename);
                    file = new File(filename);
                }
                if ((inputStream = file.canRead() ? Files.newInputStream(file.toPath(), new OpenOption[0]) : (filename.startsWith("file:/") || filename.startsWith("http://") || filename.startsWith("https://") || filename.startsWith("jar:") || filename.startsWith("wsjar:") ? new URL(filename).openStream() : ("-".equals(filename) ? System.in : BaseFont.getResourceStream(filename)))) == null) {
                    throw new IOException(MessageLocalization.getComposedMessage("1.not.found.as.file.or.resource", filename));
                }
                awtFont = java.awt.Font.createFont(0, inputStream);
                if (awtFont != null) {
                    if (globalTextAttributes.size() > 0) {
                        awtFont = awtFont.deriveFont(globalTextAttributes);
                    }
                    awtFontMap.put(baseFont, awtFont);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Font creation failed for %s.", filename), e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static GlyphVector computeGlyphVector(BaseFont baseFont, float fontSize, String text) {
        Object runDirection;
        java.awt.Font awtFont;
        Map<TextAttribute, ?> textAttributes;
        char[] chars = text.toCharArray();
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), false, true);
        int localFlags = flags;
        if (localFlags == -1) {
            AttributedString as = new AttributedString(text);
            Bidi bidi = new Bidi(as.getIterator());
            int n = localFlags = bidi.isLeftToRight() ? 0 : 1;
        }
        if ((textAttributes = (awtFont = awtFontMap.get(baseFont).deriveFont(fontSize)).getAttributes()) != null && (runDirection = textAttributes.get(TextAttribute.RUN_DIRECTION)) != null) {
            localFlags = runDirection == TextAttribute.RUN_DIRECTION_LTR ? 0 : 1;
        }
        return awtFont.layoutGlyphVector(fontRenderContext, chars, 0, chars.length, localFlags);
    }

    private static boolean hasAdjustments(GlyphVector glyphVector) {
        boolean retVal = false;
        float lastX = 0.0f;
        float lastY = 0.0f;
        for (int i = 0; i < glyphVector.getNumGlyphs(); ++i) {
            float ay;
            Point2D p = glyphVector.getGlyphPosition(i);
            float dx = (float)p.getX() - lastX;
            float dy = (float)p.getY() - lastY;
            float ax = i == 0 ? 0.0f : glyphVector.getGlyphMetrics(i - 1).getAdvanceX();
            float f = ay = i == 0 ? 0.0f : glyphVector.getGlyphMetrics(i - 1).getAdvanceY();
            if (dx != ax || dy != ay) {
                retVal = true;
                break;
            }
            lastX = (float)p.getX();
            lastY = (float)p.getY();
        }
        return retVal;
    }

    public static Point2D showText(PdfContentByte cb, BaseFont baseFont, float fontSize, String text) {
        GlyphVector glyphVector = LayoutProcessor.computeGlyphVector(baseFont, fontSize, text);
        if (!LayoutProcessor.hasAdjustments(glyphVector)) {
            cb.showText(glyphVector);
            Point2D p = glyphVector.getGlyphPosition(glyphVector.getNumGlyphs());
            float dx = (float)p.getX();
            float dy = (float)p.getY();
            cb.moveTextBasic(dx, -dy);
            return new Point2D.Double(-dx, dy);
        }
        float lastX = 0.0f;
        float lastY = 0.0f;
        for (int i = 0; i < glyphVector.getNumGlyphs(); ++i) {
            Point2D p = glyphVector.getGlyphPosition(i);
            float dx = (float)p.getX() - lastX;
            float dy = (float)p.getY() - lastY;
            cb.moveTextBasic(dx, -dy);
            cb.showText(glyphVector, i, i + 1);
            lastX = (float)p.getX();
            lastY = (float)p.getY();
        }
        Point2D p = glyphVector.getGlyphPosition(glyphVector.getNumGlyphs());
        float dx = (float)p.getX() - lastX;
        float dy = (float)p.getY() - lastY;
        cb.moveTextBasic(dx, -dy);
        return new Point2D.Double(-p.getX(), p.getY());
    }
}

