/*
 * Decompiled with CFR 0.152.
 */
package org.dojotoolkit.shrinksafe;

import java.util.Map;
import org.dojotoolkit.shrinksafe.DebugData;

public class ReplacedTokens {
    private int[] parents = null;
    private Map replacements = null;
    private Map lookup = null;
    private DebugData debugData = null;

    public ReplacedTokens(Map replacements, int[] parents, Map lookup, DebugData debugData) {
        this.replacements = replacements;
        this.parents = parents;
        this.lookup = lookup;
        this.debugData = debugData;
    }

    public String find(String token) {
        String replacedToken = null;
        if (this.replacements != null) {
            replacedToken = (String)this.replacements.get(token);
        }
        if (replacedToken == null) {
            for (int i = this.parents.length; i > 0; --i) {
                int parentPos = this.parents[i - 1];
                ReplacedTokens parent = (ReplacedTokens)this.lookup.get(new Integer(parentPos));
                if (parent.replacements != null && (replacedToken = (String)parent.replacements.get(token)) != null) break;
            }
        }
        if (replacedToken == null) {
            replacedToken = token;
        }
        return replacedToken;
    }

    public String printDebugData() {
        StringBuffer sb = new StringBuffer();
        if (this.debugData != null) {
            sb.append("Start:" + this.debugData.start);
            sb.append(' ');
            sb.append("End:" + this.debugData.end);
            sb.append(' ');
            sb.append("Compressed Start:" + this.debugData.compressedStart);
            sb.append(' ');
            sb.append("Compressed End:" + this.debugData.compressedEnd);
            sb.append(' ');
            if (this.debugData.paramAndVarNames != null) {
                sb.append("Params and Vars: [");
                for (String paramVar : this.debugData.paramAndVarNames) {
                    sb.append(paramVar);
                    sb.append(' ');
                }
                sb.append("]\n");
            }
            if (this.replacements != null && this.replacements.size() > 0) {
                sb.append("\t");
                sb.append("Replacements:\n");
                for (String token : this.replacements.keySet()) {
                    String replacement;
                    if (token.equals(replacement = (String)this.replacements.get(token))) continue;
                    sb.append("\t\t");
                    sb.append('[');
                    sb.append(token);
                    sb.append(']');
                    sb.append(" replaced with ");
                    sb.append('[');
                    sb.append(replacement);
                    sb.append(']');
                    sb.append('\n');
                }
                sb.append("\n");
            }
            for (int i = this.parents.length; i > 0; --i) {
                int parentPos = this.parents[i - 1];
                ReplacedTokens parent = (ReplacedTokens)this.lookup.get(new Integer(parentPos));
                if (parent.replacements == null || parent.replacements.size() <= 0) continue;
                sb.append("\t");
                sb.append("Parent Replacements level [" + i + "]:\n");
                for (String token : parent.replacements.keySet()) {
                    String replacement;
                    if (token.equals(replacement = (String)parent.replacements.get(token))) continue;
                    sb.append("\t\t");
                    sb.append('[');
                    sb.append(token);
                    sb.append(']');
                    sb.append(" replaced with ");
                    sb.append('[');
                    sb.append(replacement);
                    sb.append(']');
                    sb.append('\n');
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public String toJson() {
        StringBuffer json = new StringBuffer();
        json.append('{');
        if (this.debugData != null) {
            json.append("start: " + this.debugData.start);
            json.append(", ");
            json.append("end: " + this.debugData.end);
            json.append(", ");
            json.append("compressedStart: " + this.debugData.compressedStart);
            json.append(", ");
            json.append("compressedEnd: " + this.debugData.compressedEnd);
            json.append(", ");
            json.append("replacements: {");
            if (this.replacements != null && this.replacements.size() > 0) {
                json.append(ReplacedTokens.replacementsToJson(this.replacements));
            }
            json.append('}');
            if (this.parents.length > 0) {
                json.append(", ");
                json.append("parentReplacements: [");
            }
            int count = 1;
            for (int i = 0; i < this.parents.length; ++i) {
                json.append('{');
                int parentPos = this.parents[i];
                ReplacedTokens parent = (ReplacedTokens)this.lookup.get(new Integer(parentPos));
                if (parent.replacements != null && parent.replacements.size() > 0) {
                    json.append(ReplacedTokens.replacementsToJson(parent.replacements));
                }
                json.append('}');
                if (count++ >= this.parents.length) continue;
                json.append(", ");
            }
            if (this.parents.length > 0) {
                json.append("]");
            }
        }
        json.append("}");
        return json.toString();
    }

    private static String replacementsToJson(Map replacements) {
        StringBuffer sb = new StringBuffer();
        int count = 1;
        for (String token : replacements.keySet()) {
            String replacement = (String)replacements.get(token);
            sb.append("\"" + replacement + '\"');
            sb.append(" : ");
            sb.append("\"" + token + "\"");
            if (count++ >= replacements.size()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

