/*
 * Decompiled with CFR 0.152.
 */
package com.github.lwaddicor.springstartupanalysis;

import com.github.lwaddicor.springstartupanalysis.dto.StartTimeSquareDto;
import com.github.lwaddicor.springstartupanalysis.dto.StartTimeStatisticDto;
import java.util.LinkedList;
import java.util.List;
import pd.treemap.MapItem;
import pd.treemap.MapModel;
import pd.treemap.Mappable;

public class TreeMapModel
implements MapModel {
    private Mappable[] items;

    public TreeMapModel(List<StartTimeStatisticDto> timesAsArray, int width, int height) {
        this.items = new MapItem[timesAsArray.size()];
        double totalArea = width * height;
        double sum = timesAsArray.stream().mapToLong(StartTimeStatisticDto::getTime).sum();
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = new MapItem(totalArea / sum * (double)timesAsArray.get(i).getTime().longValue(), 0);
            this.items[i].setName(timesAsArray.get(i).getName());
            this.items[i].setOriginalSize(timesAsArray.get(i).getTime());
        }
    }

    public List<StartTimeSquareDto> getSquareItems() {
        LinkedList<StartTimeSquareDto> list = new LinkedList<StartTimeSquareDto>();
        for (Mappable item : this.items) {
            StartTimeSquareDto square = new StartTimeSquareDto();
            square.setName(item.getName());
            square.setTime(item.getOriginalSize());
            square.setLeft((int)item.getBounds().x);
            square.setRight((int)(item.getBounds().x + item.getBounds().w));
            square.setTop((int)item.getBounds().y);
            square.setBottom((int)(item.getBounds().y + item.getBounds().h));
            square.setWidth((int)item.getBounds().w);
            square.setHeight((int)item.getBounds().h);
            list.add(square);
        }
        return list;
    }

    @Override
    public Mappable[] getItems() {
        return this.items;
    }
}

