/*
 * Decompiled with CFR 0.152.
 */
package com.github.gradle.node.util;

import com.github.gradle.node.util.Platform;
import com.github.gradle.node.util.PlatformHelperKt;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a\u001c\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u001a\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004\u001a$\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e\u00a8\u0006\u000f"}, d2={"main", "", "args", "", "", "([Ljava/lang/String;)V", "parseOsArch", "arch", "uname", "Ljava/util/concurrent/Callable;", "parseOsName", "name", "parsePlatform", "Lcom/github/gradle/node/util/Platform;", "Lkotlin/Function0;", "gradle-node-plugin"})
public final class PlatformHelperKt {
    @NotNull
    public static final Platform parsePlatform(@NotNull String name2, @NotNull String arch, @NotNull Function0<String> uname2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        Intrinsics.checkNotNullParameter(uname2, (String)"uname");
        Function0<String> function0 = name2;
        String string = function0.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
        String string2 = PlatformHelperKt.parseOsName(string);
        function0 = arch;
        String string3 = function0.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase()");
        function0 = uname2;
        return new Platform(string2, PlatformHelperKt.parseOsArch(string3, new Callable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ Object call() {
                return this.function.invoke();
            }
        }));
    }

    @NotNull
    public static final String parseOsName(@NotNull String name2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (StringsKt.contains$default((CharSequence)name2, (CharSequence)"windows", (boolean)false, (int)2, null)) {
            string = "win";
        } else if (StringsKt.contains$default((CharSequence)name2, (CharSequence)"mac", (boolean)false, (int)2, null)) {
            string = "darwin";
        } else if (StringsKt.contains$default((CharSequence)name2, (CharSequence)"linux", (boolean)false, (int)2, null)) {
            string = "linux";
        } else if (StringsKt.contains$default((CharSequence)name2, (CharSequence)"freebsd", (boolean)false, (int)2, null)) {
            string = "linux";
        } else if (StringsKt.contains$default((CharSequence)name2, (CharSequence)"sunos", (boolean)false, (int)2, null)) {
            string = "sunos";
        } else {
            String string2 = "Unsupported OS: " + name2;
            throw new IllegalStateException(string2.toString());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String parseOsArch(@NotNull String arch, @NotNull Callable<String> uname2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
        Intrinsics.checkNotNullParameter(uname2, (String)"uname");
        if (Intrinsics.areEqual((Object)arch, (Object)"arm") || StringsKt.startsWith$default((String)arch, (String)"aarch", (boolean)false, (int)2, null)) {
            String string2;
            String string3;
            String $this$mapIf$iv = uname2.call();
            boolean $i$f$mapIf = false;
            String it = $this$mapIf$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)"armv8l") || Intrinsics.areEqual((Object)it, (Object)"aarch64")) {
                it = $this$mapIf$iv;
                boolean bl2 = false;
                string3 = "arm64";
            } else {
                string3 = $this$mapIf$iv;
            }
            $this$mapIf$iv = string3;
            $i$f$mapIf = false;
            it = $this$mapIf$iv;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)it, (Object)"x86_64")) {
                it = $this$mapIf$iv;
                boolean bl4 = false;
                string2 = "x64";
            } else {
                void var2_2;
                string2 = var2_2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uname.call()\n           \u2026it == \"x86_64\" }) {\"x64\"}");
            string = string2;
        } else {
            string = Intrinsics.areEqual((Object)arch, (Object)"ppc64le") ? "ppc64le" : (Intrinsics.areEqual((Object)arch, (Object)"s390x") ? "s390x" : (StringsKt.contains$default((CharSequence)arch, (CharSequence)"64", (boolean)false, (int)2, null) ? "x64" : "x86"));
        }
        return string;
    }

    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String osName2 = System.getProperty("os.name");
        String osArch2 = System.getProperty("os.arch");
        Function0 uname2 = main.uname.1.INSTANCE;
        String string = osName2;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"osName");
        String string2 = osArch2;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"osArch");
        Platform platform = PlatformHelperKt.parsePlatform(string, string2, (Function0<String>)uname2);
        String string3 = "Your os.name is: '" + osName2 + "' and is parsed as: '" + platform.getName() + '\'';
        System.out.println((Object)string3);
        string3 = "Your os.arch is: '" + osArch2 + "' and is parsed as: '" + platform.getArch() + '\'';
        System.out.println((Object)string3);
        if (platform.isWindows()) {
            string3 = "You're on windows (isWindows == true)";
            System.out.println((Object)string3);
        } else {
            string3 = "You're not on windows (isWindows == false)";
            System.out.println((Object)string3);
        }
    }
}

