/*
 * Decompiled with CFR 0.152.
 */
package com.github.gradle.node.variant;

import com.github.gradle.node.NodeExtension;
import com.github.gradle.node.util.Platform;
import com.github.gradle.node.util.ProviderKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u0007\u001a\u00020\u0004\u001a$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002\u001a\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u001a*\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"computeNodeArchiveDependency", "Lorg/gradle/api/provider/Provider;", "", "extension", "Lcom/github/gradle/node/NodeExtension;", "computeNodeDir", "Lorg/gradle/api/file/Directory;", "nodeExtension", "osName", "osArch", "computeNodeExec", "nodeBinDirProvider", "computeNpmScriptFile", "nodeDirProvider", "command", "isWindows", "", "gradle-node-plugin"})
public final class VariantComputerKt {
    @NotNull
    public static final Provider<String> computeNodeExec(@NotNull NodeExtension nodeExtension, @NotNull Provider<Directory> nodeBinDirProvider) {
        Intrinsics.checkNotNullParameter((Object)nodeExtension, (String)"nodeExtension");
        Intrinsics.checkNotNullParameter(nodeBinDirProvider, (String)"nodeBinDirProvider");
        Provider provider = ProviderKt.zip((Provider)nodeExtension.getDownload(), nodeBinDirProvider).map(new Transformer(nodeExtension){
            final /* synthetic */ NodeExtension $nodeExtension;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String transform(@NotNull Pair<Boolean, ? extends Directory> it) {
                String string;
                void download;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Pair<Boolean, ? extends Directory> pair = it;
                Boolean bl = (Boolean)pair.component1();
                Directory nodeBinDir = (Directory)pair.component2();
                void v0 = download;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"download");
                if (v0.booleanValue()) {
                    String nodeCommand = ((Platform)this.$nodeExtension.getResolvedPlatform().get()).isWindows() ? "node.exe" : "node";
                    Directory directory = nodeBinDir.dir(nodeCommand);
                    Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"nodeBinDir.dir(nodeCommand)");
                    File file = directory.getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"nodeBinDir.dir(nodeCommand).asFile");
                    string = file.getAbsolutePath();
                } else {
                    string = "node";
                }
                return string;
            }
            {
                this.$nodeExtension = nodeExtension;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"zip(nodeExtension.downlo\u2026      } else \"node\"\n    }");
        return provider;
    }

    @NotNull
    public static final Provider<String> computeNpmScriptFile(@NotNull Provider<Directory> nodeDirProvider, @NotNull String command, boolean isWindows) {
        Intrinsics.checkNotNullParameter(nodeDirProvider, (String)"nodeDirProvider");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Provider provider = nodeDirProvider.map(new Transformer(isWindows, command){
            final /* synthetic */ boolean $isWindows;
            final /* synthetic */ String $command;

            @NotNull
            public final String transform(@NotNull Directory nodeDir) {
                String string;
                Intrinsics.checkNotNullParameter((Object)nodeDir, (String)"nodeDir");
                if (this.$isWindows) {
                    Directory directory = nodeDir.dir("node_modules/npm/bin/" + this.$command + "-cli.js");
                    Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"nodeDir.dir(\"node_module\u2026npm/bin/$command-cli.js\")");
                    File file = directory.getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"nodeDir.dir(\"node_module\u2026/$command-cli.js\").asFile");
                    string = file.getPath();
                } else {
                    Directory directory = nodeDir.dir("lib/node_modules/npm/bin/" + this.$command + "-cli.js");
                    Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"nodeDir.dir(\"lib/node_mo\u2026npm/bin/$command-cli.js\")");
                    File file = directory.getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"nodeDir.dir(\"lib/node_mo\u2026/$command-cli.js\").asFile");
                    string = file.getPath();
                }
                return string;
            }
            {
                this.$isWindows = bl;
                this.$command = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"nodeDirProvider.map { no\u2026li.js\").asFile.path\n    }");
        return provider;
    }

    @NotNull
    public static final Provider<Directory> computeNodeDir(@NotNull NodeExtension nodeExtension) {
        Intrinsics.checkNotNullParameter((Object)nodeExtension, (String)"nodeExtension");
        String osName = ((Platform)nodeExtension.getResolvedPlatform().get()).getName();
        String osArch = ((Platform)nodeExtension.getResolvedPlatform().get()).getArch();
        return VariantComputerKt.computeNodeDir(nodeExtension, osName, osArch);
    }

    @NotNull
    public static final Provider<Directory> computeNodeDir(@NotNull NodeExtension nodeExtension, @NotNull String osName, @NotNull String osArch) {
        Intrinsics.checkNotNullParameter((Object)nodeExtension, (String)"nodeExtension");
        Intrinsics.checkNotNullParameter((Object)osName, (String)"osName");
        Intrinsics.checkNotNullParameter((Object)osArch, (String)"osArch");
        Provider provider = ProviderKt.zip((Provider)nodeExtension.getWorkDir(), (Provider)nodeExtension.getVersion()).map(new Transformer(osName, osArch){
            final /* synthetic */ String $osName;
            final /* synthetic */ String $osArch;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Directory transform(@NotNull Pair<? extends Directory, String> $dstr$workDir$version) {
                void workDir;
                Intrinsics.checkNotNullParameter($dstr$workDir$version, (String)"<name for destructuring parameter 0>");
                Directory directory = (Directory)$dstr$workDir$version.component1();
                String version2 = (String)$dstr$workDir$version.component2();
                String dirName = "node-v" + version2 + '-' + this.$osName + '-' + this.$osArch;
                return workDir.dir(dirName);
            }
            {
                this.$osName = string;
                this.$osArch = string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"zip(nodeExtension.workDi\u2026orkDir.dir(dirName)\n    }");
        return provider;
    }

    @NotNull
    public static final Provider<String> computeNodeArchiveDependency(@NotNull NodeExtension extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String osName = ((Platform)extension.getResolvedPlatform().get()).getName();
        String osArch = ((Platform)extension.getResolvedPlatform().get()).getArch();
        String type = ((Platform)extension.getResolvedPlatform().get()).isWindows() ? "zip" : "tar.gz";
        Provider provider = extension.getVersion().map(new Transformer(osName, osArch, type){
            final /* synthetic */ String $osName;
            final /* synthetic */ String $osArch;
            final /* synthetic */ String $type;

            @NotNull
            public final String transform(@NotNull String version2) {
                Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
                return "org.nodejs:node:" + version2 + ':' + this.$osName + '-' + this.$osArch + '@' + this.$type;
            }
            {
                this.$osName = string;
                this.$osArch = string2;
                this.$type = string3;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"extension.version.map { \u2026:$osName-$osArch@$type\" }");
        return provider;
    }
}

