/*
 * Decompiled with CFR 0.152.
 */
package com.lzf.easyfloat.anim;

import android.animation.Animator;
import android.view.View;
import android.view.WindowManager;
import com.lzf.easyfloat.data.FloatConfig;
import com.lzf.easyfloat.interfaces.OnFloatAnimator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\b\u0010\r\u001a\u0004\u0018\u00010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/lzf/easyfloat/anim/AnimatorManager;", "", "view", "Landroid/view/View;", "params", "Landroid/view/WindowManager$LayoutParams;", "windowManager", "Landroid/view/WindowManager;", "config", "Lcom/lzf/easyfloat/data/FloatConfig;", "(Landroid/view/View;Landroid/view/WindowManager$LayoutParams;Landroid/view/WindowManager;Lcom/lzf/easyfloat/data/FloatConfig;)V", "enterAnim", "Landroid/animation/Animator;", "exitAnim", "easyfloat_release"})
public final class AnimatorManager {
    @NotNull
    private final View view;
    @NotNull
    private final WindowManager.LayoutParams params;
    @NotNull
    private final WindowManager windowManager;
    @NotNull
    private final FloatConfig config;

    public AnimatorManager(@NotNull View view, @NotNull WindowManager.LayoutParams params, @NotNull WindowManager windowManager, @NotNull FloatConfig config) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)windowManager, (String)"windowManager");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.view = view;
        this.params = params;
        this.windowManager = windowManager;
        this.config = config;
    }

    @Nullable
    public final Animator enterAnim() {
        OnFloatAnimator onFloatAnimator = this.config.getFloatAnimator();
        return onFloatAnimator == null ? null : onFloatAnimator.enterAnim(this.view, this.params, this.windowManager, this.config.getSidePattern());
    }

    @Nullable
    public final Animator exitAnim() {
        OnFloatAnimator onFloatAnimator = this.config.getFloatAnimator();
        return onFloatAnimator == null ? null : onFloatAnimator.exitAnim(this.view, this.params, this.windowManager, this.config.getSidePattern());
    }
}

