/*
 * Decompiled with CFR 0.152.
 */
package com.github.pturczyk.yaml.mojo;

import com.github.pturczyk.yaml.util.YamlFileUtils;
import com.github.pturczyk.yaml.validator.ValidationException;
import com.github.pturczyk.yaml.validator.YamlValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="check", defaultPhase=LifecyclePhase.VALIDATE, requiresProject=false)
public class YamlValidationMojo
extends AbstractMojo {
    @Parameter(property="yamlPaths", defaultValue=".")
    private Set<String> yamlPaths;
    @Parameter(property="failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="strictValidation", defaultValue="false")
    private boolean strictValidation;
    @Inject
    private YamlValidator validator;
    @Inject
    private YamlFileUtils fileUtils;

    public void execute() throws MojoFailureException {
        for (String yamlFilePath : this.fileUtils.getAbsoluteFilePaths(this.yamlPaths)) {
            this.getLog().info((CharSequence)("Validating " + yamlFilePath));
            this.validate(yamlFilePath);
        }
    }

    private void validate(String yamlFilePath) throws MojoFailureException {
        try (InputStream stream = this.fileUtils.openStream(yamlFilePath);){
            this.validator.validate(stream, this.strictValidation);
        }
        catch (ValidationException | IOException e) {
            this.logError(yamlFilePath, e);
            this.failIfRequired(e);
        }
    }

    private void logError(String yamlFilePath, Exception exception) {
        String error = String.format("'%s' validator failed: %s", yamlFilePath, exception.getMessage());
        this.getLog().error((CharSequence)error);
        this.getLog().debug((CharSequence)error, (Throwable)exception);
    }

    private void failIfRequired(Exception e) throws MojoFailureException {
        if (this.failOnError) {
            throw new MojoFailureException("YAML validator failed", (Throwable)e);
        }
    }
}

