/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbstractFunction;
import com.github.sommeri.less4j.core.compiler.expressions.TypesConversionUtils;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;

class Percentage
extends AbstractFunction {
    private final TypesConversionUtils utils = new TypesConversionUtils();

    Percentage() {
    }

    @Override
    public Expression evaluate(List<Expression> parameters, ProblemsHandler problemsHandler, FunctionExpression call, Expression evaluatedParameter) {
        Expression parameter;
        if (parameters.size() > 1) {
            problemsHandler.wrongNumberOfArgumentsToFunction(call.getParameter(), call.getName(), 1);
        }
        if ((parameter = parameters.get(0)).getType() == ASTCssNodeType.NUMBER) {
            return this.evaluate((NumberExpression)parameter);
        }
        if (parameter.getType() == ASTCssNodeType.STRING_EXPRESSION) {
            return this.evaluate((CssString)parameter, problemsHandler);
        }
        problemsHandler.mathFunctionParameterNotANumberWarn("percentage", parameter);
        return this.createResult(Double.NaN, parameter.getUnderlyingStructure());
    }

    private Expression evaluate(CssString parameter, ProblemsHandler problemsHandler) {
        Double value = this.utils.toDouble(parameter);
        if (value.isNaN()) {
            problemsHandler.mathFunctionParameterNotANumberWarn("percentage", parameter);
        }
        return this.createResult(value, parameter.getUnderlyingStructure());
    }

    private Expression evaluate(NumberExpression parameter) {
        return this.createResult(parameter.getValueAsDouble(), parameter.getUnderlyingStructure());
    }

    private Expression createResult(Double originalValue, HiddenTokenAwareTree parentToken) {
        Double value = originalValue * 100.0;
        return new NumberExpression(parentToken, value, "%", null, NumberExpression.Dimension.PERCENTAGE);
    }
}

