/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableSet;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference.BaseMethodReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedMethodImplementation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.AnnotationsDirectory;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.FixedSizeList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util.ParameterIterator;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Annotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Method;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.MethodParameter;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.AbstractForwardSequentialList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DexBackedMethod
extends BaseMethodReference
implements Method {
    public final DexBackedDexFile dexFile;
    public final DexBackedClassDef classDef;
    public final int accessFlags;
    private final int codeOffset;
    private final int parameterAnnotationSetListOffset;
    private final int methodAnnotationSetOffset;
    public final int methodIndex;
    private final int startOffset;
    private int methodIdItemOffset;
    private int protoIdItemOffset;
    private int parametersOffset = -1;

    public DexBackedMethod(DexBackedDexFile dexBackedDexFile, DexReader dexReader, DexBackedClassDef dexBackedClassDef, int n, AnnotationsDirectory.AnnotationIterator annotationIterator, AnnotationsDirectory.AnnotationIterator annotationIterator2) {
        this.dexFile = dexBackedDexFile;
        this.classDef = dexBackedClassDef;
        this.startOffset = dexReader.getOffset();
        int n2 = dexReader.readLargeUleb128();
        this.methodIndex = n2 + n;
        this.accessFlags = dexReader.readSmallUleb128();
        this.codeOffset = dexReader.readSmallUleb128();
        this.methodAnnotationSetOffset = annotationIterator.seekTo(this.methodIndex);
        this.parameterAnnotationSetListOffset = annotationIterator2.seekTo(this.methodIndex);
    }

    @Override
    public String getDefiningClass() {
        return this.classDef.getType();
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public String getName() {
        return (String)this.dexFile.getStringSection().get(this.dexFile.getBuffer().readSmallUint(this.getMethodIdItemOffset() + 4));
    }

    @Override
    public String getReturnType() {
        return (String)this.dexFile.getTypeSection().get(this.dexFile.getBuffer().readSmallUint(this.getProtoIdItemOffset() + 4));
    }

    @Override
    public List<? extends MethodParameter> getParameters() {
        int n = this.getParametersOffset();
        if (n > 0) {
            final List<String> list = this.getParameterTypes();
            return new AbstractForwardSequentialList<MethodParameter>(){

                @Override
                public Iterator<MethodParameter> iterator() {
                    return new ParameterIterator(list, DexBackedMethod.this.getParameterAnnotations(), DexBackedMethod.this.getParameterNames());
                }

                @Override
                public int size() {
                    return list.size();
                }
            };
        }
        return ImmutableList.of();
    }

    public List<? extends Set<? extends DexBackedAnnotation>> getParameterAnnotations() {
        return AnnotationsDirectory.getParameterAnnotations(this.dexFile, this.parameterAnnotationSetListOffset);
    }

    public Iterator<String> getParameterNames() {
        DexBackedMethodImplementation dexBackedMethodImplementation = this.getImplementation();
        if (dexBackedMethodImplementation != null) {
            return dexBackedMethodImplementation.getParameterNames(null);
        }
        return ImmutableSet.of().iterator();
    }

    public List<String> getParameterTypes() {
        int n = this.getParametersOffset();
        if (n > 0) {
            final int n2 = this.dexFile.getDataBuffer().readSmallUint(n + 0);
            final int n3 = n + 4;
            return new FixedSizeList<String>(){

                @Override
                public String readItem(int n) {
                    return (String)DexBackedMethod.this.dexFile.getTypeSection().get(DexBackedMethod.this.dexFile.getDataBuffer().readUshort(n3 + 2 * n));
                }

                @Override
                public int size() {
                    return n2;
                }
            };
        }
        return ImmutableList.of();
    }

    @Override
    public Set<? extends Annotation> getAnnotations() {
        return AnnotationsDirectory.getAnnotations(this.dexFile, this.methodAnnotationSetOffset);
    }

    @Override
    public DexBackedMethodImplementation getImplementation() {
        if (this.codeOffset > 0) {
            return this.dexFile.createMethodImplementation(this.dexFile, this, this.codeOffset);
        }
        return null;
    }

    private int getMethodIdItemOffset() {
        if (this.methodIdItemOffset == 0) {
            this.methodIdItemOffset = this.dexFile.getMethodSection().getOffset(this.methodIndex);
        }
        return this.methodIdItemOffset;
    }

    private int getProtoIdItemOffset() {
        if (this.protoIdItemOffset == 0) {
            int n = this.dexFile.getBuffer().readUshort(this.getMethodIdItemOffset() + 2);
            this.protoIdItemOffset = this.dexFile.getProtoSection().getOffset(n);
        }
        return this.protoIdItemOffset;
    }

    private int getParametersOffset() {
        if (this.parametersOffset == -1) {
            this.parametersOffset = this.dexFile.getBuffer().readSmallUint(this.getProtoIdItemOffset() + 8);
        }
        return this.parametersOffset;
    }

    public static void skipMethods(DexReader dexReader, int n) {
        for (int i = 0; i < n; ++i) {
            dexReader.skipUleb128();
            dexReader.skipUleb128();
            dexReader.skipUleb128();
        }
    }
}

