/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.util.Objects;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;

public abstract class PathPattern
extends StringValuePattern {
    protected final StringValuePattern valuePattern;

    protected PathPattern(String expectedValue, StringValuePattern valuePattern) {
        super(expectedValue);
        this.valuePattern = valuePattern;
    }

    public StringValuePattern getValuePattern() {
        return this.valuePattern;
    }

    @JsonIgnore
    public boolean isSimple() {
        return this.valuePattern == null;
    }

    @Override
    public MatchResult match(String value) {
        if (this.isSimple()) {
            return this.isSimpleMatch(value);
        }
        return this.isAdvancedMatch(value);
    }

    protected abstract MatchResult isSimpleMatch(String var1);

    protected abstract MatchResult isAdvancedMatch(String var1);

    public abstract String getExpressionResult(String var1);

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PathPattern that = (PathPattern)o;
        return Objects.equals(this.expectedValue, that.expectedValue) && Objects.equals(this.valuePattern, that.valuePattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.valuePattern);
    }

    protected static class SubExpressionException
    extends RuntimeException {
        public SubExpressionException(String message) {
            super(message);
        }

        public SubExpressionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

