/*
 * Decompiled with CFR 0.152.
 */
package com.andexert.calendarlistview.library;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.view.MotionEvent;
import android.view.View;
import com.andexert.calendarlistview.library.CalendarUtils;
import com.andexert.calendarlistview.library.R;
import com.andexert.calendarlistview.library.SimpleMonthAdapter;
import java.security.InvalidParameterException;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;

class SimpleMonthView
extends View {
    public static final String VIEW_PARAMS_HEIGHT = "height";
    public static final String VIEW_PARAMS_MONTH = "month";
    public static final String VIEW_PARAMS_YEAR = "year";
    public static final String VIEW_PARAMS_SELECTED_BEGIN_DAY = "selected_begin_day";
    public static final String VIEW_PARAMS_SELECTED_LAST_DAY = "selected_last_day";
    public static final String VIEW_PARAMS_SELECTED_BEGIN_MONTH = "selected_begin_month";
    public static final String VIEW_PARAMS_SELECTED_LAST_MONTH = "selected_last_month";
    public static final String VIEW_PARAMS_SELECTED_BEGIN_YEAR = "selected_begin_year";
    public static final String VIEW_PARAMS_SELECTED_LAST_YEAR = "selected_last_year";
    public static final String VIEW_PARAMS_WEEK_START = "week_start";
    private static final int SELECTED_CIRCLE_ALPHA = 128;
    protected static int DEFAULT_HEIGHT = 32;
    protected static final int DEFAULT_NUM_ROWS = 6;
    protected static int DAY_SELECTED_CIRCLE_SIZE;
    protected static int DAY_SEPARATOR_WIDTH;
    protected static int MINI_DAY_NUMBER_TEXT_SIZE;
    protected static int MIN_HEIGHT;
    protected static int MONTH_DAY_LABEL_TEXT_SIZE;
    protected static int MONTH_HEADER_SIZE;
    protected static int MONTH_LABEL_TEXT_SIZE;
    protected int mPadding = 0;
    private String mDayOfWeekTypeface;
    private String mMonthTitleTypeface;
    protected Paint mMonthDayLabelPaint;
    protected Paint mMonthNumPaint;
    protected Paint mMonthTitleBGPaint;
    protected Paint mMonthTitlePaint;
    protected Paint mSelectedCirclePaint;
    protected int mCurrentDayTextColor;
    protected int mMonthTextColor;
    protected int mDayTextColor;
    protected int mDayNumColor;
    protected int mMonthTitleBGColor;
    protected int mPreviousDayColor;
    protected int mSelectedDaysColor;
    private final StringBuilder mStringBuilder;
    protected boolean mHasToday = false;
    protected boolean mIsPrev = false;
    protected int mSelectedBeginDay = -1;
    protected int mSelectedLastDay = -1;
    protected int mSelectedBeginMonth = -1;
    protected int mSelectedLastMonth = -1;
    protected int mSelectedBeginYear = -1;
    protected int mSelectedLastYear = -1;
    protected int mToday = -1;
    protected int mWeekStart = 1;
    protected int mNumDays;
    protected int mNumCells = this.mNumDays = 7;
    private int mDayOfWeekStart = 0;
    protected int mMonth;
    protected Boolean mDrawRect;
    protected int mRowHeight = DEFAULT_HEIGHT;
    protected int mWidth;
    protected int mYear;
    final Time today;
    private final Calendar mCalendar;
    private final Calendar mDayLabelCalendar;
    private final Boolean isPrevDayEnabled;
    private int mNumRows = 6;
    private DateFormatSymbols mDateFormatSymbols = new DateFormatSymbols();
    private OnDayClickListener mOnDayClickListener;

    public SimpleMonthView(Context context, TypedArray typedArray) {
        super(context);
        Resources resources = context.getResources();
        this.mDayLabelCalendar = Calendar.getInstance();
        this.mCalendar = Calendar.getInstance();
        this.today = new Time(Time.getCurrentTimezone());
        this.today.setToNow();
        this.mDayOfWeekTypeface = resources.getString(R.string.sans_serif);
        this.mMonthTitleTypeface = resources.getString(R.string.sans_serif);
        this.mCurrentDayTextColor = typedArray.getColor(R.styleable.DayPickerView_colorCurrentDay, resources.getColor(R.color.normal_day));
        this.mMonthTextColor = typedArray.getColor(R.styleable.DayPickerView_colorMonthName, resources.getColor(R.color.normal_day));
        this.mDayTextColor = typedArray.getColor(R.styleable.DayPickerView_colorDayName, resources.getColor(R.color.normal_day));
        this.mDayNumColor = typedArray.getColor(R.styleable.DayPickerView_colorNormalDay, resources.getColor(R.color.normal_day));
        this.mPreviousDayColor = typedArray.getColor(R.styleable.DayPickerView_colorPreviousDay, resources.getColor(R.color.normal_day));
        this.mSelectedDaysColor = typedArray.getColor(R.styleable.DayPickerView_colorSelectedDayBackground, resources.getColor(R.color.selected_day_background));
        this.mMonthTitleBGColor = typedArray.getColor(R.styleable.DayPickerView_colorSelectedDayText, resources.getColor(R.color.selected_day_text));
        this.mDrawRect = typedArray.getBoolean(R.styleable.DayPickerView_drawRoundRect, false);
        this.mStringBuilder = new StringBuilder(50);
        MINI_DAY_NUMBER_TEXT_SIZE = typedArray.getDimensionPixelSize(R.styleable.DayPickerView_textSizeDay, resources.getDimensionPixelSize(R.dimen.text_size_day));
        MONTH_LABEL_TEXT_SIZE = typedArray.getDimensionPixelSize(R.styleable.DayPickerView_textSizeMonth, resources.getDimensionPixelSize(R.dimen.text_size_month));
        MONTH_DAY_LABEL_TEXT_SIZE = typedArray.getDimensionPixelSize(R.styleable.DayPickerView_textSizeDayName, resources.getDimensionPixelSize(R.dimen.text_size_day_name));
        MONTH_HEADER_SIZE = typedArray.getDimensionPixelOffset(R.styleable.DayPickerView_headerMonthHeight, resources.getDimensionPixelOffset(R.dimen.header_month_height));
        DAY_SELECTED_CIRCLE_SIZE = typedArray.getDimensionPixelSize(R.styleable.DayPickerView_selectedDayRadius, resources.getDimensionPixelOffset(R.dimen.selected_day_radius));
        this.mRowHeight = (typedArray.getDimensionPixelSize(R.styleable.DayPickerView_calendarHeight, resources.getDimensionPixelOffset(R.dimen.calendar_height)) - MONTH_HEADER_SIZE) / 6;
        this.isPrevDayEnabled = typedArray.getBoolean(R.styleable.DayPickerView_enablePreviousDay, true);
        this.initView();
    }

    private int calculateNumRows() {
        int offset = this.findDayOffset();
        int dividend = (offset + this.mNumCells) / this.mNumDays;
        int remainder = (offset + this.mNumCells) % this.mNumDays;
        return dividend + (remainder > 0 ? 1 : 0);
    }

    private void drawMonthDayLabels(Canvas canvas) {
        int y = MONTH_HEADER_SIZE - MONTH_DAY_LABEL_TEXT_SIZE / 2;
        int dayWidthHalf = (this.mWidth - this.mPadding * 2) / (this.mNumDays * 2);
        for (int i = 0; i < this.mNumDays; ++i) {
            int calendarDay = (i + this.mWeekStart) % this.mNumDays;
            int x = (2 * i + 1) * dayWidthHalf + this.mPadding;
            this.mDayLabelCalendar.set(7, calendarDay);
            canvas.drawText(this.mDateFormatSymbols.getShortWeekdays()[this.mDayLabelCalendar.get(7)].toUpperCase(Locale.getDefault()), (float)x, (float)y, this.mMonthDayLabelPaint);
        }
    }

    private void drawMonthTitle(Canvas canvas) {
        int x = (this.mWidth + 2 * this.mPadding) / 2;
        int y = (MONTH_HEADER_SIZE - MONTH_DAY_LABEL_TEXT_SIZE) / 2 + MONTH_LABEL_TEXT_SIZE / 3;
        StringBuilder stringBuilder = new StringBuilder(this.getMonthAndYearString().toLowerCase());
        stringBuilder.setCharAt(0, Character.toUpperCase(stringBuilder.charAt(0)));
        canvas.drawText(stringBuilder.toString(), (float)x, (float)y, this.mMonthTitlePaint);
    }

    private int findDayOffset() {
        return (this.mDayOfWeekStart < this.mWeekStart ? this.mDayOfWeekStart + this.mNumDays : this.mDayOfWeekStart) - this.mWeekStart;
    }

    private String getMonthAndYearString() {
        int flags = 52;
        this.mStringBuilder.setLength(0);
        long millis = this.mCalendar.getTimeInMillis();
        return DateUtils.formatDateRange((Context)this.getContext(), (long)millis, (long)millis, (int)flags);
    }

    private void onDayClick(SimpleMonthAdapter.CalendarDay calendarDay) {
        if (this.mOnDayClickListener != null && (this.isPrevDayEnabled.booleanValue() || calendarDay.month != this.today.month || calendarDay.year != this.today.year || calendarDay.day >= this.today.monthDay)) {
            this.mOnDayClickListener.onDayClick(this, calendarDay);
        }
    }

    private boolean sameDay(int monthDay, Time time) {
        return this.mYear == time.year && this.mMonth == time.month && monthDay == time.monthDay;
    }

    private boolean prevDay(int monthDay, Time time) {
        return this.mYear < time.year || this.mYear == time.year && this.mMonth < time.month || this.mMonth == time.month && monthDay < time.monthDay;
    }

    protected void drawMonthNums(Canvas canvas) {
        int y = (this.mRowHeight + MINI_DAY_NUMBER_TEXT_SIZE) / 2 - DAY_SEPARATOR_WIDTH + MONTH_HEADER_SIZE;
        int paddingDay = (this.mWidth - 2 * this.mPadding) / (2 * this.mNumDays);
        int dayOffset = this.findDayOffset();
        for (int day = 1; day <= this.mNumCells; ++day) {
            int x = paddingDay * (1 + dayOffset * 2) + this.mPadding;
            if (this.mMonth == this.mSelectedBeginMonth && this.mSelectedBeginDay == day && this.mSelectedBeginYear == this.mYear || this.mMonth == this.mSelectedLastMonth && this.mSelectedLastDay == day && this.mSelectedLastYear == this.mYear) {
                if (this.mDrawRect.booleanValue()) {
                    RectF rectF = new RectF((float)(x - DAY_SELECTED_CIRCLE_SIZE), (float)(y - MINI_DAY_NUMBER_TEXT_SIZE / 3 - DAY_SELECTED_CIRCLE_SIZE), (float)(x + DAY_SELECTED_CIRCLE_SIZE), (float)(y - MINI_DAY_NUMBER_TEXT_SIZE / 3 + DAY_SELECTED_CIRCLE_SIZE));
                    canvas.drawRoundRect(rectF, 10.0f, 10.0f, this.mSelectedCirclePaint);
                } else {
                    canvas.drawCircle((float)x, (float)(y - MINI_DAY_NUMBER_TEXT_SIZE / 3), (float)DAY_SELECTED_CIRCLE_SIZE, this.mSelectedCirclePaint);
                }
            }
            if (this.mHasToday && this.mToday == day) {
                this.mMonthNumPaint.setColor(this.mCurrentDayTextColor);
                this.mMonthNumPaint.setTypeface(Typeface.defaultFromStyle((int)1));
            } else {
                this.mMonthNumPaint.setColor(this.mDayNumColor);
                this.mMonthNumPaint.setTypeface(Typeface.defaultFromStyle((int)0));
            }
            if (this.mMonth == this.mSelectedBeginMonth && this.mSelectedBeginDay == day && this.mSelectedBeginYear == this.mYear || this.mMonth == this.mSelectedLastMonth && this.mSelectedLastDay == day && this.mSelectedLastYear == this.mYear) {
                this.mMonthNumPaint.setColor(this.mMonthTitleBGColor);
            }
            if (this.mSelectedBeginDay != -1 && this.mSelectedLastDay != -1 && this.mSelectedBeginYear == this.mSelectedLastYear && this.mSelectedBeginMonth == this.mSelectedLastMonth && this.mSelectedBeginDay == this.mSelectedLastDay && day == this.mSelectedBeginDay && this.mMonth == this.mSelectedBeginMonth && this.mYear == this.mSelectedBeginYear) {
                this.mMonthNumPaint.setColor(this.mSelectedDaysColor);
            }
            if (this.mSelectedBeginDay != -1 && this.mSelectedLastDay != -1 && this.mSelectedBeginYear == this.mSelectedLastYear && this.mSelectedBeginYear == this.mYear && (this.mMonth == this.mSelectedBeginMonth && this.mSelectedLastMonth == this.mSelectedBeginMonth && (this.mSelectedBeginDay < this.mSelectedLastDay && day > this.mSelectedBeginDay && day < this.mSelectedLastDay || this.mSelectedBeginDay > this.mSelectedLastDay && day < this.mSelectedBeginDay && day > this.mSelectedLastDay) || this.mSelectedBeginMonth < this.mSelectedLastMonth && this.mMonth == this.mSelectedBeginMonth && day > this.mSelectedBeginDay || this.mSelectedBeginMonth < this.mSelectedLastMonth && this.mMonth == this.mSelectedLastMonth && day < this.mSelectedLastDay || this.mSelectedBeginMonth > this.mSelectedLastMonth && this.mMonth == this.mSelectedBeginMonth && day < this.mSelectedBeginDay || this.mSelectedBeginMonth > this.mSelectedLastMonth && this.mMonth == this.mSelectedLastMonth && day > this.mSelectedLastDay)) {
                this.mMonthNumPaint.setColor(this.mSelectedDaysColor);
            }
            if (this.mSelectedBeginDay != -1 && this.mSelectedLastDay != -1 && this.mSelectedBeginYear != this.mSelectedLastYear && (this.mSelectedBeginYear == this.mYear && this.mMonth == this.mSelectedBeginMonth || this.mSelectedLastYear == this.mYear && this.mMonth == this.mSelectedLastMonth) && (this.mSelectedBeginMonth < this.mSelectedLastMonth && this.mMonth == this.mSelectedBeginMonth && day < this.mSelectedBeginDay || this.mSelectedBeginMonth < this.mSelectedLastMonth && this.mMonth == this.mSelectedLastMonth && day > this.mSelectedLastDay || this.mSelectedBeginMonth > this.mSelectedLastMonth && this.mMonth == this.mSelectedBeginMonth && day > this.mSelectedBeginDay || this.mSelectedBeginMonth > this.mSelectedLastMonth && this.mMonth == this.mSelectedLastMonth && day < this.mSelectedLastDay)) {
                this.mMonthNumPaint.setColor(this.mSelectedDaysColor);
            }
            if (this.mSelectedBeginDay != -1 && this.mSelectedLastDay != -1 && this.mSelectedBeginYear == this.mSelectedLastYear && this.mYear == this.mSelectedBeginYear && (this.mMonth > this.mSelectedBeginMonth && this.mMonth < this.mSelectedLastMonth && this.mSelectedBeginMonth < this.mSelectedLastMonth || this.mMonth < this.mSelectedBeginMonth && this.mMonth > this.mSelectedLastMonth && this.mSelectedBeginMonth > this.mSelectedLastMonth)) {
                this.mMonthNumPaint.setColor(this.mSelectedDaysColor);
            }
            if (this.mSelectedBeginDay != -1 && this.mSelectedLastDay != -1 && this.mSelectedBeginYear != this.mSelectedLastYear && (this.mSelectedBeginYear < this.mSelectedLastYear && (this.mMonth > this.mSelectedBeginMonth && this.mYear == this.mSelectedBeginYear || this.mMonth < this.mSelectedLastMonth && this.mYear == this.mSelectedLastYear) || this.mSelectedBeginYear > this.mSelectedLastYear && (this.mMonth < this.mSelectedBeginMonth && this.mYear == this.mSelectedBeginYear || this.mMonth > this.mSelectedLastMonth && this.mYear == this.mSelectedLastYear))) {
                this.mMonthNumPaint.setColor(this.mSelectedDaysColor);
            }
            if (!this.isPrevDayEnabled.booleanValue() && this.prevDay(day, this.today) && this.today.month == this.mMonth && this.today.year == this.mYear) {
                this.mMonthNumPaint.setColor(this.mPreviousDayColor);
                this.mMonthNumPaint.setTypeface(Typeface.defaultFromStyle((int)2));
            }
            canvas.drawText(String.format("%d", day), (float)x, (float)y, this.mMonthNumPaint);
            if (++dayOffset != this.mNumDays) continue;
            dayOffset = 0;
            y += this.mRowHeight;
        }
    }

    public SimpleMonthAdapter.CalendarDay getDayFromLocation(float x, float y) {
        int padding = this.mPadding;
        if (x < (float)padding || x > (float)(this.mWidth - this.mPadding)) {
            return null;
        }
        int yDay = (int)(y - (float)MONTH_HEADER_SIZE) / this.mRowHeight;
        int day = 1 + ((int)((x - (float)padding) * (float)this.mNumDays / (float)(this.mWidth - padding - this.mPadding)) - this.findDayOffset()) + yDay * this.mNumDays;
        if (this.mMonth > 11 || this.mMonth < 0 || CalendarUtils.getDaysInMonth(this.mMonth, this.mYear) < day || day < 1) {
            return null;
        }
        return new SimpleMonthAdapter.CalendarDay(this.mYear, this.mMonth, day);
    }

    protected void initView() {
        this.mMonthTitlePaint = new Paint();
        this.mMonthTitlePaint.setFakeBoldText(true);
        this.mMonthTitlePaint.setAntiAlias(true);
        this.mMonthTitlePaint.setTextSize((float)MONTH_LABEL_TEXT_SIZE);
        this.mMonthTitlePaint.setTypeface(Typeface.create((String)this.mMonthTitleTypeface, (int)1));
        this.mMonthTitlePaint.setColor(this.mMonthTextColor);
        this.mMonthTitlePaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthTitlePaint.setStyle(Paint.Style.FILL);
        this.mMonthTitleBGPaint = new Paint();
        this.mMonthTitleBGPaint.setFakeBoldText(true);
        this.mMonthTitleBGPaint.setAntiAlias(true);
        this.mMonthTitleBGPaint.setColor(this.mMonthTitleBGColor);
        this.mMonthTitleBGPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthTitleBGPaint.setStyle(Paint.Style.FILL);
        this.mSelectedCirclePaint = new Paint();
        this.mSelectedCirclePaint.setFakeBoldText(true);
        this.mSelectedCirclePaint.setAntiAlias(true);
        this.mSelectedCirclePaint.setColor(this.mSelectedDaysColor);
        this.mSelectedCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mSelectedCirclePaint.setStyle(Paint.Style.FILL);
        this.mSelectedCirclePaint.setAlpha(128);
        this.mMonthDayLabelPaint = new Paint();
        this.mMonthDayLabelPaint.setAntiAlias(true);
        this.mMonthDayLabelPaint.setTextSize((float)MONTH_DAY_LABEL_TEXT_SIZE);
        this.mMonthDayLabelPaint.setColor(this.mDayTextColor);
        this.mMonthDayLabelPaint.setTypeface(Typeface.create((String)this.mDayOfWeekTypeface, (int)0));
        this.mMonthDayLabelPaint.setStyle(Paint.Style.FILL);
        this.mMonthDayLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthDayLabelPaint.setFakeBoldText(true);
        this.mMonthNumPaint = new Paint();
        this.mMonthNumPaint.setAntiAlias(true);
        this.mMonthNumPaint.setTextSize((float)MINI_DAY_NUMBER_TEXT_SIZE);
        this.mMonthNumPaint.setStyle(Paint.Style.FILL);
        this.mMonthNumPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthNumPaint.setFakeBoldText(false);
    }

    protected void onDraw(Canvas canvas) {
        this.drawMonthTitle(canvas);
        this.drawMonthDayLabels(canvas);
        this.drawMonthNums(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), this.mRowHeight * this.mNumRows + MONTH_HEADER_SIZE);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mWidth = w;
    }

    public boolean onTouchEvent(MotionEvent event) {
        SimpleMonthAdapter.CalendarDay calendarDay;
        if (event.getAction() == 1 && (calendarDay = this.getDayFromLocation(event.getX(), event.getY())) != null) {
            this.onDayClick(calendarDay);
        }
        return true;
    }

    public void reuse() {
        this.mNumRows = 6;
        this.requestLayout();
    }

    public void setMonthParams(HashMap<String, Integer> params) {
        if (!params.containsKey(VIEW_PARAMS_MONTH) && !params.containsKey(VIEW_PARAMS_YEAR)) {
            throw new InvalidParameterException("You must specify month and year for this view");
        }
        this.setTag(params);
        if (params.containsKey(VIEW_PARAMS_HEIGHT)) {
            this.mRowHeight = params.get(VIEW_PARAMS_HEIGHT);
            if (this.mRowHeight < MIN_HEIGHT) {
                this.mRowHeight = MIN_HEIGHT;
            }
        }
        if (params.containsKey(VIEW_PARAMS_SELECTED_BEGIN_DAY)) {
            this.mSelectedBeginDay = params.get(VIEW_PARAMS_SELECTED_BEGIN_DAY);
        }
        if (params.containsKey(VIEW_PARAMS_SELECTED_LAST_DAY)) {
            this.mSelectedLastDay = params.get(VIEW_PARAMS_SELECTED_LAST_DAY);
        }
        if (params.containsKey(VIEW_PARAMS_SELECTED_BEGIN_MONTH)) {
            this.mSelectedBeginMonth = params.get(VIEW_PARAMS_SELECTED_BEGIN_MONTH);
        }
        if (params.containsKey(VIEW_PARAMS_SELECTED_LAST_MONTH)) {
            this.mSelectedLastMonth = params.get(VIEW_PARAMS_SELECTED_LAST_MONTH);
        }
        if (params.containsKey(VIEW_PARAMS_SELECTED_BEGIN_YEAR)) {
            this.mSelectedBeginYear = params.get(VIEW_PARAMS_SELECTED_BEGIN_YEAR);
        }
        if (params.containsKey(VIEW_PARAMS_SELECTED_LAST_YEAR)) {
            this.mSelectedLastYear = params.get(VIEW_PARAMS_SELECTED_LAST_YEAR);
        }
        this.mMonth = params.get(VIEW_PARAMS_MONTH);
        this.mYear = params.get(VIEW_PARAMS_YEAR);
        this.mHasToday = false;
        this.mToday = -1;
        this.mCalendar.set(2, this.mMonth);
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(5, 1);
        this.mDayOfWeekStart = this.mCalendar.get(7);
        this.mWeekStart = params.containsKey(VIEW_PARAMS_WEEK_START) ? params.get(VIEW_PARAMS_WEEK_START).intValue() : this.mCalendar.getFirstDayOfWeek();
        this.mNumCells = CalendarUtils.getDaysInMonth(this.mMonth, this.mYear);
        for (int i = 0; i < this.mNumCells; ++i) {
            int day = i + 1;
            if (this.sameDay(day, this.today)) {
                this.mHasToday = true;
                this.mToday = day;
            }
            this.mIsPrev = this.prevDay(day, this.today);
        }
        this.mNumRows = this.calculateNumRows();
    }

    public void setOnDayClickListener(OnDayClickListener onDayClickListener) {
        this.mOnDayClickListener = onDayClickListener;
    }

    static {
        DAY_SEPARATOR_WIDTH = 1;
        MIN_HEIGHT = 10;
    }

    public static interface OnDayClickListener {
        public void onDayClick(SimpleMonthView var1, SimpleMonthAdapter.CalendarDay var2);
    }
}

