/*
 * Decompiled with CFR 0.152.
 */
package com.udevel.widgetlab;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import com.udevel.widgetlab.DotView;
import java.util.ArrayList;

public class WinkDotView
extends DotView {
    @FloatRange(from=0.0, to=1.0)
    private static final float RATIO_OF_HORIZONTAL_EXPANSION = 0.33f;
    private int centerX;
    private int centerY;
    private float radius;
    private float scaleY = 1.0f;
    private float scaleX = 1.0f;
    private float minScaleY = 0.6f;
    private Paint paint;
    private RectF ovalRectF;
    @Nullable
    private AnimatorSet animatorSet;

    public WinkDotView(@NonNull Context context) {
        super(context);
    }

    protected void onDraw(Canvas canvas) {
        this.paint.setColor(this.dotColor);
        canvas.drawOval(this.ovalRectF, this.paint);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.centerX = this.getWidth() / 2;
        this.centerY = this.getHeight() / 2;
        this.radius = (float)Math.min(this.centerX, this.centerY) / (1.0f + (1.0f - this.minScaleY) / 2.0f);
        this.updateOvalRecF();
    }

    @Override
    protected void init() {
        this.paint = new Paint();
        this.ovalRectF = new RectF();
    }

    @Override
    public void startDotAnimation() {
        this.stopDotAnimation();
        if (this.animatorSet == null) {
            this.animatorSet = new AnimatorSet();
            ArrayList<ValueAnimator> animations = new ArrayList<ValueAnimator>(2);
            ValueAnimator winkAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, this.minScaleY});
            winkAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    WinkDotView.this.scaleY = ((Float)animation.getAnimatedValue()).floatValue();
                    WinkDotView.this.scaleX = 1.0f + (1.0f - WinkDotView.this.scaleY) * 0.33f;
                    WinkDotView.this.updateOvalRecF();
                    WinkDotView.this.invalidate();
                }
            });
            winkAnimator.setDuration(this.animationTotalDuration / 2L);
            winkAnimator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
            winkAnimator.setRepeatCount(1);
            winkAnimator.setRepeatMode(2);
            animations.add(winkAnimator);
            if (this.dotFirstColor != this.dotSecondColor) {
                ValueAnimator colorAnimator = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{this.dotFirstColor, this.dotSecondColor});
                colorAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animator) {
                        WinkDotView.this.dotColor = (Integer)animator.getAnimatedValue();
                    }
                });
                colorAnimator.setDuration(this.animationTotalDuration / 2L);
                colorAnimator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
                colorAnimator.setRepeatCount(1);
                colorAnimator.setRepeatMode(2);
                animations.add(colorAnimator);
            }
            this.animatorSet.playTogether(animations);
            this.animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    WinkDotView.this.dotColor = WinkDotView.this.dotFirstColor;
                    WinkDotView.this.scaleY = 1.0f;
                    WinkDotView.this.scaleX = 1.0f;
                    WinkDotView.this.updateOvalRecF();
                    WinkDotView.this.invalidate();
                }
            });
        }
        this.animatorSet.start();
    }

    @Override
    public void stopDotAnimation() {
        if (this.animatorSet != null) {
            this.animatorSet.isStarted();
            this.animatorSet.cancel();
        }
    }

    @Override
    public boolean isAnimating() {
        return this.animatorSet != null && this.animatorSet.isStarted();
    }

    @Override
    public void setMaxCompressRatio(@FloatRange(from=0.0, to=1.0) float compressRatio) {
        this.minScaleY = compressRatio;
    }

    private void updateOvalRecF() {
        float modifiedRadiusX = this.radius * this.scaleX;
        this.ovalRectF.left = (float)this.centerX - modifiedRadiusX;
        this.ovalRectF.right = (float)this.centerX + modifiedRadiusX;
        this.ovalRectF.top = (float)this.centerY - (2.0f * this.radius * this.scaleY - this.radius);
        this.ovalRectF.bottom = (float)this.centerY + this.radius;
    }
}

