/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.integrations.testcontainers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.shaded.com.google.common.io.Resources;
import org.testcontainers.utility.ComparableVersion;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;
import org.wiremock.integrations.testcontainers.WireMockPlugin;

public class WireMockContainer
extends GenericContainer<WireMockContainer> {
    public static final String OFFICIAL_IMAGE_NAME = "wiremock/wiremock";
    private static final String WIREMOCK_2_LATEST_TAG = "2.35.0";
    static final String WIREMOCK_2_MINIMUM_SUPPORTED_VERSION = "2.0.0";
    public static final DockerImageName WIREMOCK_2_LATEST = DockerImageName.parse((String)"wiremock/wiremock").withTag("2.35.0");
    private static final String MAPPINGS_DIR = "/home/wiremock/mappings/";
    private static final String FILES_DIR = "/home/wiremock/__files/";
    private static final String EXTENSIONS_DIR = "/var/wiremock/extensions/";
    private static final WaitStrategy DEFAULT_WAITER = Wait.forHttp((String)"/__admin/mappings").withMethod("GET").forStatusCode(200);
    private static final int PORT = 8080;
    private final StringBuilder wireMockArgs;
    private final Map<String, Stub> mappingStubs = new HashMap<String, Stub>();
    private final Map<String, MountableFile> mappingFiles = new HashMap<String, MountableFile>();
    private final Map<String, WireMockPlugin> plugins = new HashMap<String, WireMockPlugin>();
    private boolean isBannerDisabled = true;

    public WireMockContainer(String image) {
        this(DockerImageName.parse((String)image));
    }

    public WireMockContainer(DockerImageName dockerImage) {
        super(dockerImage);
        dockerImage.assertCompatibleWith(new DockerImageName[]{new DockerImageName(OFFICIAL_IMAGE_NAME)});
        ComparableVersion version = new ComparableVersion(dockerImage.getVersionPart());
        if (version.isSemanticVersion()) {
            boolean isLessThanBaseVersion = version.isLessThan(WIREMOCK_2_MINIMUM_SUPPORTED_VERSION);
            if (OFFICIAL_IMAGE_NAME.equals(dockerImage.getUnversionedPart()) && isLessThanBaseVersion) {
                throw new IllegalArgumentException("For the official image, the WireMock version must be >= 2.0.0");
            }
        }
        this.wireMockArgs = new StringBuilder();
        this.setWaitStrategy(DEFAULT_WAITER);
    }

    public WireMockContainer withoutBanner() {
        this.isBannerDisabled = true;
        return this;
    }

    public WireMockContainer withBanner() {
        this.isBannerDisabled = false;
        return this;
    }

    public WireMockContainer withCliArg(String arg) {
        this.wireMockArgs.append(' ').append(arg);
        return this;
    }

    public WireMockContainer withMappingFromJSON(String json) {
        return this.withMappingFromJSON(Integer.toString(json.hashCode()), json);
    }

    public WireMockContainer withMappingFromJSON(String name, String json) {
        this.mappingStubs.put(name, new Stub(name, json));
        return this;
    }

    @Deprecated
    public WireMockContainer withMapping(String name, String json) {
        return this.withMappingFromJSON(name, json);
    }

    public WireMockContainer withMappingFromResource(String name, Class<?> resource, String resourceJson) {
        URL url = Resources.getResource(resource, (String)resourceJson);
        return this.withMappingFromResource(name, url);
    }

    public WireMockContainer withMappingFromResource(Class<?> resource, String resourceJson) {
        String id = resource.getName() + "_" + resourceJson;
        return this.withMappingFromResource(id, resource.getSimpleName() + "/" + resourceJson);
    }

    @Deprecated
    public WireMockContainer withMapping(String name, Class<?> resource, String resourceJson) {
        return this.withMappingFromResource(name, resource, resource.getSimpleName() + "/" + resourceJson);
    }

    public WireMockContainer withMappingFromResource(String name, String resourceName) {
        URL url = Resources.getResource((String)resourceName);
        return this.withMappingFromResource(name, url);
    }

    public WireMockContainer withMappingFromResource(String resourceName) {
        String id = resourceName.replace('/', '_');
        return this.withMappingFromResource(id, resourceName);
    }

    public WireMockContainer withMappingFromResource(String name, URL url) {
        try {
            String text = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
            return this.withMapping(name, text);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public WireMockContainer withFile(String name, File file) {
        this.mappingFiles.put(name, MountableFile.forHostPath((String)file.getPath()));
        return this;
    }

    public WireMockContainer withFile(File file) {
        this.mappingFiles.put(file.getName(), MountableFile.forHostPath((String)file.getPath()));
        return this;
    }

    public WireMockContainer withFileFromResource(String name, String classpathResource) {
        this.mappingFiles.put(name, MountableFile.forClasspathResource((String)classpathResource));
        return this;
    }

    public WireMockContainer withFileFromResource(String classpathResource) {
        String id = classpathResource.replace('/', '_');
        return this.withFileFromResource(id, classpathResource);
    }

    public WireMockContainer withFileFromResource(String name, Class<?> resource, String filename) {
        return this.withFileFromResource(name, resource.getName().replace('.', '/') + "/" + filename);
    }

    public WireMockContainer withFileFromResource(Class<?> resource, String filename) {
        String id = resource.getSimpleName() + "_" + filename;
        return this.withFileFromResource(id, resource, filename);
    }

    public WireMockContainer withExtensions(Collection<String> classNames, Collection<File> jars) {
        return this.withExtensions(WireMockPlugin.guessPluginId(classNames, jars), classNames, jars);
    }

    public WireMockContainer withExtensions(String id, Collection<String> classNames, Collection<File> jars) {
        WireMockPlugin extension = new WireMockPlugin(id).withExtensions(classNames).withJars(jars);
        return this.withPlugin(extension);
    }

    public WireMockContainer withExtensions(Collection<String> classNames, File jarDirectory) {
        List<File> jarsInTheDirectory;
        try (Stream<Path> walk = Files.walk(jarDirectory.toPath(), new FileVisitOption[0]);){
            jarsInTheDirectory = walk.filter(p -> !Files.isDirectory(p, new LinkOption[0])).map(Path::toFile).filter(f -> f.toString().endsWith(".jar")).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot list JARs in the directory " + jarDirectory, e);
        }
        return this.withExtensions(classNames, jarsInTheDirectory);
    }

    public WireMockContainer withExtension(String className) {
        return this.withExtensions(Collections.singleton(className), Collections.emptyList());
    }

    private WireMockContainer withPlugin(WireMockPlugin plugin) {
        String pluginId = plugin.getPluginId();
        if (this.plugins.containsKey(pluginId)) {
            throw new IllegalArgumentException("The plugin is already included: " + pluginId);
        }
        this.plugins.put(pluginId, plugin);
        return this;
    }

    public String getBaseUrl() {
        return String.format("http://%s:%d", this.getHost(), this.getPort());
    }

    public String getUrl(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return String.format("%s%s", this.getBaseUrl(), path);
    }

    public Integer getPort() {
        return this.getMappedPort(8080);
    }

    protected void configure() {
        super.configure();
        this.withExposedPorts(new Integer[]{8080});
        for (Stub stub : this.mappingStubs.values()) {
            this.withCopyToContainer(Transferable.of((String)stub.json), MAPPINGS_DIR + stub.name + ".json");
        }
        for (Map.Entry entry : this.mappingFiles.entrySet()) {
            this.withCopyToContainer((Transferable)entry.getValue(), FILES_DIR + (String)entry.getKey());
        }
        ArrayList<String> extensionClassNames = new ArrayList<String>();
        for (Map.Entry<String, WireMockPlugin> entry : this.plugins.entrySet()) {
            WireMockPlugin ext = entry.getValue();
            extensionClassNames.addAll(ext.getExtensionClassNames());
            for (File jar : ext.getJars()) {
                this.withCopyToContainer((Transferable)MountableFile.forHostPath((Path)jar.toPath()), EXTENSIONS_DIR + jar.getName());
            }
        }
        if (!extensionClassNames.isEmpty()) {
            this.wireMockArgs.append(" --extensions ");
            this.wireMockArgs.append(String.join((CharSequence)",", extensionClassNames));
        }
        if (this.isBannerDisabled) {
            this.withCliArg("--disable-banner");
        }
        this.withCommand(this.wireMockArgs.toString());
    }

    private static final class Stub {
        final String name;
        final String json;

        public Stub(String name, String json) {
            this.name = name;
            this.json = json;
        }
    }
}

