/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.integrations.testcontainers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.testcontainers.shaded.com.google.common.io.Files;

class WireMockPlugin {
    private final String pluginId;
    private final List<File> jars = new ArrayList<File>();
    private final List<String> extensionClassNames = new ArrayList<String>();

    public WireMockPlugin(String id) {
        this.pluginId = id;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public WireMockPlugin withJars(Collection<File> jars) {
        this.jars.addAll(jars);
        return this;
    }

    public WireMockPlugin withJar(File jar) {
        return this.withJars(Collections.singleton(jar));
    }

    public WireMockPlugin withExtensions(Collection<String> extensionClassNames) {
        this.extensionClassNames.addAll(extensionClassNames);
        return this;
    }

    public WireMockPlugin withExtension(String className) {
        return this.withExtensions(Collections.singleton(className));
    }

    public List<File> getJars() {
        return this.jars;
    }

    public List<String> getExtensionClassNames() {
        return this.extensionClassNames;
    }

    public static String guessPluginId(Collection<String> classNames, Collection<File> jars) {
        File jar = jars.stream().findFirst().orElse(null);
        if (jar != null) {
            return Files.getNameWithoutExtension((String)jar.getName());
        }
        String className = classNames.stream().findFirst().orElse(null);
        if (className != null && className.length() > 1) {
            return className.substring(className.lastIndexOf(46) + 1);
        }
        return "plugin_" + Math.random();
    }
}

