/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.ImmutableLongBag;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongIntProcedure;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableLongCollection;
import com.gs.collections.impl.factory.primitive.LongBags;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveBag.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableLongBag
        extends AbstractUnmodifiableLongCollection
        implements MutableLongBag
{
    private static final long serialVersionUID = 1L;

    UnmodifiableLongBag(MutableLongBag bag)
    {
        super(bag);
    }

    private MutableLongBag getMutableLongBag()
    {
        return (MutableLongBag) this.getLongCollection();
    }

    @Override
    public UnmodifiableLongBag with(long element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableLongBag without(long element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableLongBag withAll(LongIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableLongBag withoutAll(LongIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public void addOccurrences(long item, int occurrences)
    {
        throw new UnsupportedOperationException("Cannot call addOccurrences() on " + this.getClass().getSimpleName());
    }

    public boolean removeOccurrences(long item, int occurrences)
    {
        throw new UnsupportedOperationException("Cannot call removeOccurrences() on " + this.getClass().getSimpleName());
    }

    public int sizeDistinct()
    {
        return this.getMutableLongBag().sizeDistinct();
    }

    public int occurrencesOf(long item)
    {
        return this.getMutableLongBag().occurrencesOf(item);
    }

    public void forEachWithOccurrences(LongIntProcedure procedure)
    {
        this.getMutableLongBag().forEachWithOccurrences(procedure);
    }

    @Override
    public MutableLongBag select(LongPredicate predicate)
    {
        return this.getMutableLongBag().select(predicate);
    }

    @Override
    public MutableLongBag reject(LongPredicate predicate)
    {
        return this.getMutableLongBag().reject(predicate);
    }

    @Override
    public <V> MutableBag<V> collect(LongToObjectFunction<? extends V> function)
    {
        return this.getMutableLongBag().collect(function);
    }

    @Override
    public boolean equals(Object otherBag)
    {
        return this.getMutableLongBag().equals(otherBag);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableLongBag().hashCode();
    }

    @Override
    public LazyLongIterable asLazy()
    {
        return new LazyLongIterableAdapter(this);
    }

    @Override
    public MutableLongBag asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableLongBag asSynchronized()
    {
        return new SynchronizedLongBag(this);
    }

    @Override
    public ImmutableLongBag toImmutable()
    {
        return LongBags.immutable.withAll(this);
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function)
    {
        return this.getMutableLongBag().injectInto(injectedValue, function);
    }
}
