/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableIntCharMapFactory;
import com.gs.collections.api.map.primitive.ImmutableIntCharMap;
import com.gs.collections.api.map.primitive.IntCharMap;

/**
 * ImmutableIntCharMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableIntCharMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableIntCharMapFactoryImpl implements ImmutableIntCharMapFactory
{
    public ImmutableIntCharMap of()
    {
        return this.with();
    }

    public ImmutableIntCharMap with()
    {
        return ImmutableIntCharEmptyMap.INSTANCE;
    }

    public ImmutableIntCharMap of(int key, char value)
    {
        return this.with(key, value);
    }

    public ImmutableIntCharMap with(int key, char value)
    {
        return new ImmutableIntCharSingletonMap(key, value);
    }

    public ImmutableIntCharMap ofAll(IntCharMap map)
    {
        return this.withAll(map);
    }

    public ImmutableIntCharMap withAll(IntCharMap map)
    {
        if (map instanceof ImmutableIntCharMap)
        {
            return (ImmutableIntCharMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            int key = map.keysView().intIterator().next();
            return new ImmutableIntCharSingletonMap(key, map.get(key));
        }
        return new ImmutableIntCharHashMap(map);
    }
}
