/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableIntFloatMapFactory;
import com.gs.collections.api.map.primitive.ImmutableIntFloatMap;
import com.gs.collections.api.map.primitive.IntFloatMap;

/**
 * ImmutableIntFloatMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableIntFloatMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableIntFloatMapFactoryImpl implements ImmutableIntFloatMapFactory
{
    public ImmutableIntFloatMap of()
    {
        return this.with();
    }

    public ImmutableIntFloatMap with()
    {
        return ImmutableIntFloatEmptyMap.INSTANCE;
    }

    public ImmutableIntFloatMap of(int key, float value)
    {
        return this.with(key, value);
    }

    public ImmutableIntFloatMap with(int key, float value)
    {
        return new ImmutableIntFloatSingletonMap(key, value);
    }

    public ImmutableIntFloatMap ofAll(IntFloatMap map)
    {
        return this.withAll(map);
    }

    public ImmutableIntFloatMap withAll(IntFloatMap map)
    {
        if (map instanceof ImmutableIntFloatMap)
        {
            return (ImmutableIntFloatMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            int key = map.keysView().intIterator().next();
            return new ImmutableIntFloatSingletonMap(key, map.get(key));
        }
        return new ImmutableIntFloatHashMap(map);
    }
}
