/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.zzam;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzq;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class Api<O extends ApiOptions> {
    private final zza<?, O> zzffz;
    private final zzh<?, O> zzfga;
    private final zzf<?> zzfgb;
    private final zzi<?> zzfgc;
    private final String mName;

    public <C extends zze> Api(String string2, zza<C, O> zza2, zzf<C> zzf2) {
        zzbp.zzb(zza2, (Object)"Cannot construct an Api with a null ClientBuilder");
        zzbp.zzb(zzf2, (Object)"Cannot construct an Api with a null ClientKey");
        this.mName = string2;
        this.zzffz = zza2;
        this.zzfga = null;
        this.zzfgb = zzf2;
        this.zzfgc = null;
    }

    public final zzd<?, O> zzafb() {
        return this.zzffz;
    }

    public final zza<?, O> zzafc() {
        zzbp.zza((this.zzffz != null ? 1 : 0) != 0, (Object)"This API was constructed with a SimpleClientBuilder. Use getSimpleClientBuilder");
        return this.zzffz;
    }

    public final zzc<?> zzafd() {
        if (this.zzfgb != null) {
            return this.zzfgb;
        }
        throw new IllegalStateException("This API was constructed with null client keys. This should not be possible.");
    }

    public final String getName() {
        return this.mName;
    }

    public static interface zzg<T extends IInterface>
    extends zzb {
    }

    public static interface zze
    extends zzb {
        public void zza(zzj var1);

        public void disconnect();

        public boolean isConnected();

        public boolean isConnecting();

        public void zza(zzam var1, Set<Scope> var2);

        public boolean zzaaa();

        public boolean zzafe();

        public boolean zzaak();

        public Intent zzaal();

        public void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

        @Nullable
        public IBinder zzaff();
    }

    public static interface zzb {
    }

    public static final class zzi<C extends zzg>
    extends zzc<C> {
    }

    public static final class zzf<C extends zze>
    extends zzc<C> {
    }

    public static class zzc<C extends zzb> {
    }

    public static interface ApiOptions {

        public static final class NoOptions
        implements NotRequiredOptions {
            private NoOptions() {
            }
        }

        public static interface HasAccountOptions
        extends HasOptions,
        NotRequiredOptions {
            public Account getAccount();
        }

        public static interface Optional
        extends HasOptions,
        NotRequiredOptions {
        }

        public static interface HasOptions
        extends ApiOptions {
        }

        public static interface NotRequiredOptions
        extends ApiOptions {
        }
    }

    public static abstract class zzh<T extends zzg, O>
    extends zzd<T, O> {
    }

    public static abstract class zza<T extends zze, O>
    extends zzd<T, O> {
        public abstract T zza(Context var1, Looper var2, zzq var3, O var4, GoogleApiClient.ConnectionCallbacks var5, GoogleApiClient.OnConnectionFailedListener var6);
    }

    public static abstract class zzd<T extends zzb, O> {
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        public List<Scope> zzn(O o) {
            return Collections.emptyList();
        }
    }
}

