/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzct;
import com.google.android.gms.common.api.internal.zzdg;
import com.google.android.gms.common.api.internal.zzdh;
import com.google.android.gms.common.internal.zzbp;
import java.lang.ref.WeakReference;

public final class zzdf<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zzfpb = null;
    private zzdf<? extends Result> zzfpc = null;
    private volatile ResultCallbacks<? super R> zzfpd = null;
    private PendingResult<R> zzfpe = null;
    private final Object zzfiz = new Object();
    private Status zzfpf = null;
    private final WeakReference<GoogleApiClient> zzfjb;
    private final zzdh zzfpg;
    private boolean zzfph = false;

    public zzdf(WeakReference<GoogleApiClient> weakReference) {
        zzbp.zzb(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zzfjb = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfjb.get();
        this.zzfpg = new zzdh(this, googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zzfiz;
        synchronized (object) {
            zzbp.zza((this.zzfpb == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbp.zza((this.zzfpd == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzfpb = resultTransform;
            zzdf<R> zzdf2 = new zzdf<R>(this.zzfjb);
            this.zzfpc = zzdf2;
            this.zzain();
            return zzdf2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zzfiz;
        synchronized (object) {
            zzbp.zza((this.zzfpd == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzbp.zza((this.zzfpb == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzfpd = resultCallbacks;
            this.zzain();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResult(R r) {
        Object object = this.zzfiz;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zzfpb != null) {
                    zzct.zzahm().submit(new zzdg(this, (Result)r));
                } else if (this.zzaip()) {
                    this.zzfpd.onSuccess(r);
                }
            } else {
                this.zzd(r.getStatus());
                zzdf.zzd(r);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(PendingResult<?> pendingResult) {
        Object object = this.zzfiz;
        synchronized (object) {
            this.zzfpe = pendingResult;
            this.zzain();
            return;
        }
    }

    private final void zzain() {
        if (this.zzfpb == null && this.zzfpd == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfjb.get();
        if (!this.zzfph && this.zzfpb != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.zzfph = true;
        }
        if (this.zzfpf != null) {
            this.zzw(this.zzfpf);
            return;
        }
        if (this.zzfpe != null) {
            this.zzfpe.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzd(Status status) {
        Object object = this.zzfiz;
        synchronized (object) {
            this.zzfpf = status;
            this.zzw(this.zzfpf);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzw(Status status) {
        Object object = this.zzfiz;
        synchronized (object) {
            if (this.zzfpb != null) {
                Status status2 = this.zzfpb.onFailure(status);
                zzbp.zzb((Object)status2, (Object)"onFailure must not return null");
                super.zzd(status2);
            } else if (this.zzaip()) {
                this.zzfpd.onFailure(status);
            }
            return;
        }
    }

    final void zzaio() {
        this.zzfpd = null;
    }

    private final boolean zzaip() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfjb.get();
        return this.zzfpd != null && googleApiClient != null;
    }

    private static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ ResultTransform zzc(zzdf zzdf2) {
        return zzdf2.zzfpb;
    }

    static /* synthetic */ zzdh zzd(zzdf zzdf2) {
        return zzdf2.zzfpg;
    }

    static /* synthetic */ void zza(zzdf zzdf2, Result result) {
        zzdf.zzd(result);
    }

    static /* synthetic */ WeakReference zze(zzdf zzdf2) {
        return zzdf2.zzfjb;
    }

    static /* synthetic */ Object zzf(zzdf zzdf2) {
        return zzdf2.zzfiz;
    }

    static /* synthetic */ zzdf zzg(zzdf zzdf2) {
        return zzdf2.zzfpc;
    }

    static /* synthetic */ void zza(zzdf zzdf2, Status status) {
        zzdf2.zzd(status);
    }
}

