/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzdf;
import com.google.android.gms.common.api.internal.zzdl;
import com.google.android.gms.common.api.internal.zzt;
import com.google.android.gms.common.api.internal.zzu;
import com.google.android.gms.common.api.internal.zzv;
import com.google.android.gms.common.internal.zzap;
import com.google.android.gms.common.internal.zzbp;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzs<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> zzfiy = new zzt();
    private final Object zzfiz = new Object();
    private zzu<R> zzfja;
    private WeakReference<GoogleApiClient> zzfjb;
    private final CountDownLatch zzaop = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> zzfjc = new ArrayList();
    private ResultCallback<? super R> zzfjd;
    private final AtomicReference<zzdl> zzfje = new AtomicReference();
    private R zzfhl;
    private Status mStatus;
    private zzv zzfjf;
    private volatile boolean zzfjg;
    private boolean zzaj;
    private boolean zzfjh;
    private zzap zzfji;
    private volatile zzdf<R> zzfjj;
    private boolean zzfjk = false;

    @Deprecated
    zzs() {
        this.zzfja = new zzu(Looper.getMainLooper());
        this.zzfjb = new WeakReference<Object>(null);
    }

    protected zzs(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zzfja = new zzu(looper);
        this.zzfjb = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected zzs(Looper looper) {
        this.zzfja = new zzu(looper);
        this.zzfjb = new WeakReference<Object>(null);
    }

    public final boolean isReady() {
        return this.zzaop.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzbp.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread");
        zzbp.zza((!this.zzfjg ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzbp.zza((this.zzfjj == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zzaop.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzt(Status.zzfhq);
        }
        zzbp.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        zzbp.zza((l <= 0L || Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzbp.zza((!this.zzfjg ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzbp.zza((this.zzfjj == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            if (!this.zzaop.await(l, timeUnit)) {
                this.zzt(Status.zzfhs);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzt(Status.zzfhq);
        }
        zzbp.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.zzfiz;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzfjd = null;
                return;
            }
            zzbp.zza((!this.zzfjg ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbp.zza((this.zzfjj == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzfja.zza(resultCallback, (R)this.get());
            } else {
                this.zzfjd = resultCallback;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.zzfiz;
        synchronized (object) {
            if (resultCallback == null) {
                this.zzfjd = null;
                return;
            }
            zzbp.zza((!this.zzfjg ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbp.zza((this.zzfjj == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (((PendingResult)this).isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.zzfja.zza(resultCallback, (R)this.get());
            } else {
                this.zzfjd = resultCallback;
                long l2 = timeUnit.toMillis(l);
                zzs zzs2 = this;
                zzu<R> zzu2 = this.zzfja;
                zzu2.sendMessageDelayed(zzu2.obtainMessage(2, zzs2), l2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzbp.zzb((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.zzfiz;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzp(this.mStatus);
            } else {
                this.zzfjc.add(zza2);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzfiz;
        synchronized (object) {
            if (this.zzaj || this.zzfjg) {
                return;
            }
            if (this.zzfji != null) {
                try {
                    this.zzfji.cancel();
                }
                catch (RemoteException remoteException) {}
            }
            zzs.zzd(this.zzfhl);
            this.zzaj = true;
            this.zzc(this.zzb(Status.zzfht));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzage() {
        Object object = this.zzfiz;
        synchronized (object) {
            if ((GoogleApiClient)this.zzfjb.get() == null || !this.zzfjk) {
                ((PendingResult)this).cancel();
            }
            return ((PendingResult)this).isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzfiz;
        synchronized (object) {
            return this.zzaj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzbp.zza((!this.zzfjg ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.zzfiz;
        synchronized (object) {
            zzbp.zza((this.zzfjj == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbp.zza((this.zzfjd == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            zzbp.zza((!this.zzaj ? 1 : 0) != 0, (Object)"Cannot call then() if result was canceled.");
            this.zzfjk = true;
            this.zzfjj = new zzdf(this.zzfjb);
            TransformedResult<? extends S> transformedResult = ((TransformedResult)this.zzfjj).then(resultTransform);
            if (this.isReady()) {
                this.zzfja.zza(this.zzfjj, this.get());
            } else {
                this.zzfjd = this.zzfjj;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(R r) {
        Object object = this.zzfiz;
        synchronized (object) {
            if (!this.zzfjh && !this.zzaj) {
                if (this.isReady()) {
                    // empty if block
                }
            } else {
                zzs.zzd(r);
                return;
            }
            zzbp.zza((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzbp.zza((!this.zzfjg ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzc(r);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzt(Status status) {
        Object object = this.zzfiz;
        synchronized (object) {
            if (!this.isReady()) {
                this.setResult(this.zzb(status));
                this.zzfjh = true;
            }
            return;
        }
    }

    @NonNull
    protected abstract R zzb(Status var1);

    public final void zza(zzdl zzdl2) {
        this.zzfje.set(zzdl2);
    }

    @Override
    public final Integer zzafr() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzap zzap2) {
        Object object = this.zzfiz;
        synchronized (object) {
            this.zzfji = zzap2;
            return;
        }
    }

    public final void zzagf() {
        this.zzfjk = this.zzfjk || zzfiy.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final R get() {
        R r;
        Object object = this.zzfiz;
        synchronized (object) {
            zzbp.zza((!this.zzfjg ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzbp.zza((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.zzfhl;
            this.zzfhl = null;
            this.zzfjd = null;
            this.zzfjg = true;
        }
        zzs zzs2 = this;
        zzdl zzdl2 = zzs2.zzfje.getAndSet(null);
        if (zzdl2 != null) {
            zzdl2.zzc(zzs2);
        }
        return r;
    }

    private final void zzc(R r) {
        this.zzfhl = r;
        this.zzfji = null;
        this.zzaop.countDown();
        this.mStatus = this.zzfhl.getStatus();
        if (this.zzaj) {
            this.zzfjd = null;
        } else if (this.zzfjd == null) {
            if (this.zzfhl instanceof Releasable) {
                this.zzfjf = new zzv(this, null);
            }
        } else {
            this.zzfja.removeMessages(2);
            this.zzfja.zza(this.zzfjd, (R)this.get());
        }
        ArrayList<PendingResult.zza> arrayList = this.zzfjc;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            PendingResult.zza zza2 = arrayList.get(i);
            zza2.zzp(this.mStatus);
        }
        this.zzfjc.clear();
    }

    public static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ Result zza(zzs zzs2) {
        return zzs2.zzfhl;
    }
}

