/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzaa;
import com.google.android.gms.common.api.internal.zzab;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbl;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzz;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.internal.zzcpt;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

final class zzy
implements zzcd {
    private final Context mContext;
    private final zzbd zzfjo;
    private final Looper zzakl;
    private final zzbl zzfjp;
    private final zzbl zzfjq;
    private final Map<Api.zzc<?>, zzbl> zzfjr;
    private final Set<zzcv> zzfjs = Collections.newSetFromMap(new WeakHashMap());
    private final Api.zze zzfjt;
    private Bundle zzfju;
    private ConnectionResult zzfjv = null;
    private ConnectionResult zzfjw = null;
    private boolean zzfjx = false;
    private final Lock zzfjy;
    private int zzfjz = 0;

    public static zzy zza(Context context, zzbd zzbd2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcps, zzcpt> zza2, ArrayList<zzw> arrayList) {
        Object object;
        Api.zze zze3 = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.zzc<?>, Api.zze> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.zzaak()) {
                zze3 = object;
            }
            if (object.zzaaa()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        zzbp.zza((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.zzc<?> zzc2 = api.zzafd();
            if (arrayMap2.containsKey(zzc2)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(zzc2)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zzw>();
        ArrayList<zzw> arrayList2 = new ArrayList<zzw>();
        ArrayList<zzw> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            zzw zzw2 = arrayList3.get(i);
            zzw zzw3 = zzw2;
            if (arrayMap5.containsKey(zzw3.zzfda)) {
                ((ArrayList)object).add(zzw3);
                continue;
            }
            if (arrayMap.containsKey(zzw3.zzfda)) {
                arrayList2.add(zzw3);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zzy(context, zzbd2, lock, looper, zze2, (Map<Api.zzc<?>, Api.zze>)arrayMap2, (Map<Api.zzc<?>, Api.zze>)arrayMap3, zzq2, zza2, zze3, (ArrayList<zzw>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zzy(Context context, zzbd zzbd2, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, Map<Api.zzc<?>, Api.zze> map2, zzq zzq2, Api.zza<? extends zzcps, zzcpt> zza2, Api.zze zze3, ArrayList<zzw> arrayList, ArrayList<zzw> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.mContext = context;
        this.zzfjo = zzbd2;
        this.zzfjy = lock;
        this.zzakl = looper;
        this.zzfjt = zze3;
        this.zzfjp = new zzbl(context, this.zzfjo, lock, looper, zze2, map2, null, map4, null, arrayList2, new zzaa(this, null));
        this.zzfjq = new zzbl(context, this.zzfjo, lock, looper, zze2, map, zzq2, map3, zza2, arrayList, new zzab(this, null));
        ArrayMap arrayMap = new ArrayMap();
        for (Api.zzc<?> zzc2 : map2.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzfjp);
        }
        for (Api.zzc<?> zzc2 : map.keySet()) {
            arrayMap.put(zzc2, (Object)this.zzfjq);
        }
        this.zzfjr = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzagk()) {
                t.zzs(new Status(4, null, this.zzagl()));
                return t;
            }
            return this.zzfjq.zzd(t);
        }
        return this.zzfjp.zzd(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        if (this.zzf(t)) {
            if (this.zzagk()) {
                t.zzs(new Status(4, null, this.zzagl()));
                return t;
            }
            return this.zzfjq.zze(t);
        }
        return this.zzfjp.zze(t);
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zzfjr.get(api.zzafd()).equals(this.zzfjq)) {
            if (this.zzagk()) {
                return new ConnectionResult(4, this.zzagl());
            }
            return this.zzfjq.getConnectionResult(api);
        }
        return this.zzfjp.getConnectionResult(api);
    }

    @Override
    public final void connect() {
        this.zzfjz = 2;
        this.zzfjx = false;
        zzy zzy2 = this;
        this.zzfjw = null;
        zzy2.zzfjv = null;
        zzy2.zzfjp.connect();
        zzy2.zzfjq.connect();
    }

    @Override
    public final ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void disconnect() {
        this.zzfjw = null;
        this.zzfjv = null;
        this.zzfjz = 0;
        this.zzfjp.disconnect();
        this.zzfjq.disconnect();
        this.zzagj();
    }

    @Override
    public final boolean isConnected() {
        this.zzfjy.lock();
        try {
            boolean bl = this.zzfjp.isConnected() && (this.zzfjq.isConnected() || this.zzagk() || this.zzfjz == 1);
            return bl;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzfjy.lock();
        try {
            boolean bl = this.zzfjz == 2;
            return bl;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    @Override
    public final boolean zza(zzcv zzcv2) {
        this.zzfjy.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zzfjq.isConnected()) {
                this.zzfjs.add(zzcv2);
                if (this.zzfjz == 0) {
                    this.zzfjz = 1;
                }
                this.zzfjw = null;
                this.zzfjq.connect();
                return true;
            }
        }
        finally {
            this.zzfjy.unlock();
        }
        return false;
    }

    @Override
    public final void zzagh() {
        this.zzfjp.zzagh();
        this.zzfjq.zzagh();
    }

    @Override
    public final void zzafo() {
        this.zzfjy.lock();
        try {
            boolean bl = this.isConnecting();
            this.zzfjq.disconnect();
            this.zzfjw = new ConnectionResult(4);
            if (bl) {
                new Handler(this.zzakl).post((Runnable)new zzz(this));
            } else {
                this.zzagj();
            }
            return;
        }
        finally {
            this.zzfjy.unlock();
        }
    }

    private final void zzagi() {
        if (zzy.zzb(this.zzfjv)) {
            if (zzy.zzb(this.zzfjw) || this.zzagk()) {
                zzy zzy2 = this;
                switch (zzy2.zzfjz) {
                    case 2: {
                        zzy2.zzfjo.zzi(zzy2.zzfju);
                    }
                    case 1: {
                        zzy2.zzagj();
                        break;
                    }
                    default: {
                        Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
                    }
                }
                zzy2.zzfjz = 0;
                return;
            }
            if (this.zzfjw != null) {
                if (this.zzfjz == 1) {
                    this.zzagj();
                    return;
                }
                this.zza(this.zzfjw);
                this.zzfjp.disconnect();
                return;
            }
        } else {
            if (this.zzfjv != null && zzy.zzb(this.zzfjw)) {
                this.zzfjq.disconnect();
                this.zza(this.zzfjv);
                return;
            }
            if (this.zzfjv != null && this.zzfjw != null) {
                ConnectionResult connectionResult = this.zzfjv;
                if (this.zzfjq.zzfmz < this.zzfjp.zzfmz) {
                    connectionResult = this.zzfjw;
                }
                this.zza(connectionResult);
            }
        }
    }

    private final void zza(ConnectionResult connectionResult) {
        switch (this.zzfjz) {
            case 2: {
                this.zzfjo.zzc(connectionResult);
            }
            case 1: {
                this.zzagj();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zzfjz = 0;
    }

    private final void zzagj() {
        Iterator<zzcv> iterator = this.zzfjs.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzaaj();
        }
        this.zzfjs.clear();
    }

    private final void zze(int n, boolean bl) {
        this.zzfjo.zzf(n, bl);
        this.zzfjw = null;
        this.zzfjv = null;
    }

    private final boolean zzagk() {
        return this.zzfjw != null && this.zzfjw.getErrorCode() == 4;
    }

    private final boolean zzf(zzm<? extends Result, ? extends Api.zzb> zzm2) {
        Api.zzc<? extends Api.zzb> zzc2 = zzm2.zzafd();
        zzbp.zzb((boolean)this.zzfjr.containsKey(zzc2), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zzfjr.get(zzc2).equals(this.zzfjq);
    }

    @Nullable
    private final PendingIntent zzagl() {
        if (this.zzfjt == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)System.identityHashCode(this.zzfjo), (Intent)this.zzfjt.zzaal(), (int)0x8000000);
    }

    private final void zzh(Bundle bundle) {
        if (this.zzfju == null) {
            this.zzfju = bundle;
            return;
        }
        if (bundle != null) {
            this.zzfju.putAll(bundle);
        }
    }

    private static boolean zzb(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zzfjq.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zzfjp.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    static /* synthetic */ Lock zza(zzy zzy2) {
        return zzy2.zzfjy;
    }

    static /* synthetic */ void zzb(zzy zzy2) {
        zzy2.zzagi();
    }

    static /* synthetic */ void zza(zzy zzy2, Bundle bundle) {
        zzy2.zzh(bundle);
    }

    static /* synthetic */ ConnectionResult zza(zzy zzy2, ConnectionResult connectionResult) {
        zzy2.zzfjv = connectionResult;
        return zzy2.zzfjv;
    }

    static /* synthetic */ boolean zzc(zzy zzy2) {
        return zzy2.zzfjx;
    }

    static /* synthetic */ ConnectionResult zzd(zzy zzy2) {
        return zzy2.zzfjw;
    }

    static /* synthetic */ boolean zza(zzy zzy2, boolean bl) {
        zzy2.zzfjx = bl;
        return zzy2.zzfjx;
    }

    static /* synthetic */ void zza(zzy zzy2, int n, boolean bl) {
        zzy2.zze(n, bl);
    }

    static /* synthetic */ zzbl zze(zzy zzy2) {
        return zzy2.zzfjq;
    }

    static /* synthetic */ ConnectionResult zzb(zzy zzy2, ConnectionResult connectionResult) {
        zzy2.zzfjw = connectionResult;
        return zzy2.zzfjw;
    }

    static /* synthetic */ zzbl zzf(zzy zzy2) {
        return zzy2.zzfjp;
    }
}

