/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.data.zza;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.internal.zzbcc;
import com.google.android.gms.internal.zzbcf;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class BitmapTeleporter
extends zzbcc
implements ReflectedParcelable {
    public static final Parcelable.Creator<BitmapTeleporter> CREATOR = new zza();
    private int zzdxt;
    private ParcelFileDescriptor zzcqp;
    private int zzeda;
    private Bitmap zzfpv;
    private boolean zzfpw;
    private File zzfpx;

    BitmapTeleporter(int n, ParcelFileDescriptor parcelFileDescriptor, int n2) {
        this.zzdxt = n;
        this.zzcqp = parcelFileDescriptor;
        this.zzeda = n2;
        this.zzfpv = null;
        this.zzfpw = false;
    }

    public BitmapTeleporter(Bitmap bitmap) {
        this.zzdxt = 1;
        this.zzcqp = null;
        this.zzeda = 0;
        this.zzfpv = bitmap;
        this.zzfpw = true;
    }

    public final Bitmap zzais() {
        if (!this.zzfpw) {
            Bitmap.Config config;
            int n;
            int n2;
            byte[] byArray;
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzcqp));
            try {
                byArray = new byte[dataInputStream.readInt()];
                n2 = dataInputStream.readInt();
                n = dataInputStream.readInt();
                config = Bitmap.Config.valueOf((String)dataInputStream.readUTF());
                dataInputStream.read(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                BitmapTeleporter.zza(dataInputStream);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n, (Bitmap.Config)config);
            bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
            this.zzfpv = bitmap;
            this.zzfpw = true;
        }
        return this.zzfpv;
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (this.zzcqp == null) {
            Bitmap bitmap = this.zzfpv;
            ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getRowBytes() * bitmap.getHeight());
            bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
            byte[] byArray = byteBuffer.array();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(this.zzait());
            DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
            try {
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.writeInt(bitmap.getWidth());
                dataOutputStream.writeInt(bitmap.getHeight());
                dataOutputStream.writeUTF(bitmap.getConfig().toString());
                dataOutputStream.write(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not write into unlinked file", iOException);
            }
            finally {
                BitmapTeleporter.zza(dataOutputStream);
            }
        }
        int n2 = n | 1;
        Parcel parcel2 = parcel;
        BitmapTeleporter bitmapTeleporter = this;
        int n3 = zzbcf.zze((Parcel)parcel2);
        zzbcf.zzc((Parcel)parcel2, (int)1, (int)bitmapTeleporter.zzdxt);
        zzbcf.zza((Parcel)parcel2, (int)2, (Parcelable)bitmapTeleporter.zzcqp, (int)n2, (boolean)false);
        zzbcf.zzc((Parcel)parcel2, (int)3, (int)bitmapTeleporter.zzeda);
        zzbcf.zzai((Parcel)parcel2, (int)n3);
        this.zzcqp = null;
    }

    public final void release() {
        if (!this.zzfpw) {
            try {
                this.zzcqp.close();
                return;
            }
            catch (IOException iOException) {
                Log.w((String)"BitmapTeleporter", (String)"Could not close PFD", (Throwable)iOException);
            }
        }
    }

    public final void zzc(File file) {
        if (file == null) {
            throw new NullPointerException("Cannot set null temp directory");
        }
        this.zzfpx = file;
    }

    private final FileOutputStream zzait() {
        FileOutputStream fileOutputStream;
        File file;
        if (this.zzfpx == null) {
            throw new IllegalStateException("setTempDir() must be called before writing this object to a parcel");
        }
        try {
            file = File.createTempFile("teleporter", ".tmp", this.zzfpx);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not create temporary file", iOException);
        }
        try {
            fileOutputStream = new FileOutputStream(file);
            this.zzcqp = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalStateException("Temporary file is somehow already deleted");
        }
        file.delete();
        return fileOutputStream;
    }

    private static void zza(Closeable closeable) {
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            Log.w((String)"BitmapTeleporter", (String)"Could not close stream", (Throwable)iOException);
            return;
        }
    }
}

