/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.os.Bundle;
import com.google.android.gms.common.data.DataBuffer;
import com.google.android.gms.common.data.Freezable;
import java.util.ArrayList;

public final class DataBufferUtils {
    private DataBufferUtils() {
    }

    public static <T, E extends Freezable<T>> ArrayList<T> freezeAndClose(DataBuffer<E> dataBuffer) {
        ArrayList arrayList = new ArrayList(dataBuffer.getCount());
        try {
            for (Freezable freezable : dataBuffer) {
                arrayList.add(freezable.freeze());
            }
        }
        finally {
            dataBuffer.close();
        }
        return arrayList;
    }

    public static boolean hasNextPage(DataBuffer<?> dataBuffer) {
        Bundle bundle = dataBuffer.zzafh();
        return bundle != null && bundle.getString("next_page_token") != null;
    }

    public static boolean hasPrevPage(DataBuffer<?> dataBuffer) {
        Bundle bundle = dataBuffer.zzafh();
        return bundle != null && bundle.getString("prev_page_token") != null;
    }

    public static boolean hasData(DataBuffer<?> dataBuffer) {
        return dataBuffer != null && dataBuffer.getCount() > 0;
    }
}

