/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.zza;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zze;
import com.google.android.gms.common.util.zzh;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInAccount
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<GoogleSignInAccount> CREATOR = new zza();
    public static zze zzacm = zzh.zzuW();
    final int versionCode;
    private String zzBc;
    private String zzabK;
    private String zzacn;
    private String zzaco;
    private Uri zzacp;
    private String zzacq;
    private long zzacr;
    private String zzacs;
    List<Scope> zzabj;
    private String zzact;
    private String zzacu;
    private static Comparator<Scope> zzacv = new Comparator<Scope>(){

        public int zza(Scope scope, Scope scope2) {
            return scope.zzrw().compareTo(scope2.zzrw());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Scope)object, (Scope)object2);
        }
    };

    @Nullable
    public static GoogleSignInAccount zzcm(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        Uri uri = null;
        String string3 = jSONObject.optString("photoUrl", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            uri = Uri.parse((String)string3);
        }
        long l = Long.parseLong(jSONObject.getString("expirationTime"));
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("grantedScopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        return GoogleSignInAccount.zza(jSONObject.optString("id"), jSONObject.optString("tokenId", null), jSONObject.optString("email", null), jSONObject.optString("displayName", null), jSONObject.optString("givenName", null), jSONObject.optString("familyName", null), uri, l, jSONObject.getString("obfuscatedIdentifier"), hashSet).zzcn(jSONObject.optString("serverAuthCode", null));
    }

    public static GoogleSignInAccount zza(@Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable Uri uri, @Nullable Long l, @NonNull String string8, @NonNull Set<Scope> set) {
        if (l == null) {
            l = zzacm.currentTimeMillis() / 1000L;
        }
        return new GoogleSignInAccount(3, string2, string3, string4, string5, uri, null, l, zzaa.zzdl((String)string8), new ArrayList<Scope>((Collection)zzaa.zzz(set)), string6, string7);
    }

    GoogleSignInAccount(int n, String string2, String string3, String string4, String string5, Uri uri, String string6, long l, String string7, List<Scope> list, String string8, String string9) {
        this.versionCode = n;
        this.zzBc = string2;
        this.zzabK = string3;
        this.zzacn = string4;
        this.zzaco = string5;
        this.zzacp = uri;
        this.zzacq = string6;
        this.zzacr = l;
        this.zzacs = string7;
        this.zzabj = list;
        this.zzact = string8;
        this.zzacu = string9;
    }

    @Nullable
    public String getId() {
        return this.zzBc;
    }

    @Nullable
    public String getIdToken() {
        return this.zzabK;
    }

    @Nullable
    public String getEmail() {
        return this.zzacn;
    }

    @Nullable
    public String getDisplayName() {
        return this.zzaco;
    }

    @Nullable
    public String getGivenName() {
        return this.zzact;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzacu;
    }

    @Nullable
    public Uri getPhotoUrl() {
        return this.zzacp;
    }

    public GoogleSignInAccount zzcn(String string2) {
        this.zzacq = string2;
        return this;
    }

    @Nullable
    public String getServerAuthCode() {
        return this.zzacq;
    }

    public long zzpe() {
        return this.zzacr;
    }

    public boolean zza() {
        return zzacm.currentTimeMillis() / 1000L >= this.zzacr - 300L;
    }

    @NonNull
    public String zzpf() {
        return this.zzacs;
    }

    @NonNull
    public Set<Scope> getGrantedScopes() {
        return new HashSet<Scope>(this.zzabj);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GoogleSignInAccount)) {
            return false;
        }
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)((Object)object);
        return googleSignInAccount.zzpg().equals(this.zzpg());
    }

    public String zzpg() {
        return this.zzpi().toString();
    }

    public String zzph() {
        JSONObject jSONObject = this.zzpi();
        jSONObject.remove("serverAuthCode");
        return jSONObject.toString();
    }

    private JSONObject zzpi() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.getId() != null) {
                jSONObject.put("id", (Object)this.getId());
            }
            if (this.getIdToken() != null) {
                jSONObject.put("tokenId", (Object)this.getIdToken());
            }
            if (this.getEmail() != null) {
                jSONObject.put("email", (Object)this.getEmail());
            }
            if (this.getDisplayName() != null) {
                jSONObject.put("displayName", (Object)this.getDisplayName());
            }
            if (this.getGivenName() != null) {
                jSONObject.put("givenName", (Object)this.getGivenName());
            }
            if (this.getFamilyName() != null) {
                jSONObject.put("familyName", (Object)this.getFamilyName());
            }
            if (this.getPhotoUrl() != null) {
                jSONObject.put("photoUrl", (Object)this.getPhotoUrl().toString());
            }
            if (this.getServerAuthCode() != null) {
                jSONObject.put("serverAuthCode", (Object)this.getServerAuthCode());
            }
            jSONObject.put("expirationTime", this.zzacr);
            jSONObject.put("obfuscatedIdentifier", (Object)this.zzpf());
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzabj, zzacv);
            for (Scope scope : this.zzabj) {
                jSONArray.put((Object)scope.zzrw());
            }
            jSONObject.put("grantedScopes", (Object)jSONArray);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }
}

