/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-16 at 06:50:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dataproc;

/**
 * Service definition for Dataproc (v1).
 *
 * <p>
 * Manages Hadoop-based clusters and jobs on Google Cloud Platform.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/dataproc/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link DataprocRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Dataproc extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.23.0 of the Google Cloud Dataproc API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://dataproc.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Dataproc(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Dataproc(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Dataproc dataproc = new Dataproc(...);}
   *   {@code Dataproc.Projects.List request = dataproc.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * An accessor for creating requests from the Regions collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Dataproc dataproc = new Dataproc(...);}
     *   {@code Dataproc.Regions.List request = dataproc.regions().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Regions regions() {
      return new Regions();
    }

    /**
     * The "regions" collection of methods.
     */
    public class Regions {

      /**
       * An accessor for creating requests from the Clusters collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Dataproc dataproc = new Dataproc(...);}
       *   {@code Dataproc.Clusters.List request = dataproc.clusters().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Clusters clusters() {
        return new Clusters();
      }

      /**
       * The "clusters" collection of methods.
       */
      public class Clusters {

        /**
         * Creates a cluster in a project.
         *
         * Create a request for the method "clusters.create".
         *
         * This request holds the parameters needed by the dataproc server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Google Cloud Platform project that the cluster belongs to.
         * @param region Required. The Cloud Dataproc region in which to handle the request.
         * @param content the {@link com.google.api.services.dataproc.model.Cluster}
         * @return the request
         */
        public Create create(java.lang.String projectId, java.lang.String region, com.google.api.services.dataproc.model.Cluster content) throws java.io.IOException {
          Create result = new Create(projectId, region, content);
          initialize(result);
          return result;
        }

        public class Create extends DataprocRequest<com.google.api.services.dataproc.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters";

          /**
           * Creates a cluster in a project.
           *
           * Create a request for the method "clusters.create".
           *
           * This request holds the parameters needed by the the dataproc server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Google Cloud Platform project that the cluster belongs to.
           * @param region Required. The Cloud Dataproc region in which to handle the request.
           * @param content the {@link com.google.api.services.dataproc.model.Cluster}
           * @since 1.13
           */
          protected Create(java.lang.String projectId, java.lang.String region, com.google.api.services.dataproc.model.Cluster content) {
            super(Dataproc.this, "POST", REST_PATH, content, com.google.api.services.dataproc.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setBearerToken(java.lang.String bearerToken) {
            return (Create) super.setBearerToken(bearerToken);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPp(java.lang.Boolean pp) {
            return (Create) super.setPp(pp);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Google Cloud Platform project that the cluster belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Google Cloud Platform project that the cluster belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Google Cloud Platform project that the cluster belongs to. */
          public Create setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          @com.google.api.client.util.Key
          private java.lang.String region;

          /** Required. The Cloud Dataproc region in which to handle the request.
           */
          public java.lang.String getRegion() {
            return region;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          public Create setRegion(java.lang.String region) {
            this.region = region;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a cluster in a project.
         *
         * Create a request for the method "clusters.delete".
         *
         * This request holds the parameters needed by the dataproc server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Google Cloud Platform project that the cluster belongs to.
         * @param region Required. The Cloud Dataproc region in which to handle the request.
         * @param clusterName Required. The cluster name.
         * @return the request
         */
        public Delete delete(java.lang.String projectId, java.lang.String region, java.lang.String clusterName) throws java.io.IOException {
          Delete result = new Delete(projectId, region, clusterName);
          initialize(result);
          return result;
        }

        public class Delete extends DataprocRequest<com.google.api.services.dataproc.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}";

          /**
           * Deletes a cluster in a project.
           *
           * Create a request for the method "clusters.delete".
           *
           * This request holds the parameters needed by the the dataproc server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Google Cloud Platform project that the cluster belongs to.
           * @param region Required. The Cloud Dataproc region in which to handle the request.
           * @param clusterName Required. The cluster name.
           * @since 1.13
           */
          protected Delete(java.lang.String projectId, java.lang.String region, java.lang.String clusterName) {
            super(Dataproc.this, "DELETE", REST_PATH, null, com.google.api.services.dataproc.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
            this.clusterName = com.google.api.client.util.Preconditions.checkNotNull(clusterName, "Required parameter clusterName must be specified.");
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setBearerToken(java.lang.String bearerToken) {
            return (Delete) super.setBearerToken(bearerToken);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPp(java.lang.Boolean pp) {
            return (Delete) super.setPp(pp);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Google Cloud Platform project that the cluster belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Google Cloud Platform project that the cluster belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Google Cloud Platform project that the cluster belongs to. */
          public Delete setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          @com.google.api.client.util.Key
          private java.lang.String region;

          /** Required. The Cloud Dataproc region in which to handle the request.
           */
          public java.lang.String getRegion() {
            return region;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          public Delete setRegion(java.lang.String region) {
            this.region = region;
            return this;
          }

          /** Required. The cluster name. */
          @com.google.api.client.util.Key
          private java.lang.String clusterName;

          /** Required. The cluster name.
           */
          public java.lang.String getClusterName() {
            return clusterName;
          }

          /** Required. The cluster name. */
          public Delete setClusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
          }

          /**
           * Optional. Specifying the cluster_uuid means the RPC should fail (with error NOT_FOUND)
           * if cluster with specified UUID does not exist.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterUuid;

          /** Optional. Specifying the cluster_uuid means the RPC should fail (with error NOT_FOUND) if cluster
         with specified UUID does not exist.
           */
          public java.lang.String getClusterUuid() {
            return clusterUuid;
          }

          /**
           * Optional. Specifying the cluster_uuid means the RPC should fail (with error NOT_FOUND)
           * if cluster with specified UUID does not exist.
           */
          public Delete setClusterUuid(java.lang.String clusterUuid) {
            this.clusterUuid = clusterUuid;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets cluster diagnostic information. After the operation completes, the Operation.response field
         * contains DiagnoseClusterOutputLocation.
         *
         * Create a request for the method "clusters.diagnose".
         *
         * This request holds the parameters needed by the dataproc server.  After setting any optional
         * parameters, call the {@link Diagnose#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Google Cloud Platform project that the cluster belongs to.
         * @param region Required. The Cloud Dataproc region in which to handle the request.
         * @param clusterName Required. The cluster name.
         * @param content the {@link com.google.api.services.dataproc.model.DiagnoseClusterRequest}
         * @return the request
         */
        public Diagnose diagnose(java.lang.String projectId, java.lang.String region, java.lang.String clusterName, com.google.api.services.dataproc.model.DiagnoseClusterRequest content) throws java.io.IOException {
          Diagnose result = new Diagnose(projectId, region, clusterName, content);
          initialize(result);
          return result;
        }

        public class Diagnose extends DataprocRequest<com.google.api.services.dataproc.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}:diagnose";

          /**
           * Gets cluster diagnostic information. After the operation completes, the Operation.response
           * field contains DiagnoseClusterOutputLocation.
           *
           * Create a request for the method "clusters.diagnose".
           *
           * This request holds the parameters needed by the the dataproc server.  After setting any
           * optional parameters, call the {@link Diagnose#execute()} method to invoke the remote operation.
           * <p> {@link
           * Diagnose#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Google Cloud Platform project that the cluster belongs to.
           * @param region Required. The Cloud Dataproc region in which to handle the request.
           * @param clusterName Required. The cluster name.
           * @param content the {@link com.google.api.services.dataproc.model.DiagnoseClusterRequest}
           * @since 1.13
           */
          protected Diagnose(java.lang.String projectId, java.lang.String region, java.lang.String clusterName, com.google.api.services.dataproc.model.DiagnoseClusterRequest content) {
            super(Dataproc.this, "POST", REST_PATH, content, com.google.api.services.dataproc.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
            this.clusterName = com.google.api.client.util.Preconditions.checkNotNull(clusterName, "Required parameter clusterName must be specified.");
          }

          @Override
          public Diagnose set$Xgafv(java.lang.String $Xgafv) {
            return (Diagnose) super.set$Xgafv($Xgafv);
          }

          @Override
          public Diagnose setAccessToken(java.lang.String accessToken) {
            return (Diagnose) super.setAccessToken(accessToken);
          }

          @Override
          public Diagnose setAlt(java.lang.String alt) {
            return (Diagnose) super.setAlt(alt);
          }

          @Override
          public Diagnose setBearerToken(java.lang.String bearerToken) {
            return (Diagnose) super.setBearerToken(bearerToken);
          }

          @Override
          public Diagnose setCallback(java.lang.String callback) {
            return (Diagnose) super.setCallback(callback);
          }

          @Override
          public Diagnose setFields(java.lang.String fields) {
            return (Diagnose) super.setFields(fields);
          }

          @Override
          public Diagnose setKey(java.lang.String key) {
            return (Diagnose) super.setKey(key);
          }

          @Override
          public Diagnose setOauthToken(java.lang.String oauthToken) {
            return (Diagnose) super.setOauthToken(oauthToken);
          }

          @Override
          public Diagnose setPp(java.lang.Boolean pp) {
            return (Diagnose) super.setPp(pp);
          }

          @Override
          public Diagnose setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Diagnose) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Diagnose setQuotaUser(java.lang.String quotaUser) {
            return (Diagnose) super.setQuotaUser(quotaUser);
          }

          @Override
          public Diagnose setUploadType(java.lang.String uploadType) {
            return (Diagnose) super.setUploadType(uploadType);
          }

          @Override
          public Diagnose setUploadProtocol(java.lang.String uploadProtocol) {
            return (Diagnose) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Google Cloud Platform project that the cluster belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Google Cloud Platform project that the cluster belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Google Cloud Platform project that the cluster belongs to. */
          public Diagnose setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          @com.google.api.client.util.Key
          private java.lang.String region;

          /** Required. The Cloud Dataproc region in which to handle the request.
           */
          public java.lang.String getRegion() {
            return region;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          public Diagnose setRegion(java.lang.String region) {
            this.region = region;
            return this;
          }

          /** Required. The cluster name. */
          @com.google.api.client.util.Key
          private java.lang.String clusterName;

          /** Required. The cluster name.
           */
          public java.lang.String getClusterName() {
            return clusterName;
          }

          /** Required. The cluster name. */
          public Diagnose setClusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
          }

          @Override
          public Diagnose set(String parameterName, Object value) {
            return (Diagnose) super.set(parameterName, value);
          }
        }
        /**
         * Gets the resource representation for a cluster in a project.
         *
         * Create a request for the method "clusters.get".
         *
         * This request holds the parameters needed by the dataproc server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Google Cloud Platform project that the cluster belongs to.
         * @param region Required. The Cloud Dataproc region in which to handle the request.
         * @param clusterName Required. The cluster name.
         * @return the request
         */
        public Get get(java.lang.String projectId, java.lang.String region, java.lang.String clusterName) throws java.io.IOException {
          Get result = new Get(projectId, region, clusterName);
          initialize(result);
          return result;
        }

        public class Get extends DataprocRequest<com.google.api.services.dataproc.model.Cluster> {

          private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}";

          /**
           * Gets the resource representation for a cluster in a project.
           *
           * Create a request for the method "clusters.get".
           *
           * This request holds the parameters needed by the the dataproc server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Google Cloud Platform project that the cluster belongs to.
           * @param region Required. The Cloud Dataproc region in which to handle the request.
           * @param clusterName Required. The cluster name.
           * @since 1.13
           */
          protected Get(java.lang.String projectId, java.lang.String region, java.lang.String clusterName) {
            super(Dataproc.this, "GET", REST_PATH, null, com.google.api.services.dataproc.model.Cluster.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
            this.clusterName = com.google.api.client.util.Preconditions.checkNotNull(clusterName, "Required parameter clusterName must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setBearerToken(java.lang.String bearerToken) {
            return (Get) super.setBearerToken(bearerToken);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPp(java.lang.Boolean pp) {
            return (Get) super.setPp(pp);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Google Cloud Platform project that the cluster belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Google Cloud Platform project that the cluster belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Google Cloud Platform project that the cluster belongs to. */
          public Get setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          @com.google.api.client.util.Key
          private java.lang.String region;

          /** Required. The Cloud Dataproc region in which to handle the request.
           */
          public java.lang.String getRegion() {
            return region;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          public Get setRegion(java.lang.String region) {
            this.region = region;
            return this;
          }

          /** Required. The cluster name. */
          @com.google.api.client.util.Key
          private java.lang.String clusterName;

          /** Required. The cluster name.
           */
          public java.lang.String getClusterName() {
            return clusterName;
          }

          /** Required. The cluster name. */
          public Get setClusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists all regions/{region}/clusters in a project.
         *
         * Create a request for the method "clusters.list".
         *
         * This request holds the parameters needed by the dataproc server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Google Cloud Platform project that the cluster belongs to.
         * @param region Required. The Cloud Dataproc region in which to handle the request.
         * @return the request
         */
        public List list(java.lang.String projectId, java.lang.String region) throws java.io.IOException {
          List result = new List(projectId, region);
          initialize(result);
          return result;
        }

        public class List extends DataprocRequest<com.google.api.services.dataproc.model.ListClustersResponse> {

          private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters";

          /**
           * Lists all regions/{region}/clusters in a project.
           *
           * Create a request for the method "clusters.list".
           *
           * This request holds the parameters needed by the the dataproc server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Google Cloud Platform project that the cluster belongs to.
           * @param region Required. The Cloud Dataproc region in which to handle the request.
           * @since 1.13
           */
          protected List(java.lang.String projectId, java.lang.String region) {
            super(Dataproc.this, "GET", REST_PATH, null, com.google.api.services.dataproc.model.ListClustersResponse.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setBearerToken(java.lang.String bearerToken) {
            return (List) super.setBearerToken(bearerToken);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPp(java.lang.Boolean pp) {
            return (List) super.setPp(pp);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Google Cloud Platform project that the cluster belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Google Cloud Platform project that the cluster belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Google Cloud Platform project that the cluster belongs to. */
          public List setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          @com.google.api.client.util.Key
          private java.lang.String region;

          /** Required. The Cloud Dataproc region in which to handle the request.
           */
          public java.lang.String getRegion() {
            return region;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          public List setRegion(java.lang.String region) {
            this.region = region;
            return this;
          }

          /**
           * Optional. A filter constraining the clusters to list. Filters are case-sensitive and
           * have the following syntax:field = value AND field = value ...where field is one of
           * status.state, clusterName, or labels.[KEY], and [KEY] is a label key. value can be * to
           * match all values. status.state can be one of the following: ACTIVE, INACTIVE, CREATING,
           * RUNNING, ERROR, DELETING, or UPDATING. ACTIVE contains the CREATING, UPDATING, and
           * RUNNING states. INACTIVE contains the DELETING and ERROR states. clusterName is the
           * name of the cluster provided at creation time. Only the logical AND operator is
           * supported; space-separated items are treated as having an implicit AND operator.Example
           * filter:status.state = ACTIVE AND clusterName = mycluster AND labels.env = staging AND
           * labels.starred = *
           */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** Optional. A filter constraining the clusters to list. Filters are case-sensitive and have the
         following syntax:field = value AND field = value ...where field is one of status.state,
         clusterName, or labels.[KEY], and [KEY] is a label key. value can be * to match all values.
         status.state can be one of the following: ACTIVE, INACTIVE, CREATING, RUNNING, ERROR, DELETING, or
         UPDATING. ACTIVE contains the CREATING, UPDATING, and RUNNING states. INACTIVE contains the
         DELETING and ERROR states. clusterName is the name of the cluster provided at creation time. Only
         the logical AND operator is supported; space-separated items are treated as having an implicit AND
         operator.Example filter:status.state = ACTIVE AND clusterName = mycluster AND labels.env = staging
         AND labels.starred = *
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /**
           * Optional. A filter constraining the clusters to list. Filters are case-sensitive and
           * have the following syntax:field = value AND field = value ...where field is one of
           * status.state, clusterName, or labels.[KEY], and [KEY] is a label key. value can be * to
           * match all values. status.state can be one of the following: ACTIVE, INACTIVE, CREATING,
           * RUNNING, ERROR, DELETING, or UPDATING. ACTIVE contains the CREATING, UPDATING, and
           * RUNNING states. INACTIVE contains the DELETING and ERROR states. clusterName is the
           * name of the cluster provided at creation time. Only the logical AND operator is
           * supported; space-separated items are treated as having an implicit AND operator.Example
           * filter:status.state = ACTIVE AND clusterName = mycluster AND labels.env = staging AND
           * labels.starred = *
           */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /** Optional. The standard List page token. */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** Optional. The standard List page token.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /** Optional. The standard List page token. */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /** Optional. The standard List page size. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** Optional. The standard List page size.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** Optional. The standard List page size. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Updates a cluster in a project.
         *
         * Create a request for the method "clusters.patch".
         *
         * This request holds the parameters needed by the dataproc server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Google Cloud Platform project the cluster belongs to.
         * @param region Required. The Cloud Dataproc region in which to handle the request.
         * @param clusterName Required. The cluster name.
         * @param content the {@link com.google.api.services.dataproc.model.Cluster}
         * @return the request
         */
        public Patch patch(java.lang.String projectId, java.lang.String region, java.lang.String clusterName, com.google.api.services.dataproc.model.Cluster content) throws java.io.IOException {
          Patch result = new Patch(projectId, region, clusterName, content);
          initialize(result);
          return result;
        }

        public class Patch extends DataprocRequest<com.google.api.services.dataproc.model.Operation> {

          private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}";

          /**
           * Updates a cluster in a project.
           *
           * Create a request for the method "clusters.patch".
           *
           * This request holds the parameters needed by the the dataproc server.  After setting any
           * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           * <p> {@link
           * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Google Cloud Platform project the cluster belongs to.
           * @param region Required. The Cloud Dataproc region in which to handle the request.
           * @param clusterName Required. The cluster name.
           * @param content the {@link com.google.api.services.dataproc.model.Cluster}
           * @since 1.13
           */
          protected Patch(java.lang.String projectId, java.lang.String region, java.lang.String clusterName, com.google.api.services.dataproc.model.Cluster content) {
            super(Dataproc.this, "PATCH", REST_PATH, content, com.google.api.services.dataproc.model.Operation.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
            this.clusterName = com.google.api.client.util.Preconditions.checkNotNull(clusterName, "Required parameter clusterName must be specified.");
          }

          @Override
          public Patch set$Xgafv(java.lang.String $Xgafv) {
            return (Patch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Patch setAccessToken(java.lang.String accessToken) {
            return (Patch) super.setAccessToken(accessToken);
          }

          @Override
          public Patch setAlt(java.lang.String alt) {
            return (Patch) super.setAlt(alt);
          }

          @Override
          public Patch setBearerToken(java.lang.String bearerToken) {
            return (Patch) super.setBearerToken(bearerToken);
          }

          @Override
          public Patch setCallback(java.lang.String callback) {
            return (Patch) super.setCallback(callback);
          }

          @Override
          public Patch setFields(java.lang.String fields) {
            return (Patch) super.setFields(fields);
          }

          @Override
          public Patch setKey(java.lang.String key) {
            return (Patch) super.setKey(key);
          }

          @Override
          public Patch setOauthToken(java.lang.String oauthToken) {
            return (Patch) super.setOauthToken(oauthToken);
          }

          @Override
          public Patch setPp(java.lang.Boolean pp) {
            return (Patch) super.setPp(pp);
          }

          @Override
          public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Patch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Patch setQuotaUser(java.lang.String quotaUser) {
            return (Patch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Patch setUploadType(java.lang.String uploadType) {
            return (Patch) super.setUploadType(uploadType);
          }

          @Override
          public Patch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Patch) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Google Cloud Platform project the cluster belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Google Cloud Platform project the cluster belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Google Cloud Platform project the cluster belongs to. */
          public Patch setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          @com.google.api.client.util.Key
          private java.lang.String region;

          /** Required. The Cloud Dataproc region in which to handle the request.
           */
          public java.lang.String getRegion() {
            return region;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          public Patch setRegion(java.lang.String region) {
            this.region = region;
            return this;
          }

          /** Required. The cluster name. */
          @com.google.api.client.util.Key
          private java.lang.String clusterName;

          /** Required. The cluster name.
           */
          public java.lang.String getClusterName() {
            return clusterName;
          }

          /** Required. The cluster name. */
          public Patch setClusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
          }

          /**
           * Required. Specifies the path, relative to Cluster, of the field to update. For example,
           * to change the number of workers in a cluster to 5, the update_mask parameter would be
           * specified as config.worker_config.num_instances, and the PATCH request body would
           * specify the new value, as follows: { "config":{ "workerConfig":{ "numInstances":"5" } }
           * } Similarly, to change the number of preemptible workers in a cluster to 5, the
           * update_mask parameter would be config.secondary_worker_config.num_instances, and the
           * PATCH request body would be set as follows: { "config":{ "secondaryWorkerConfig":{
           * "numInstances":"5" } } } Note: Currently, only the following fields can be updated:
           * Mask  Purpose      labels  Update labels      config.worker_config.num_instances
           * Resize primary worker group      config.secondary_worker_config.num_instances  Resize
           * secondary worker group
           */
          @com.google.api.client.util.Key
          private String updateMask;

          /** Required. Specifies the path, relative to Cluster, of the field to update. For example, to change
         the number of workers in a cluster to 5, the update_mask parameter would be specified as
         config.worker_config.num_instances, and the PATCH request body would specify the new value, as
         follows: { "config":{ "workerConfig":{ "numInstances":"5" } } } Similarly, to change the number of
         preemptible workers in a cluster to 5, the update_mask parameter would be
         config.secondary_worker_config.num_instances, and the PATCH request body would be set as follows: {
         "config":{ "secondaryWorkerConfig":{ "numInstances":"5" } } } Note: Currently, only the following
         fields can be updated:      Mask  Purpose      labels  Update labels
         config.worker_config.num_instances  Resize primary worker group
         config.secondary_worker_config.num_instances  Resize secondary worker group
           */
          public String getUpdateMask() {
            return updateMask;
          }

          /**
           * Required. Specifies the path, relative to Cluster, of the field to update. For example,
           * to change the number of workers in a cluster to 5, the update_mask parameter would be
           * specified as config.worker_config.num_instances, and the PATCH request body would
           * specify the new value, as follows: { "config":{ "workerConfig":{ "numInstances":"5" } }
           * } Similarly, to change the number of preemptible workers in a cluster to 5, the
           * update_mask parameter would be config.secondary_worker_config.num_instances, and the
           * PATCH request body would be set as follows: { "config":{ "secondaryWorkerConfig":{
           * "numInstances":"5" } } } Note: Currently, only the following fields can be updated:
           * Mask  Purpose      labels  Update labels      config.worker_config.num_instances
           * Resize primary worker group      config.secondary_worker_config.num_instances  Resize
           * secondary worker group
           */
          public Patch setUpdateMask(String updateMask) {
            this.updateMask = updateMask;
            return this;
          }

          /**
           * Optional. Timeout for graceful YARN decomissioning. Graceful decommissioning allows
           * removing nodes from the cluster without interrupting jobs in progress. Timeout
           * specifies how long to wait for jobs in progress to finish before forcefully removing
           * nodes (and potentially interrupting jobs). Default timeout is 0 (for forceful
           * decommission), and the maximum allowed timeout is 1 day.Only supported on Dataproc
           * image versions 1.2 and higher.
           */
          @com.google.api.client.util.Key
          private String gracefulDecommissionTimeout;

          /** Optional. Timeout for graceful YARN decomissioning. Graceful decommissioning allows removing nodes
         from the cluster without interrupting jobs in progress. Timeout specifies how long to wait for jobs
         in progress to finish before forcefully removing nodes (and potentially interrupting jobs). Default
         timeout is 0 (for forceful decommission), and the maximum allowed timeout is 1 day.Only supported
         on Dataproc image versions 1.2 and higher.
           */
          public String getGracefulDecommissionTimeout() {
            return gracefulDecommissionTimeout;
          }

          /**
           * Optional. Timeout for graceful YARN decomissioning. Graceful decommissioning allows
           * removing nodes from the cluster without interrupting jobs in progress. Timeout
           * specifies how long to wait for jobs in progress to finish before forcefully removing
           * nodes (and potentially interrupting jobs). Default timeout is 0 (for forceful
           * decommission), and the maximum allowed timeout is 1 day.Only supported on Dataproc
           * image versions 1.2 and higher.
           */
          public Patch setGracefulDecommissionTimeout(String gracefulDecommissionTimeout) {
            this.gracefulDecommissionTimeout = gracefulDecommissionTimeout;
            return this;
          }

          @Override
          public Patch set(String parameterName, Object value) {
            return (Patch) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Jobs collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Dataproc dataproc = new Dataproc(...);}
       *   {@code Dataproc.Jobs.List request = dataproc.jobs().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Jobs jobs() {
        return new Jobs();
      }

      /**
       * The "jobs" collection of methods.
       */
      public class Jobs {

        /**
         * Starts a job cancellation request. To access the job resource after cancellation, call
         * regions/{region}/jobs.list or regions/{region}/jobs.get.
         *
         * Create a request for the method "jobs.cancel".
         *
         * This request holds the parameters needed by the dataproc server.  After setting any optional
         * parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Google Cloud Platform project that the job belongs to.
         * @param region Required. The Cloud Dataproc region in which to handle the request.
         * @param jobId Required. The job ID.
         * @param content the {@link com.google.api.services.dataproc.model.CancelJobRequest}
         * @return the request
         */
        public Cancel cancel(java.lang.String projectId, java.lang.String region, java.lang.String jobId, com.google.api.services.dataproc.model.CancelJobRequest content) throws java.io.IOException {
          Cancel result = new Cancel(projectId, region, jobId, content);
          initialize(result);
          return result;
        }

        public class Cancel extends DataprocRequest<com.google.api.services.dataproc.model.Job> {

          private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs/{jobId}:cancel";

          /**
           * Starts a job cancellation request. To access the job resource after cancellation, call
           * regions/{region}/jobs.list or regions/{region}/jobs.get.
           *
           * Create a request for the method "jobs.cancel".
           *
           * This request holds the parameters needed by the the dataproc server.  After setting any
           * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
           * <p> {@link
           * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Google Cloud Platform project that the job belongs to.
           * @param region Required. The Cloud Dataproc region in which to handle the request.
           * @param jobId Required. The job ID.
           * @param content the {@link com.google.api.services.dataproc.model.CancelJobRequest}
           * @since 1.13
           */
          protected Cancel(java.lang.String projectId, java.lang.String region, java.lang.String jobId, com.google.api.services.dataproc.model.CancelJobRequest content) {
            super(Dataproc.this, "POST", REST_PATH, content, com.google.api.services.dataproc.model.Job.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
            this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
          }

          @Override
          public Cancel set$Xgafv(java.lang.String $Xgafv) {
            return (Cancel) super.set$Xgafv($Xgafv);
          }

          @Override
          public Cancel setAccessToken(java.lang.String accessToken) {
            return (Cancel) super.setAccessToken(accessToken);
          }

          @Override
          public Cancel setAlt(java.lang.String alt) {
            return (Cancel) super.setAlt(alt);
          }

          @Override
          public Cancel setBearerToken(java.lang.String bearerToken) {
            return (Cancel) super.setBearerToken(bearerToken);
          }

          @Override
          public Cancel setCallback(java.lang.String callback) {
            return (Cancel) super.setCallback(callback);
          }

          @Override
          public Cancel setFields(java.lang.String fields) {
            return (Cancel) super.setFields(fields);
          }

          @Override
          public Cancel setKey(java.lang.String key) {
            return (Cancel) super.setKey(key);
          }

          @Override
          public Cancel setOauthToken(java.lang.String oauthToken) {
            return (Cancel) super.setOauthToken(oauthToken);
          }

          @Override
          public Cancel setPp(java.lang.Boolean pp) {
            return (Cancel) super.setPp(pp);
          }

          @Override
          public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Cancel) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Cancel setQuotaUser(java.lang.String quotaUser) {
            return (Cancel) super.setQuotaUser(quotaUser);
          }

          @Override
          public Cancel setUploadType(java.lang.String uploadType) {
            return (Cancel) super.setUploadType(uploadType);
          }

          @Override
          public Cancel setUploadProtocol(java.lang.String uploadProtocol) {
            return (Cancel) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Google Cloud Platform project that the job belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Google Cloud Platform project that the job belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Google Cloud Platform project that the job belongs to. */
          public Cancel setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          @com.google.api.client.util.Key
          private java.lang.String region;

          /** Required. The Cloud Dataproc region in which to handle the request.
           */
          public java.lang.String getRegion() {
            return region;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          public Cancel setRegion(java.lang.String region) {
            this.region = region;
            return this;
          }

          /** Required. The job ID. */
          @com.google.api.client.util.Key
          private java.lang.String jobId;

          /** Required. The job ID.
           */
          public java.lang.String getJobId() {
            return jobId;
          }

          /** Required. The job ID. */
          public Cancel setJobId(java.lang.String jobId) {
            this.jobId = jobId;
            return this;
          }

          @Override
          public Cancel set(String parameterName, Object value) {
            return (Cancel) super.set(parameterName, value);
          }
        }
        /**
         * Deletes the job from the project. If the job is active, the delete fails, and the response
         * returns FAILED_PRECONDITION.
         *
         * Create a request for the method "jobs.delete".
         *
         * This request holds the parameters needed by the dataproc server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Google Cloud Platform project that the job belongs to.
         * @param region Required. The Cloud Dataproc region in which to handle the request.
         * @param jobId Required. The job ID.
         * @return the request
         */
        public Delete delete(java.lang.String projectId, java.lang.String region, java.lang.String jobId) throws java.io.IOException {
          Delete result = new Delete(projectId, region, jobId);
          initialize(result);
          return result;
        }

        public class Delete extends DataprocRequest<com.google.api.services.dataproc.model.Empty> {

          private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs/{jobId}";

          /**
           * Deletes the job from the project. If the job is active, the delete fails, and the response
           * returns FAILED_PRECONDITION.
           *
           * Create a request for the method "jobs.delete".
           *
           * This request holds the parameters needed by the the dataproc server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Google Cloud Platform project that the job belongs to.
           * @param region Required. The Cloud Dataproc region in which to handle the request.
           * @param jobId Required. The job ID.
           * @since 1.13
           */
          protected Delete(java.lang.String projectId, java.lang.String region, java.lang.String jobId) {
            super(Dataproc.this, "DELETE", REST_PATH, null, com.google.api.services.dataproc.model.Empty.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
            this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setBearerToken(java.lang.String bearerToken) {
            return (Delete) super.setBearerToken(bearerToken);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPp(java.lang.Boolean pp) {
            return (Delete) super.setPp(pp);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Google Cloud Platform project that the job belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Google Cloud Platform project that the job belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Google Cloud Platform project that the job belongs to. */
          public Delete setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          @com.google.api.client.util.Key
          private java.lang.String region;

          /** Required. The Cloud Dataproc region in which to handle the request.
           */
          public java.lang.String getRegion() {
            return region;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          public Delete setRegion(java.lang.String region) {
            this.region = region;
            return this;
          }

          /** Required. The job ID. */
          @com.google.api.client.util.Key
          private java.lang.String jobId;

          /** Required. The job ID.
           */
          public java.lang.String getJobId() {
            return jobId;
          }

          /** Required. The job ID. */
          public Delete setJobId(java.lang.String jobId) {
            this.jobId = jobId;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets the resource representation for a job in a project.
         *
         * Create a request for the method "jobs.get".
         *
         * This request holds the parameters needed by the dataproc server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Google Cloud Platform project that the job belongs to.
         * @param region Required. The Cloud Dataproc region in which to handle the request.
         * @param jobId Required. The job ID.
         * @return the request
         */
        public Get get(java.lang.String projectId, java.lang.String region, java.lang.String jobId) throws java.io.IOException {
          Get result = new Get(projectId, region, jobId);
          initialize(result);
          return result;
        }

        public class Get extends DataprocRequest<com.google.api.services.dataproc.model.Job> {

          private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs/{jobId}";

          /**
           * Gets the resource representation for a job in a project.
           *
           * Create a request for the method "jobs.get".
           *
           * This request holds the parameters needed by the the dataproc server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Google Cloud Platform project that the job belongs to.
           * @param region Required. The Cloud Dataproc region in which to handle the request.
           * @param jobId Required. The job ID.
           * @since 1.13
           */
          protected Get(java.lang.String projectId, java.lang.String region, java.lang.String jobId) {
            super(Dataproc.this, "GET", REST_PATH, null, com.google.api.services.dataproc.model.Job.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
            this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setBearerToken(java.lang.String bearerToken) {
            return (Get) super.setBearerToken(bearerToken);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPp(java.lang.Boolean pp) {
            return (Get) super.setPp(pp);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Google Cloud Platform project that the job belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Google Cloud Platform project that the job belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Google Cloud Platform project that the job belongs to. */
          public Get setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          @com.google.api.client.util.Key
          private java.lang.String region;

          /** Required. The Cloud Dataproc region in which to handle the request.
           */
          public java.lang.String getRegion() {
            return region;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          public Get setRegion(java.lang.String region) {
            this.region = region;
            return this;
          }

          /** Required. The job ID. */
          @com.google.api.client.util.Key
          private java.lang.String jobId;

          /** Required. The job ID.
           */
          public java.lang.String getJobId() {
            return jobId;
          }

          /** Required. The job ID. */
          public Get setJobId(java.lang.String jobId) {
            this.jobId = jobId;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists regions/{region}/jobs in a project.
         *
         * Create a request for the method "jobs.list".
         *
         * This request holds the parameters needed by the dataproc server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Google Cloud Platform project that the job belongs to.
         * @param region Required. The Cloud Dataproc region in which to handle the request.
         * @return the request
         */
        public List list(java.lang.String projectId, java.lang.String region) throws java.io.IOException {
          List result = new List(projectId, region);
          initialize(result);
          return result;
        }

        public class List extends DataprocRequest<com.google.api.services.dataproc.model.ListJobsResponse> {

          private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs";

          /**
           * Lists regions/{region}/jobs in a project.
           *
           * Create a request for the method "jobs.list".
           *
           * This request holds the parameters needed by the the dataproc server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Google Cloud Platform project that the job belongs to.
           * @param region Required. The Cloud Dataproc region in which to handle the request.
           * @since 1.13
           */
          protected List(java.lang.String projectId, java.lang.String region) {
            super(Dataproc.this, "GET", REST_PATH, null, com.google.api.services.dataproc.model.ListJobsResponse.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setBearerToken(java.lang.String bearerToken) {
            return (List) super.setBearerToken(bearerToken);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPp(java.lang.Boolean pp) {
            return (List) super.setPp(pp);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Google Cloud Platform project that the job belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Google Cloud Platform project that the job belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Google Cloud Platform project that the job belongs to. */
          public List setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          @com.google.api.client.util.Key
          private java.lang.String region;

          /** Required. The Cloud Dataproc region in which to handle the request.
           */
          public java.lang.String getRegion() {
            return region;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          public List setRegion(java.lang.String region) {
            this.region = region;
            return this;
          }

          /**
           * Optional. The page token, returned by a previous call, to request the next page of
           * results.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** Optional. The page token, returned by a previous call, to request the next page of results.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * Optional. The page token, returned by a previous call, to request the next page of
           * results.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /** Optional. The number of results to return in each response. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** Optional. The number of results to return in each response.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** Optional. The number of results to return in each response. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * Optional. If set, the returned jobs list includes only jobs that were submitted to the
           * named cluster.
           */
          @com.google.api.client.util.Key
          private java.lang.String clusterName;

          /** Optional. If set, the returned jobs list includes only jobs that were submitted to the named
         cluster.
           */
          public java.lang.String getClusterName() {
            return clusterName;
          }

          /**
           * Optional. If set, the returned jobs list includes only jobs that were submitted to the
           * named cluster.
           */
          public List setClusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
          }

          /**
           * Optional. A filter constraining the jobs to list. Filters are case-sensitive and have
           * the following syntax:field = value AND field = value ...where field is status.state or
           * labels.[KEY], and [KEY] is a label key. value can be * to match all values.
           * status.state can be either ACTIVE or NON_ACTIVE. Only the logical AND operator is
           * supported; space-separated items are treated as having an implicit AND operator.Example
           * filter:status.state = ACTIVE AND labels.env = staging AND labels.starred = *
           */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** Optional. A filter constraining the jobs to list. Filters are case-sensitive and have the following
         syntax:field = value AND field = value ...where field is status.state or labels.[KEY], and [KEY] is
         a label key. value can be * to match all values. status.state can be either ACTIVE or NON_ACTIVE.
         Only the logical AND operator is supported; space-separated items are treated as having an implicit
         AND operator.Example filter:status.state = ACTIVE AND labels.env = staging AND labels.starred = *
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /**
           * Optional. A filter constraining the jobs to list. Filters are case-sensitive and have
           * the following syntax:field = value AND field = value ...where field is status.state or
           * labels.[KEY], and [KEY] is a label key. value can be * to match all values.
           * status.state can be either ACTIVE or NON_ACTIVE. Only the logical AND operator is
           * supported; space-separated items are treated as having an implicit AND operator.Example
           * filter:status.state = ACTIVE AND labels.env = staging AND labels.starred = *
           */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /**
           * Optional. Specifies enumerated categories of jobs to list. (default = match ALL
           * jobs).If filter is provided, jobStateMatcher will be ignored.
           */
          @com.google.api.client.util.Key
          private java.lang.String jobStateMatcher;

          /** Optional. Specifies enumerated categories of jobs to list. (default = match ALL jobs).If filter is
         provided, jobStateMatcher will be ignored.
           */
          public java.lang.String getJobStateMatcher() {
            return jobStateMatcher;
          }

          /**
           * Optional. Specifies enumerated categories of jobs to list. (default = match ALL
           * jobs).If filter is provided, jobStateMatcher will be ignored.
           */
          public List setJobStateMatcher(java.lang.String jobStateMatcher) {
            this.jobStateMatcher = jobStateMatcher;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Updates a job in a project.
         *
         * Create a request for the method "jobs.patch".
         *
         * This request holds the parameters needed by the dataproc server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Google Cloud Platform project that the job belongs to.
         * @param region Required. The Cloud Dataproc region in which to handle the request.
         * @param jobId Required. The job ID.
         * @param content the {@link com.google.api.services.dataproc.model.Job}
         * @return the request
         */
        public Patch patch(java.lang.String projectId, java.lang.String region, java.lang.String jobId, com.google.api.services.dataproc.model.Job content) throws java.io.IOException {
          Patch result = new Patch(projectId, region, jobId, content);
          initialize(result);
          return result;
        }

        public class Patch extends DataprocRequest<com.google.api.services.dataproc.model.Job> {

          private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs/{jobId}";

          /**
           * Updates a job in a project.
           *
           * Create a request for the method "jobs.patch".
           *
           * This request holds the parameters needed by the the dataproc server.  After setting any
           * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           * <p> {@link
           * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Google Cloud Platform project that the job belongs to.
           * @param region Required. The Cloud Dataproc region in which to handle the request.
           * @param jobId Required. The job ID.
           * @param content the {@link com.google.api.services.dataproc.model.Job}
           * @since 1.13
           */
          protected Patch(java.lang.String projectId, java.lang.String region, java.lang.String jobId, com.google.api.services.dataproc.model.Job content) {
            super(Dataproc.this, "PATCH", REST_PATH, content, com.google.api.services.dataproc.model.Job.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
            this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
          }

          @Override
          public Patch set$Xgafv(java.lang.String $Xgafv) {
            return (Patch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Patch setAccessToken(java.lang.String accessToken) {
            return (Patch) super.setAccessToken(accessToken);
          }

          @Override
          public Patch setAlt(java.lang.String alt) {
            return (Patch) super.setAlt(alt);
          }

          @Override
          public Patch setBearerToken(java.lang.String bearerToken) {
            return (Patch) super.setBearerToken(bearerToken);
          }

          @Override
          public Patch setCallback(java.lang.String callback) {
            return (Patch) super.setCallback(callback);
          }

          @Override
          public Patch setFields(java.lang.String fields) {
            return (Patch) super.setFields(fields);
          }

          @Override
          public Patch setKey(java.lang.String key) {
            return (Patch) super.setKey(key);
          }

          @Override
          public Patch setOauthToken(java.lang.String oauthToken) {
            return (Patch) super.setOauthToken(oauthToken);
          }

          @Override
          public Patch setPp(java.lang.Boolean pp) {
            return (Patch) super.setPp(pp);
          }

          @Override
          public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Patch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Patch setQuotaUser(java.lang.String quotaUser) {
            return (Patch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Patch setUploadType(java.lang.String uploadType) {
            return (Patch) super.setUploadType(uploadType);
          }

          @Override
          public Patch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Patch) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Google Cloud Platform project that the job belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Google Cloud Platform project that the job belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Google Cloud Platform project that the job belongs to. */
          public Patch setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          @com.google.api.client.util.Key
          private java.lang.String region;

          /** Required. The Cloud Dataproc region in which to handle the request.
           */
          public java.lang.String getRegion() {
            return region;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          public Patch setRegion(java.lang.String region) {
            this.region = region;
            return this;
          }

          /** Required. The job ID. */
          @com.google.api.client.util.Key
          private java.lang.String jobId;

          /** Required. The job ID.
           */
          public java.lang.String getJobId() {
            return jobId;
          }

          /** Required. The job ID. */
          public Patch setJobId(java.lang.String jobId) {
            this.jobId = jobId;
            return this;
          }

          /**
           * Required. Specifies the path, relative to Job, of the field to update. For example, to
           * update the labels of a Job the update_mask parameter would be specified as labels, and
           * the PATCH request body would specify the new value. Note: Currently, labels is the only
           * field that can be updated.
           */
          @com.google.api.client.util.Key
          private String updateMask;

          /** Required. Specifies the path, relative to Job, of the field to update. For example, to update the
         labels of a Job the update_mask parameter would be specified as labels, and the PATCH request body
         would specify the new value. Note: Currently, labels is the only field that can be updated.
           */
          public String getUpdateMask() {
            return updateMask;
          }

          /**
           * Required. Specifies the path, relative to Job, of the field to update. For example, to
           * update the labels of a Job the update_mask parameter would be specified as labels, and
           * the PATCH request body would specify the new value. Note: Currently, labels is the only
           * field that can be updated.
           */
          public Patch setUpdateMask(String updateMask) {
            this.updateMask = updateMask;
            return this;
          }

          @Override
          public Patch set(String parameterName, Object value) {
            return (Patch) super.set(parameterName, value);
          }
        }
        /**
         * Submits a job to a cluster.
         *
         * Create a request for the method "jobs.submit".
         *
         * This request holds the parameters needed by the dataproc server.  After setting any optional
         * parameters, call the {@link Submit#execute()} method to invoke the remote operation.
         *
         * @param projectId Required. The ID of the Google Cloud Platform project that the job belongs to.
         * @param region Required. The Cloud Dataproc region in which to handle the request.
         * @param content the {@link com.google.api.services.dataproc.model.SubmitJobRequest}
         * @return the request
         */
        public Submit submit(java.lang.String projectId, java.lang.String region, com.google.api.services.dataproc.model.SubmitJobRequest content) throws java.io.IOException {
          Submit result = new Submit(projectId, region, content);
          initialize(result);
          return result;
        }

        public class Submit extends DataprocRequest<com.google.api.services.dataproc.model.Job> {

          private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs:submit";

          /**
           * Submits a job to a cluster.
           *
           * Create a request for the method "jobs.submit".
           *
           * This request holds the parameters needed by the the dataproc server.  After setting any
           * optional parameters, call the {@link Submit#execute()} method to invoke the remote operation.
           * <p> {@link
           * Submit#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param projectId Required. The ID of the Google Cloud Platform project that the job belongs to.
           * @param region Required. The Cloud Dataproc region in which to handle the request.
           * @param content the {@link com.google.api.services.dataproc.model.SubmitJobRequest}
           * @since 1.13
           */
          protected Submit(java.lang.String projectId, java.lang.String region, com.google.api.services.dataproc.model.SubmitJobRequest content) {
            super(Dataproc.this, "POST", REST_PATH, content, com.google.api.services.dataproc.model.Job.class);
            this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
            this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
          }

          @Override
          public Submit set$Xgafv(java.lang.String $Xgafv) {
            return (Submit) super.set$Xgafv($Xgafv);
          }

          @Override
          public Submit setAccessToken(java.lang.String accessToken) {
            return (Submit) super.setAccessToken(accessToken);
          }

          @Override
          public Submit setAlt(java.lang.String alt) {
            return (Submit) super.setAlt(alt);
          }

          @Override
          public Submit setBearerToken(java.lang.String bearerToken) {
            return (Submit) super.setBearerToken(bearerToken);
          }

          @Override
          public Submit setCallback(java.lang.String callback) {
            return (Submit) super.setCallback(callback);
          }

          @Override
          public Submit setFields(java.lang.String fields) {
            return (Submit) super.setFields(fields);
          }

          @Override
          public Submit setKey(java.lang.String key) {
            return (Submit) super.setKey(key);
          }

          @Override
          public Submit setOauthToken(java.lang.String oauthToken) {
            return (Submit) super.setOauthToken(oauthToken);
          }

          @Override
          public Submit setPp(java.lang.Boolean pp) {
            return (Submit) super.setPp(pp);
          }

          @Override
          public Submit setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Submit) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Submit setQuotaUser(java.lang.String quotaUser) {
            return (Submit) super.setQuotaUser(quotaUser);
          }

          @Override
          public Submit setUploadType(java.lang.String uploadType) {
            return (Submit) super.setUploadType(uploadType);
          }

          @Override
          public Submit setUploadProtocol(java.lang.String uploadProtocol) {
            return (Submit) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The ID of the Google Cloud Platform project that the job belongs to. */
          @com.google.api.client.util.Key
          private java.lang.String projectId;

          /** Required. The ID of the Google Cloud Platform project that the job belongs to.
           */
          public java.lang.String getProjectId() {
            return projectId;
          }

          /** Required. The ID of the Google Cloud Platform project that the job belongs to. */
          public Submit setProjectId(java.lang.String projectId) {
            this.projectId = projectId;
            return this;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          @com.google.api.client.util.Key
          private java.lang.String region;

          /** Required. The Cloud Dataproc region in which to handle the request.
           */
          public java.lang.String getRegion() {
            return region;
          }

          /** Required. The Cloud Dataproc region in which to handle the request. */
          public Submit setRegion(java.lang.String region) {
            this.region = region;
            return this;
          }

          @Override
          public Submit set(String parameterName, Object value) {
            return (Submit) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Operations collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code Dataproc dataproc = new Dataproc(...);}
       *   {@code Dataproc.Operations.List request = dataproc.operations().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Operations operations() {
        return new Operations();
      }

      /**
       * The "operations" collection of methods.
       */
      public class Operations {

        /**
         * Starts asynchronous cancellation on a long-running operation. The server makes a best effort to
         * cancel the operation, but success is not guaranteed. If the server doesn't support this method,
         * it returns google.rpc.Code.UNIMPLEMENTED. Clients can use Operations.GetOperation or other
         * methods to check whether the cancellation succeeded or whether the operation completed despite
         * cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an
         * operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to
         * Code.CANCELLED.
         *
         * Create a request for the method "operations.cancel".
         *
         * This request holds the parameters needed by the dataproc server.  After setting any optional
         * parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation resource to be cancelled.
         * @return the request
         */
        public Cancel cancel(java.lang.String name) throws java.io.IOException {
          Cancel result = new Cancel(name);
          initialize(result);
          return result;
        }

        public class Cancel extends DataprocRequest<com.google.api.services.dataproc.model.Empty> {

          private static final String REST_PATH = "v1/{+name}:cancel";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/regions/[^/]+/operations/[^/]+$");

          /**
           * Starts asynchronous cancellation on a long-running operation. The server makes a best effort to
           * cancel the operation, but success is not guaranteed. If the server doesn't support this method,
           * it returns google.rpc.Code.UNIMPLEMENTED. Clients can use Operations.GetOperation or other
           * methods to check whether the cancellation succeeded or whether the operation completed despite
           * cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an
           * operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to
           * Code.CANCELLED.
           *
           * Create a request for the method "operations.cancel".
           *
           * This request holds the parameters needed by the the dataproc server.  After setting any
           * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
           * <p> {@link
           * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation resource to be cancelled.
           * @since 1.13
           */
          protected Cancel(java.lang.String name) {
            super(Dataproc.this, "POST", REST_PATH, null, com.google.api.services.dataproc.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
            }
          }

          @Override
          public Cancel set$Xgafv(java.lang.String $Xgafv) {
            return (Cancel) super.set$Xgafv($Xgafv);
          }

          @Override
          public Cancel setAccessToken(java.lang.String accessToken) {
            return (Cancel) super.setAccessToken(accessToken);
          }

          @Override
          public Cancel setAlt(java.lang.String alt) {
            return (Cancel) super.setAlt(alt);
          }

          @Override
          public Cancel setBearerToken(java.lang.String bearerToken) {
            return (Cancel) super.setBearerToken(bearerToken);
          }

          @Override
          public Cancel setCallback(java.lang.String callback) {
            return (Cancel) super.setCallback(callback);
          }

          @Override
          public Cancel setFields(java.lang.String fields) {
            return (Cancel) super.setFields(fields);
          }

          @Override
          public Cancel setKey(java.lang.String key) {
            return (Cancel) super.setKey(key);
          }

          @Override
          public Cancel setOauthToken(java.lang.String oauthToken) {
            return (Cancel) super.setOauthToken(oauthToken);
          }

          @Override
          public Cancel setPp(java.lang.Boolean pp) {
            return (Cancel) super.setPp(pp);
          }

          @Override
          public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Cancel) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Cancel setQuotaUser(java.lang.String quotaUser) {
            return (Cancel) super.setQuotaUser(quotaUser);
          }

          @Override
          public Cancel setUploadType(java.lang.String uploadType) {
            return (Cancel) super.setUploadType(uploadType);
          }

          @Override
          public Cancel setUploadProtocol(java.lang.String uploadProtocol) {
            return (Cancel) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation resource to be cancelled. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation resource to be cancelled.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation resource to be cancelled. */
          public Cancel setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Cancel set(String parameterName, Object value) {
            return (Cancel) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a long-running operation. This method indicates that the client is no longer interested
         * in the operation result. It does not cancel the operation. If the server doesn't support this
         * method, it returns google.rpc.Code.UNIMPLEMENTED.
         *
         * Create a request for the method "operations.delete".
         *
         * This request holds the parameters needed by the dataproc server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation resource to be deleted.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends DataprocRequest<com.google.api.services.dataproc.model.Empty> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/regions/[^/]+/operations/[^/]+$");

          /**
           * Deletes a long-running operation. This method indicates that the client is no longer interested
           * in the operation result. It does not cancel the operation. If the server doesn't support this
           * method, it returns google.rpc.Code.UNIMPLEMENTED.
           *
           * Create a request for the method "operations.delete".
           *
           * This request holds the parameters needed by the the dataproc server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation resource to be deleted.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(Dataproc.this, "DELETE", REST_PATH, null, com.google.api.services.dataproc.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setBearerToken(java.lang.String bearerToken) {
            return (Delete) super.setBearerToken(bearerToken);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPp(java.lang.Boolean pp) {
            return (Delete) super.setPp(pp);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation resource to be deleted. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation resource to be deleted.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation resource to be deleted. */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets the latest state of a long-running operation. Clients can use this method to poll the
         * operation result at intervals as recommended by the API service.
         *
         * Create a request for the method "operations.get".
         *
         * This request holds the parameters needed by the dataproc server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation resource.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends DataprocRequest<com.google.api.services.dataproc.model.Operation> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/regions/[^/]+/operations/[^/]+$");

          /**
           * Gets the latest state of a long-running operation. Clients can use this method to poll the
           * operation result at intervals as recommended by the API service.
           *
           * Create a request for the method "operations.get".
           *
           * This request holds the parameters needed by the the dataproc server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation resource.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(Dataproc.this, "GET", REST_PATH, null, com.google.api.services.dataproc.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setBearerToken(java.lang.String bearerToken) {
            return (Get) super.setBearerToken(bearerToken);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPp(java.lang.Boolean pp) {
            return (Get) super.setPp(pp);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation resource. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation resource.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation resource. */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists operations that match the specified filter in the request. If the server doesn't support
         * this method, it returns UNIMPLEMENTED.NOTE: the name binding allows API services to override the
         * binding to use different resource name schemes, such as users/operations. To override the
         * binding, API services can add a binding such as "/v1/{name=users}/operations" to their service
         * configuration. For backwards compatibility, the default name includes the operations collection
         * id, however overriding users must ensure the name binding is the parent resource, without the
         * operations collection id.
         *
         * Create a request for the method "operations.list".
         *
         * This request holds the parameters needed by the dataproc server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation's parent resource.
         * @return the request
         */
        public List list(java.lang.String name) throws java.io.IOException {
          List result = new List(name);
          initialize(result);
          return result;
        }

        public class List extends DataprocRequest<com.google.api.services.dataproc.model.ListOperationsResponse> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/regions/[^/]+/operations$");

          /**
           * Lists operations that match the specified filter in the request. If the server doesn't support
           * this method, it returns UNIMPLEMENTED.NOTE: the name binding allows API services to override
           * the binding to use different resource name schemes, such as users/operations. To override the
           * binding, API services can add a binding such as "/v1/{name=users}/operations" to their service
           * configuration. For backwards compatibility, the default name includes the operations collection
           * id, however overriding users must ensure the name binding is the parent resource, without the
           * operations collection id.
           *
           * Create a request for the method "operations.list".
           *
           * This request holds the parameters needed by the the dataproc server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation's parent resource.
           * @since 1.13
           */
          protected List(java.lang.String name) {
            super(Dataproc.this, "GET", REST_PATH, null, com.google.api.services.dataproc.model.ListOperationsResponse.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/regions/[^/]+/operations$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setBearerToken(java.lang.String bearerToken) {
            return (List) super.setBearerToken(bearerToken);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPp(java.lang.Boolean pp) {
            return (List) super.setPp(pp);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation's parent resource. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation's parent resource.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation's parent resource. */
          public List setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/regions/[^/]+/operations$");
            }
            this.name = name;
            return this;
          }

          /** The standard list filter. */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** The standard list filter.
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /** The standard list filter. */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /** The standard list page token. */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** The standard list page token.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /** The standard list page token. */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /** The standard list page size. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** The standard list page size.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** The standard list page size. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
    }
  }

  /**
   * Builder for {@link Dataproc}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Dataproc}. */
    @Override
    public Dataproc build() {
      return new Dataproc(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link DataprocRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setDataprocRequestInitializer(
        DataprocRequestInitializer dataprocRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(dataprocRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
