/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-16 at 06:50:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dataproc.model;

/**
 * Describes the identifying information, config, and status of a cluster of Google Compute Engine
 * instances.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Dataproc API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Cluster extends com.google.api.client.json.GenericJson {

  /**
   * Required. The cluster name. Cluster names within a project must be unique. Names of deleted
   * clusters can be reused.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clusterName;

  /**
   * Output only. A cluster UUID (Unique Universal Identifier). Cloud Dataproc generates this value
   * when it creates the cluster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clusterUuid;

  /**
   * Required. The cluster config. Note that Cloud Dataproc may set default values, and values may
   * change when clusters are updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ClusterConfig config;

  /**
   * Optional. The labels to associate with this cluster. Label keys must contain 1 to 63
   * characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). Label values
   * may be empty, but, if present, must contain 1 to 63 characters, and must conform to RFC 1035
   * (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be associated with a
   * cluster.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * Contains cluster daemon metrics such as HDFS and YARN stats.Beta Feature: This report is
   * available for testing purposes only. It may be changed before final release.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ClusterMetrics metrics;

  /**
   * Required. The Google Cloud Platform project ID that the cluster belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String projectId;

  /**
   * Output only. Cluster status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ClusterStatus status;

  /**
   * Output only. The previous cluster status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ClusterStatus> statusHistory;

  /**
   * Required. The cluster name. Cluster names within a project must be unique. Names of deleted
   * clusters can be reused.
   * @return value or {@code null} for none
   */
  public java.lang.String getClusterName() {
    return clusterName;
  }

  /**
   * Required. The cluster name. Cluster names within a project must be unique. Names of deleted
   * clusters can be reused.
   * @param clusterName clusterName or {@code null} for none
   */
  public Cluster setClusterName(java.lang.String clusterName) {
    this.clusterName = clusterName;
    return this;
  }

  /**
   * Output only. A cluster UUID (Unique Universal Identifier). Cloud Dataproc generates this value
   * when it creates the cluster.
   * @return value or {@code null} for none
   */
  public java.lang.String getClusterUuid() {
    return clusterUuid;
  }

  /**
   * Output only. A cluster UUID (Unique Universal Identifier). Cloud Dataproc generates this value
   * when it creates the cluster.
   * @param clusterUuid clusterUuid or {@code null} for none
   */
  public Cluster setClusterUuid(java.lang.String clusterUuid) {
    this.clusterUuid = clusterUuid;
    return this;
  }

  /**
   * Required. The cluster config. Note that Cloud Dataproc may set default values, and values may
   * change when clusters are updated.
   * @return value or {@code null} for none
   */
  public ClusterConfig getConfig() {
    return config;
  }

  /**
   * Required. The cluster config. Note that Cloud Dataproc may set default values, and values may
   * change when clusters are updated.
   * @param config config or {@code null} for none
   */
  public Cluster setConfig(ClusterConfig config) {
    this.config = config;
    return this;
  }

  /**
   * Optional. The labels to associate with this cluster. Label keys must contain 1 to 63
   * characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). Label values
   * may be empty, but, if present, must contain 1 to 63 characters, and must conform to RFC 1035
   * (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be associated with a
   * cluster.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * Optional. The labels to associate with this cluster. Label keys must contain 1 to 63
   * characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). Label values
   * may be empty, but, if present, must contain 1 to 63 characters, and must conform to RFC 1035
   * (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be associated with a
   * cluster.
   * @param labels labels or {@code null} for none
   */
  public Cluster setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Contains cluster daemon metrics such as HDFS and YARN stats.Beta Feature: This report is
   * available for testing purposes only. It may be changed before final release.
   * @return value or {@code null} for none
   */
  public ClusterMetrics getMetrics() {
    return metrics;
  }

  /**
   * Contains cluster daemon metrics such as HDFS and YARN stats.Beta Feature: This report is
   * available for testing purposes only. It may be changed before final release.
   * @param metrics metrics or {@code null} for none
   */
  public Cluster setMetrics(ClusterMetrics metrics) {
    this.metrics = metrics;
    return this;
  }

  /**
   * Required. The Google Cloud Platform project ID that the cluster belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.String getProjectId() {
    return projectId;
  }

  /**
   * Required. The Google Cloud Platform project ID that the cluster belongs to.
   * @param projectId projectId or {@code null} for none
   */
  public Cluster setProjectId(java.lang.String projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Output only. Cluster status.
   * @return value or {@code null} for none
   */
  public ClusterStatus getStatus() {
    return status;
  }

  /**
   * Output only. Cluster status.
   * @param status status or {@code null} for none
   */
  public Cluster setStatus(ClusterStatus status) {
    this.status = status;
    return this;
  }

  /**
   * Output only. The previous cluster status.
   * @return value or {@code null} for none
   */
  public java.util.List<ClusterStatus> getStatusHistory() {
    return statusHistory;
  }

  /**
   * Output only. The previous cluster status.
   * @param statusHistory statusHistory or {@code null} for none
   */
  public Cluster setStatusHistory(java.util.List<ClusterStatus> statusHistory) {
    this.statusHistory = statusHistory;
    return this;
  }

  @Override
  public Cluster set(String fieldName, Object value) {
    return (Cluster) super.set(fieldName, value);
  }

  @Override
  public Cluster clone() {
    return (Cluster) super.clone();
  }

}
