/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-16 at 06:50:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dataproc.model;

/**
 * The status of the operation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Dataproc API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ClusterOperationStatus extends com.google.api.client.json.GenericJson {

  /**
   * Output only. A message containing any operation metadata details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String details;

  /**
   * Output only. A message containing the detailed operation state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String innerState;

  /**
   * Output only. A message containing the operation state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Output only. The time this state was entered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String stateStartTime;

  /**
   * Output only. A message containing any operation metadata details.
   * @return value or {@code null} for none
   */
  public java.lang.String getDetails() {
    return details;
  }

  /**
   * Output only. A message containing any operation metadata details.
   * @param details details or {@code null} for none
   */
  public ClusterOperationStatus setDetails(java.lang.String details) {
    this.details = details;
    return this;
  }

  /**
   * Output only. A message containing the detailed operation state.
   * @return value or {@code null} for none
   */
  public java.lang.String getInnerState() {
    return innerState;
  }

  /**
   * Output only. A message containing the detailed operation state.
   * @param innerState innerState or {@code null} for none
   */
  public ClusterOperationStatus setInnerState(java.lang.String innerState) {
    this.innerState = innerState;
    return this;
  }

  /**
   * Output only. A message containing the operation state.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. A message containing the operation state.
   * @param state state or {@code null} for none
   */
  public ClusterOperationStatus setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Output only. The time this state was entered.
   * @return value or {@code null} for none
   */
  public String getStateStartTime() {
    return stateStartTime;
  }

  /**
   * Output only. The time this state was entered.
   * @param stateStartTime stateStartTime or {@code null} for none
   */
  public ClusterOperationStatus setStateStartTime(String stateStartTime) {
    this.stateStartTime = stateStartTime;
    return this;
  }

  @Override
  public ClusterOperationStatus set(String fieldName, Object value) {
    return (ClusterOperationStatus) super.set(fieldName, value);
  }

  @Override
  public ClusterOperationStatus clone() {
    return (ClusterOperationStatus) super.clone();
  }

}
