/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-16 at 06:50:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dataproc.model;

/**
 * The status of a cluster and its instances.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Dataproc API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ClusterStatus extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Optional details of cluster's state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String detail;

  /**
   * Output only. The cluster's state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Output only. Time when this state was entered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String stateStartTime;

  /**
   * Output only. Additional state information that includes status reported by the agent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String substate;

  /**
   * Output only. Optional details of cluster's state.
   * @return value or {@code null} for none
   */
  public java.lang.String getDetail() {
    return detail;
  }

  /**
   * Output only. Optional details of cluster's state.
   * @param detail detail or {@code null} for none
   */
  public ClusterStatus setDetail(java.lang.String detail) {
    this.detail = detail;
    return this;
  }

  /**
   * Output only. The cluster's state.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. The cluster's state.
   * @param state state or {@code null} for none
   */
  public ClusterStatus setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Output only. Time when this state was entered.
   * @return value or {@code null} for none
   */
  public String getStateStartTime() {
    return stateStartTime;
  }

  /**
   * Output only. Time when this state was entered.
   * @param stateStartTime stateStartTime or {@code null} for none
   */
  public ClusterStatus setStateStartTime(String stateStartTime) {
    this.stateStartTime = stateStartTime;
    return this;
  }

  /**
   * Output only. Additional state information that includes status reported by the agent.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubstate() {
    return substate;
  }

  /**
   * Output only. Additional state information that includes status reported by the agent.
   * @param substate substate or {@code null} for none
   */
  public ClusterStatus setSubstate(java.lang.String substate) {
    this.substate = substate;
    return this;
  }

  @Override
  public ClusterStatus set(String fieldName, Object value) {
    return (ClusterStatus) super.set(fieldName, value);
  }

  @Override
  public ClusterStatus clone() {
    return (ClusterStatus) super.clone();
  }

}
