/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-16 at 06:50:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dataproc.model;

/**
 * Specifies the resources used to actively manage an instance group.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Dataproc API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ManagedGroupConfig extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The name of the Instance Group Manager for this group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instanceGroupManagerName;

  /**
   * Output only. The name of the Instance Template used for the Managed Instance Group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instanceTemplateName;

  /**
   * Output only. The name of the Instance Group Manager for this group.
   * @return value or {@code null} for none
   */
  public java.lang.String getInstanceGroupManagerName() {
    return instanceGroupManagerName;
  }

  /**
   * Output only. The name of the Instance Group Manager for this group.
   * @param instanceGroupManagerName instanceGroupManagerName or {@code null} for none
   */
  public ManagedGroupConfig setInstanceGroupManagerName(java.lang.String instanceGroupManagerName) {
    this.instanceGroupManagerName = instanceGroupManagerName;
    return this;
  }

  /**
   * Output only. The name of the Instance Template used for the Managed Instance Group.
   * @return value or {@code null} for none
   */
  public java.lang.String getInstanceTemplateName() {
    return instanceTemplateName;
  }

  /**
   * Output only. The name of the Instance Template used for the Managed Instance Group.
   * @param instanceTemplateName instanceTemplateName or {@code null} for none
   */
  public ManagedGroupConfig setInstanceTemplateName(java.lang.String instanceTemplateName) {
    this.instanceTemplateName = instanceTemplateName;
    return this;
  }

  @Override
  public ManagedGroupConfig set(String fieldName, Object value) {
    return (ManagedGroupConfig) super.set(fieldName, value);
  }

  @Override
  public ManagedGroupConfig clone() {
    return (ManagedGroupConfig) super.clone();
  }

}
