/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-16 at 06:50:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dataproc.model;

/**
 * Specifies the selection and config of software inside the cluster.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Dataproc API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SoftwareConfig extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The version of software inside the cluster. It must match the regular expression
   * [0-9]+\.[0-9]+. If unspecified, it defaults to the latest version (see Cloud Dataproc
   * Versioning).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String imageVersion;

  /**
   * Optional. The properties to set on daemon config files.Property keys are specified in
   * prefix:property format, such as core:fs.defaultFS. The following are supported prefixes and
   * their mappings: capacity-scheduler: capacity-scheduler.xml core: core-site.xml distcp: distcp-
   * default.xml hdfs: hdfs-site.xml hive: hive-site.xml mapred: mapred-site.xml pig: pig.properties
   * spark: spark-defaults.conf yarn: yarn-site.xmlFor more information, see Cluster properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> properties;

  /**
   * Optional. The version of software inside the cluster. It must match the regular expression
   * [0-9]+\.[0-9]+. If unspecified, it defaults to the latest version (see Cloud Dataproc
   * Versioning).
   * @return value or {@code null} for none
   */
  public java.lang.String getImageVersion() {
    return imageVersion;
  }

  /**
   * Optional. The version of software inside the cluster. It must match the regular expression
   * [0-9]+\.[0-9]+. If unspecified, it defaults to the latest version (see Cloud Dataproc
   * Versioning).
   * @param imageVersion imageVersion or {@code null} for none
   */
  public SoftwareConfig setImageVersion(java.lang.String imageVersion) {
    this.imageVersion = imageVersion;
    return this;
  }

  /**
   * Optional. The properties to set on daemon config files.Property keys are specified in
   * prefix:property format, such as core:fs.defaultFS. The following are supported prefixes and
   * their mappings: capacity-scheduler: capacity-scheduler.xml core: core-site.xml distcp: distcp-
   * default.xml hdfs: hdfs-site.xml hive: hive-site.xml mapred: mapred-site.xml pig: pig.properties
   * spark: spark-defaults.conf yarn: yarn-site.xmlFor more information, see Cluster properties.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getProperties() {
    return properties;
  }

  /**
   * Optional. The properties to set on daemon config files.Property keys are specified in
   * prefix:property format, such as core:fs.defaultFS. The following are supported prefixes and
   * their mappings: capacity-scheduler: capacity-scheduler.xml core: core-site.xml distcp: distcp-
   * default.xml hdfs: hdfs-site.xml hive: hive-site.xml mapred: mapred-site.xml pig: pig.properties
   * spark: spark-defaults.conf yarn: yarn-site.xmlFor more information, see Cluster properties.
   * @param properties properties or {@code null} for none
   */
  public SoftwareConfig setProperties(java.util.Map<String, java.lang.String> properties) {
    this.properties = properties;
    return this;
  }

  @Override
  public SoftwareConfig set(String fieldName, Object value) {
    return (SoftwareConfig) super.set(fieldName, value);
  }

  @Override
  public SoftwareConfig clone() {
    return (SoftwareConfig) super.clone();
  }

}
