/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-16 at 06:50:10 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.dataproc.model;

/**
 * A Cloud Dataproc job for running Apache Spark SQL (http://spark.apache.org/sql/) queries.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Cloud Dataproc API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SparkSqlJob extends com.google.api.client.json.GenericJson {

  /**
   * Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> jarFileUris;

  /**
   * Optional. The runtime log config for job execution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LoggingConfig loggingConfig;

  /**
   * Optional. A mapping of property names to values, used to configure Spark SQL's SparkConf.
   * Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> properties;

  /**
   * The HCFS URI of the script that contains SQL queries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String queryFileUri;

  /**
   * A list of queries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private QueryList queryList;

  /**
   * Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET
   * name="value";).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> scriptVariables;

  /**
   * Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getJarFileUris() {
    return jarFileUris;
  }

  /**
   * Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
   * @param jarFileUris jarFileUris or {@code null} for none
   */
  public SparkSqlJob setJarFileUris(java.util.List<java.lang.String> jarFileUris) {
    this.jarFileUris = jarFileUris;
    return this;
  }

  /**
   * Optional. The runtime log config for job execution.
   * @return value or {@code null} for none
   */
  public LoggingConfig getLoggingConfig() {
    return loggingConfig;
  }

  /**
   * Optional. The runtime log config for job execution.
   * @param loggingConfig loggingConfig or {@code null} for none
   */
  public SparkSqlJob setLoggingConfig(LoggingConfig loggingConfig) {
    this.loggingConfig = loggingConfig;
    return this;
  }

  /**
   * Optional. A mapping of property names to values, used to configure Spark SQL's SparkConf.
   * Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getProperties() {
    return properties;
  }

  /**
   * Optional. A mapping of property names to values, used to configure Spark SQL's SparkConf.
   * Properties that conflict with values set by the Cloud Dataproc API may be overwritten.
   * @param properties properties or {@code null} for none
   */
  public SparkSqlJob setProperties(java.util.Map<String, java.lang.String> properties) {
    this.properties = properties;
    return this;
  }

  /**
   * The HCFS URI of the script that contains SQL queries.
   * @return value or {@code null} for none
   */
  public java.lang.String getQueryFileUri() {
    return queryFileUri;
  }

  /**
   * The HCFS URI of the script that contains SQL queries.
   * @param queryFileUri queryFileUri or {@code null} for none
   */
  public SparkSqlJob setQueryFileUri(java.lang.String queryFileUri) {
    this.queryFileUri = queryFileUri;
    return this;
  }

  /**
   * A list of queries.
   * @return value or {@code null} for none
   */
  public QueryList getQueryList() {
    return queryList;
  }

  /**
   * A list of queries.
   * @param queryList queryList or {@code null} for none
   */
  public SparkSqlJob setQueryList(QueryList queryList) {
    this.queryList = queryList;
    return this;
  }

  /**
   * Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET
   * name="value";).
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getScriptVariables() {
    return scriptVariables;
  }

  /**
   * Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET
   * name="value";).
   * @param scriptVariables scriptVariables or {@code null} for none
   */
  public SparkSqlJob setScriptVariables(java.util.Map<String, java.lang.String> scriptVariables) {
    this.scriptVariables = scriptVariables;
    return this;
  }

  @Override
  public SparkSqlJob set(String fieldName, Object value) {
    return (SparkSqlJob) super.set(fieldName, value);
  }

  @Override
  public SparkSqlJob clone() {
    return (SparkSqlJob) super.clone();
  }

}
