/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.dataproc;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.dataproc.DataprocRequest;
import com.google.api.services.dataproc.DataprocRequestInitializer;
import com.google.api.services.dataproc.model.CancelJobRequest;
import com.google.api.services.dataproc.model.Cluster;
import com.google.api.services.dataproc.model.DiagnoseClusterRequest;
import com.google.api.services.dataproc.model.Empty;
import com.google.api.services.dataproc.model.Job;
import com.google.api.services.dataproc.model.ListClustersResponse;
import com.google.api.services.dataproc.model.ListJobsResponse;
import com.google.api.services.dataproc.model.ListOperationsResponse;
import com.google.api.services.dataproc.model.Operation;
import com.google.api.services.dataproc.model.SubmitJobRequest;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dataproc
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://dataproc.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://dataproc.googleapis.com/";

    public Dataproc(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Dataproc(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.23.0 of the Google Cloud Dataproc API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://dataproc.googleapis.com/", Dataproc.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Dataproc.DEFAULT_BATCH_PATH);
        }

        public Dataproc build() {
            return new Dataproc(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDataprocRequestInitializer(DataprocRequestInitializer dataprocRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)dataprocRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Regions regions() {
            return new Regions();
        }

        public class Regions {
            public Clusters clusters() {
                return new Clusters();
            }

            public Jobs jobs() {
                return new Jobs();
            }

            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Cancel cancel(String string) throws IOException {
                    Cancel cancel = new Cancel(string);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)cancel);
                    return cancel;
                }

                public Delete delete(String string) throws IOException {
                    Delete delete = new Delete(string);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends DataprocRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String filter;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String string) {
                        super(Dataproc.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/operations$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String string) {
                        this.filter = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends DataprocRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String string) {
                        super(Dataproc.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setBearerToken(String string) {
                        return (Get)super.setBearerToken(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPp(Boolean bl) {
                        return (Get)super.setPp(bl);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends DataprocRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String string) {
                        super(Dataproc.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setBearerToken(String string) {
                        return (Delete)super.setBearerToken(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPp(Boolean bl) {
                        return (Delete)super.setPp(bl);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Cancel
                extends DataprocRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String string) {
                        super(Dataproc.this, "POST", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String string) {
                        return (Cancel)super.set$Xgafv(string);
                    }

                    public Cancel setAccessToken(String string) {
                        return (Cancel)super.setAccessToken(string);
                    }

                    public Cancel setAlt(String string) {
                        return (Cancel)super.setAlt(string);
                    }

                    public Cancel setBearerToken(String string) {
                        return (Cancel)super.setBearerToken(string);
                    }

                    public Cancel setCallback(String string) {
                        return (Cancel)super.setCallback(string);
                    }

                    public Cancel setFields(String string) {
                        return (Cancel)super.setFields(string);
                    }

                    public Cancel setKey(String string) {
                        return (Cancel)super.setKey(string);
                    }

                    public Cancel setOauthToken(String string) {
                        return (Cancel)super.setOauthToken(string);
                    }

                    public Cancel setPp(Boolean bl) {
                        return (Cancel)super.setPp(bl);
                    }

                    public Cancel setPrettyPrint(Boolean bl) {
                        return (Cancel)super.setPrettyPrint(bl);
                    }

                    public Cancel setQuotaUser(String string) {
                        return (Cancel)super.setQuotaUser(string);
                    }

                    public Cancel setUploadType(String string) {
                        return (Cancel)super.setUploadType(string);
                    }

                    public Cancel setUploadProtocol(String string) {
                        return (Cancel)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String string) {
                        if (!Dataproc.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/regions/[^/]+/operations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Cancel set(String string, Object object) {
                        return (Cancel)super.set(string, object);
                    }
                }
            }

            public class Jobs {
                public Cancel cancel(String string, String string2, String string3, CancelJobRequest cancelJobRequest) throws IOException {
                    Cancel cancel = new Cancel(string, string2, string3, cancelJobRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)cancel);
                    return cancel;
                }

                public Delete delete(String string, String string2, String string3) throws IOException {
                    Delete delete = new Delete(string, string2, string3);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string, String string2, String string3) throws IOException {
                    Get get = new Get(string, string2, string3);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string, String string2) throws IOException {
                    List list = new List(string, string2);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Patch patch(String string, String string2, String string3, Job job) throws IOException {
                    Patch patch = new Patch(string, string2, string3, job);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)patch);
                    return patch;
                }

                public Submit submit(String string, String string2, SubmitJobRequest submitJobRequest) throws IOException {
                    Submit submit = new Submit(string, string2, submitJobRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)submit);
                    return submit;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Submit
                extends DataprocRequest<Job> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs:submit";
                    @Key
                    private String projectId;
                    @Key
                    private String region;

                    protected Submit(String string, String string2, SubmitJobRequest submitJobRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)submitJobRequest, Job.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                    }

                    public Submit set$Xgafv(String string) {
                        return (Submit)super.set$Xgafv(string);
                    }

                    public Submit setAccessToken(String string) {
                        return (Submit)super.setAccessToken(string);
                    }

                    public Submit setAlt(String string) {
                        return (Submit)super.setAlt(string);
                    }

                    public Submit setBearerToken(String string) {
                        return (Submit)super.setBearerToken(string);
                    }

                    public Submit setCallback(String string) {
                        return (Submit)super.setCallback(string);
                    }

                    public Submit setFields(String string) {
                        return (Submit)super.setFields(string);
                    }

                    public Submit setKey(String string) {
                        return (Submit)super.setKey(string);
                    }

                    public Submit setOauthToken(String string) {
                        return (Submit)super.setOauthToken(string);
                    }

                    public Submit setPp(Boolean bl) {
                        return (Submit)super.setPp(bl);
                    }

                    public Submit setPrettyPrint(Boolean bl) {
                        return (Submit)super.setPrettyPrint(bl);
                    }

                    public Submit setQuotaUser(String string) {
                        return (Submit)super.setQuotaUser(string);
                    }

                    public Submit setUploadType(String string) {
                        return (Submit)super.setUploadType(string);
                    }

                    public Submit setUploadProtocol(String string) {
                        return (Submit)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Submit setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Submit setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    @Override
                    public Submit set(String string, Object object) {
                        return (Submit)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Patch
                extends DataprocRequest<Job> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs/{jobId}";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String jobId;
                    @Key
                    private String updateMask;

                    protected Patch(String string, String string2, String string3, Job job) {
                        super(Dataproc.this, "PATCH", REST_PATH, (Object)job, Job.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter jobId must be specified.");
                    }

                    public Patch set$Xgafv(String string) {
                        return (Patch)super.set$Xgafv(string);
                    }

                    public Patch setAccessToken(String string) {
                        return (Patch)super.setAccessToken(string);
                    }

                    public Patch setAlt(String string) {
                        return (Patch)super.setAlt(string);
                    }

                    public Patch setBearerToken(String string) {
                        return (Patch)super.setBearerToken(string);
                    }

                    public Patch setCallback(String string) {
                        return (Patch)super.setCallback(string);
                    }

                    public Patch setFields(String string) {
                        return (Patch)super.setFields(string);
                    }

                    public Patch setKey(String string) {
                        return (Patch)super.setKey(string);
                    }

                    public Patch setOauthToken(String string) {
                        return (Patch)super.setOauthToken(string);
                    }

                    public Patch setPp(Boolean bl) {
                        return (Patch)super.setPp(bl);
                    }

                    public Patch setPrettyPrint(Boolean bl) {
                        return (Patch)super.setPrettyPrint(bl);
                    }

                    public Patch setQuotaUser(String string) {
                        return (Patch)super.setQuotaUser(string);
                    }

                    public Patch setUploadType(String string) {
                        return (Patch)super.setUploadType(string);
                    }

                    public Patch setUploadProtocol(String string) {
                        return (Patch)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Patch setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Patch setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public Patch setJobId(String string) {
                        this.jobId = string;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String string) {
                        this.updateMask = string;
                        return this;
                    }

                    @Override
                    public Patch set(String string, Object object) {
                        return (Patch)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends DataprocRequest<ListJobsResponse> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String clusterName;
                    @Key
                    private String filter;
                    @Key
                    private String jobStateMatcher;

                    protected List(String string, String string2) {
                        super(Dataproc.this, "GET", REST_PATH, null, ListJobsResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public List setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    public String getClusterName() {
                        return this.clusterName;
                    }

                    public List setClusterName(String string) {
                        this.clusterName = string;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String string) {
                        this.filter = string;
                        return this;
                    }

                    public String getJobStateMatcher() {
                        return this.jobStateMatcher;
                    }

                    public List setJobStateMatcher(String string) {
                        this.jobStateMatcher = string;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends DataprocRequest<Job> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs/{jobId}";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String jobId;

                    protected Get(String string, String string2, String string3) {
                        super(Dataproc.this, "GET", REST_PATH, null, Job.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter jobId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setBearerToken(String string) {
                        return (Get)super.setBearerToken(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPp(Boolean bl) {
                        return (Get)super.setPp(bl);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Get setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public Get setJobId(String string) {
                        this.jobId = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends DataprocRequest<Empty> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs/{jobId}";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String jobId;

                    protected Delete(String string, String string2, String string3) {
                        super(Dataproc.this, "DELETE", REST_PATH, null, Empty.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter jobId must be specified.");
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setBearerToken(String string) {
                        return (Delete)super.setBearerToken(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPp(Boolean bl) {
                        return (Delete)super.setPp(bl);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Delete setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Delete setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public Delete setJobId(String string) {
                        this.jobId = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Cancel
                extends DataprocRequest<Job> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/jobs/{jobId}:cancel";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String jobId;

                    protected Cancel(String string, String string2, String string3, CancelJobRequest cancelJobRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)cancelJobRequest, Job.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                        this.jobId = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter jobId must be specified.");
                    }

                    public Cancel set$Xgafv(String string) {
                        return (Cancel)super.set$Xgafv(string);
                    }

                    public Cancel setAccessToken(String string) {
                        return (Cancel)super.setAccessToken(string);
                    }

                    public Cancel setAlt(String string) {
                        return (Cancel)super.setAlt(string);
                    }

                    public Cancel setBearerToken(String string) {
                        return (Cancel)super.setBearerToken(string);
                    }

                    public Cancel setCallback(String string) {
                        return (Cancel)super.setCallback(string);
                    }

                    public Cancel setFields(String string) {
                        return (Cancel)super.setFields(string);
                    }

                    public Cancel setKey(String string) {
                        return (Cancel)super.setKey(string);
                    }

                    public Cancel setOauthToken(String string) {
                        return (Cancel)super.setOauthToken(string);
                    }

                    public Cancel setPp(Boolean bl) {
                        return (Cancel)super.setPp(bl);
                    }

                    public Cancel setPrettyPrint(Boolean bl) {
                        return (Cancel)super.setPrettyPrint(bl);
                    }

                    public Cancel setQuotaUser(String string) {
                        return (Cancel)super.setQuotaUser(string);
                    }

                    public Cancel setUploadType(String string) {
                        return (Cancel)super.setUploadType(string);
                    }

                    public Cancel setUploadProtocol(String string) {
                        return (Cancel)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Cancel setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Cancel setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getJobId() {
                        return this.jobId;
                    }

                    public Cancel setJobId(String string) {
                        this.jobId = string;
                        return this;
                    }

                    @Override
                    public Cancel set(String string, Object object) {
                        return (Cancel)super.set(string, object);
                    }
                }
            }

            public class Clusters {
                public Create create(String string, String string2, Cluster cluster) throws IOException {
                    Create create = new Create(string, string2, cluster);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string, String string2, String string3) throws IOException {
                    Delete delete = new Delete(string, string2, string3);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Diagnose diagnose(String string, String string2, String string3, DiagnoseClusterRequest diagnoseClusterRequest) throws IOException {
                    Diagnose diagnose = new Diagnose(string, string2, string3, diagnoseClusterRequest);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)diagnose);
                    return diagnose;
                }

                public Get get(String string, String string2, String string3) throws IOException {
                    Get get = new Get(string, string2, string3);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string, String string2) throws IOException {
                    List list = new List(string, string2);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Patch patch(String string, String string2, String string3, Cluster cluster) throws IOException {
                    Patch patch = new Patch(string, string2, string3, cluster);
                    Dataproc.this.initialize((AbstractGoogleClientRequest<?>)patch);
                    return patch;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Patch
                extends DataprocRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String clusterName;
                    @Key
                    private String updateMask;
                    @Key
                    private String gracefulDecommissionTimeout;

                    protected Patch(String string, String string2, String string3, Cluster cluster) {
                        super(Dataproc.this, "PATCH", REST_PATH, (Object)cluster, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                        this.clusterName = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterName must be specified.");
                    }

                    public Patch set$Xgafv(String string) {
                        return (Patch)super.set$Xgafv(string);
                    }

                    public Patch setAccessToken(String string) {
                        return (Patch)super.setAccessToken(string);
                    }

                    public Patch setAlt(String string) {
                        return (Patch)super.setAlt(string);
                    }

                    public Patch setBearerToken(String string) {
                        return (Patch)super.setBearerToken(string);
                    }

                    public Patch setCallback(String string) {
                        return (Patch)super.setCallback(string);
                    }

                    public Patch setFields(String string) {
                        return (Patch)super.setFields(string);
                    }

                    public Patch setKey(String string) {
                        return (Patch)super.setKey(string);
                    }

                    public Patch setOauthToken(String string) {
                        return (Patch)super.setOauthToken(string);
                    }

                    public Patch setPp(Boolean bl) {
                        return (Patch)super.setPp(bl);
                    }

                    public Patch setPrettyPrint(Boolean bl) {
                        return (Patch)super.setPrettyPrint(bl);
                    }

                    public Patch setQuotaUser(String string) {
                        return (Patch)super.setQuotaUser(string);
                    }

                    public Patch setUploadType(String string) {
                        return (Patch)super.setUploadType(string);
                    }

                    public Patch setUploadProtocol(String string) {
                        return (Patch)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Patch setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Patch setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getClusterName() {
                        return this.clusterName;
                    }

                    public Patch setClusterName(String string) {
                        this.clusterName = string;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String string) {
                        this.updateMask = string;
                        return this;
                    }

                    public String getGracefulDecommissionTimeout() {
                        return this.gracefulDecommissionTimeout;
                    }

                    public Patch setGracefulDecommissionTimeout(String string) {
                        this.gracefulDecommissionTimeout = string;
                        return this;
                    }

                    @Override
                    public Patch set(String string, Object object) {
                        return (Patch)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends DataprocRequest<ListClustersResponse> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String filter;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String string, String string2) {
                        super(Dataproc.this, "GET", REST_PATH, null, ListClustersResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setBearerToken(String string) {
                        return (List)super.setBearerToken(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPp(Boolean bl) {
                        return (List)super.setPp(bl);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public List setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String string) {
                        this.filter = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends DataprocRequest<Cluster> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String clusterName;

                    protected Get(String string, String string2, String string3) {
                        super(Dataproc.this, "GET", REST_PATH, null, Cluster.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                        this.clusterName = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterName must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setBearerToken(String string) {
                        return (Get)super.setBearerToken(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPp(Boolean bl) {
                        return (Get)super.setPp(bl);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Get setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getClusterName() {
                        return this.clusterName;
                    }

                    public Get setClusterName(String string) {
                        this.clusterName = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Diagnose
                extends DataprocRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}:diagnose";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String clusterName;

                    protected Diagnose(String string, String string2, String string3, DiagnoseClusterRequest diagnoseClusterRequest) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)diagnoseClusterRequest, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                        this.clusterName = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterName must be specified.");
                    }

                    public Diagnose set$Xgafv(String string) {
                        return (Diagnose)super.set$Xgafv(string);
                    }

                    public Diagnose setAccessToken(String string) {
                        return (Diagnose)super.setAccessToken(string);
                    }

                    public Diagnose setAlt(String string) {
                        return (Diagnose)super.setAlt(string);
                    }

                    public Diagnose setBearerToken(String string) {
                        return (Diagnose)super.setBearerToken(string);
                    }

                    public Diagnose setCallback(String string) {
                        return (Diagnose)super.setCallback(string);
                    }

                    public Diagnose setFields(String string) {
                        return (Diagnose)super.setFields(string);
                    }

                    public Diagnose setKey(String string) {
                        return (Diagnose)super.setKey(string);
                    }

                    public Diagnose setOauthToken(String string) {
                        return (Diagnose)super.setOauthToken(string);
                    }

                    public Diagnose setPp(Boolean bl) {
                        return (Diagnose)super.setPp(bl);
                    }

                    public Diagnose setPrettyPrint(Boolean bl) {
                        return (Diagnose)super.setPrettyPrint(bl);
                    }

                    public Diagnose setQuotaUser(String string) {
                        return (Diagnose)super.setQuotaUser(string);
                    }

                    public Diagnose setUploadType(String string) {
                        return (Diagnose)super.setUploadType(string);
                    }

                    public Diagnose setUploadProtocol(String string) {
                        return (Diagnose)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Diagnose setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Diagnose setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getClusterName() {
                        return this.clusterName;
                    }

                    public Diagnose setClusterName(String string) {
                        this.clusterName = string;
                        return this;
                    }

                    @Override
                    public Diagnose set(String string, Object object) {
                        return (Diagnose)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends DataprocRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}";
                    @Key
                    private String projectId;
                    @Key
                    private String region;
                    @Key
                    private String clusterName;
                    @Key
                    private String clusterUuid;

                    protected Delete(String string, String string2, String string3) {
                        super(Dataproc.this, "DELETE", REST_PATH, null, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                        this.clusterName = (String)Preconditions.checkNotNull((Object)string3, (Object)"Required parameter clusterName must be specified.");
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setBearerToken(String string) {
                        return (Delete)super.setBearerToken(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPp(Boolean bl) {
                        return (Delete)super.setPp(bl);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Delete setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Delete setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    public String getClusterName() {
                        return this.clusterName;
                    }

                    public Delete setClusterName(String string) {
                        this.clusterName = string;
                        return this;
                    }

                    public String getClusterUuid() {
                        return this.clusterUuid;
                    }

                    public Delete setClusterUuid(String string) {
                        this.clusterUuid = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends DataprocRequest<Operation> {
                    private static final String REST_PATH = "v1/projects/{projectId}/regions/{region}/clusters";
                    @Key
                    private String projectId;
                    @Key
                    private String region;

                    protected Create(String string, String string2, Cluster cluster) {
                        super(Dataproc.this, "POST", REST_PATH, (Object)cluster, Operation.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter projectId must be specified.");
                        this.region = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter region must be specified.");
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setBearerToken(String string) {
                        return (Create)super.setBearerToken(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPp(Boolean bl) {
                        return (Create)super.setPp(bl);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Create setProjectId(String string) {
                        this.projectId = string;
                        return this;
                    }

                    public String getRegion() {
                        return this.region;
                    }

                    public Create setRegion(String string) {
                        this.region = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }
            }
        }
    }
}

