/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.datastore.client;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.compute.ComputeCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.datastore.DatastoreV1;
import com.google.api.services.datastore.client.Datastore;
import com.google.api.services.datastore.client.DatastoreFactory;
import com.google.api.services.datastore.client.DatastoreOptions;
import com.google.api.services.datastore.client.QuerySplitter;
import com.google.api.services.datastore.client.QuerySplitterImpl;
import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class DatastoreHelper {
    private static final Logger logger = Logger.getLogger(DatastoreHelper.class.getName());
    public static final String SCATTER_PROPERTY_NAME = "__scatter__";
    public static final String KEY_PROPERTY_NAME = "__key__";

    private DatastoreHelper() {
    }

    public static Credential getComputeEngineCredential() throws GeneralSecurityException, IOException {
        NetHttpTransport transport = GoogleNetHttpTransport.newTrustedTransport();
        try {
            ComputeCredential credential = new ComputeCredential((HttpTransport)transport, (JsonFactory)new JacksonFactory());
            credential.refreshToken();
            return credential;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Credential getServiceAccountCredential(String account, String privateKeyFile) throws GeneralSecurityException, IOException {
        return DatastoreHelper.getServiceAccountCredential(account, privateKeyFile, DatastoreOptions.SCOPES);
    }

    public static Credential getServiceAccountCredential(String account, String privateKeyFile, Collection<String> serviceAccountScopes) throws GeneralSecurityException, IOException {
        return DatastoreHelper.getCredentialBuilderWithoutPrivateKey(account, serviceAccountScopes).setServiceAccountPrivateKeyFromP12File(new File(privateKeyFile)).build();
    }

    public static Credential getServiceAccountCredential(String account, PrivateKey privateKey, Collection<String> serviceAccountScopes) throws GeneralSecurityException, IOException {
        return DatastoreHelper.getCredentialBuilderWithoutPrivateKey(account, serviceAccountScopes).setServiceAccountPrivateKey(privateKey).build();
    }

    private static GoogleCredential.Builder getCredentialBuilderWithoutPrivateKey(String account, Collection<String> scopes) throws GeneralSecurityException, IOException {
        NetHttpTransport transport = GoogleNetHttpTransport.newTrustedTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        return new GoogleCredential.Builder().setTransport((HttpTransport)transport).setJsonFactory((JsonFactory)jsonFactory).setServiceAccountId(account).setServiceAccountScopes(scopes);
    }

    public static DatastoreOptions.Builder getOptionsFromEnv() throws GeneralSecurityException, IOException {
        Credential credential;
        DatastoreOptions.Builder options = new DatastoreOptions.Builder();
        options.dataset(System.getenv("DATASTORE_DATASET"));
        options.host(System.getenv("DATASTORE_HOST"));
        if (System.getenv("DATASTORE_SERVICE_ACCOUNT") != null && System.getenv("DATASTORE_PRIVATE_KEY_FILE") != null) {
            credential = DatastoreHelper.getServiceAccountCredential(System.getenv("DATASTORE_SERVICE_ACCOUNT"), System.getenv("DATASTORE_PRIVATE_KEY_FILE"));
            logger.info("Using JWT Service Account credential.");
        } else {
            credential = DatastoreHelper.getComputeEngineCredential();
            if (credential != null) {
                logger.info("Using Compute Engine credential.");
            } else {
                logger.info("Using no credential.");
            }
        }
        options.credential(credential);
        return options;
    }

    public static Datastore getDatastoreFromEnv() throws GeneralSecurityException, IOException {
        return DatastoreFactory.get().create(DatastoreHelper.getOptionsFromEnv().build());
    }

    public static QuerySplitter getQuerySplitter() {
        return QuerySplitterImpl.INSTANCE;
    }

    public static Comparator<DatastoreV1.Key> getKeyComparator() {
        return KeyComparator.INSTANCE;
    }

    public static DatastoreV1.PropertyOrder.Builder makeOrder(String property, DatastoreV1.PropertyOrder.Direction direction) {
        return DatastoreV1.PropertyOrder.newBuilder().setProperty(DatastoreHelper.makePropertyReference(property)).setDirection(direction);
    }

    public static DatastoreV1.Filter.Builder makeFilter(String property, DatastoreV1.PropertyFilter.Operator operator, DatastoreV1.Value value) {
        return DatastoreV1.Filter.newBuilder().setPropertyFilter(DatastoreV1.PropertyFilter.newBuilder().setProperty(DatastoreHelper.makePropertyReference(property)).setOperator(operator).setValue(value));
    }

    public static DatastoreV1.Filter.Builder makeFilter(String property, DatastoreV1.PropertyFilter.Operator operator, DatastoreV1.Value.Builder value) {
        return DatastoreHelper.makeFilter(property, operator, value.build());
    }

    public static DatastoreV1.Filter.Builder makeFilter(DatastoreV1.Filter ... subfilters) {
        return DatastoreHelper.makeFilter(Arrays.asList(subfilters));
    }

    public static DatastoreV1.Filter.Builder makeFilter(Iterable<DatastoreV1.Filter> subfilters) {
        return DatastoreV1.Filter.newBuilder().setCompositeFilter(DatastoreV1.CompositeFilter.newBuilder().addAllFilter(subfilters).setOperator(DatastoreV1.CompositeFilter.Operator.AND));
    }

    public static DatastoreV1.Property.Builder makeProperty(String name, DatastoreV1.Value value) {
        return DatastoreV1.Property.newBuilder().setName(name).setValue(value);
    }

    public static DatastoreV1.Property.Builder makeProperty(String name, DatastoreV1.Value.Builder value) {
        return DatastoreHelper.makeProperty(name, value.build());
    }

    public static DatastoreV1.PropertyReference.Builder makePropertyReference(String propertyName) {
        return DatastoreV1.PropertyReference.newBuilder().setName(propertyName);
    }

    public static DatastoreV1.Value.Builder makeValue(Iterable<DatastoreV1.Value> listValues) {
        return DatastoreV1.Value.newBuilder().addAllListValue(listValues);
    }

    public static DatastoreV1.Value.Builder makeValue(DatastoreV1.Value ... values) {
        return DatastoreHelper.makeValue(Arrays.asList(values));
    }

    public static DatastoreV1.Value.Builder makeValue(DatastoreV1.Value.Builder ... builders) {
        DatastoreV1.Value.Builder value = DatastoreV1.Value.newBuilder();
        for (DatastoreV1.Value.Builder builder : builders) {
            value.addListValue(builder);
        }
        return value;
    }

    public static DatastoreV1.Value.Builder makeValue(DatastoreV1.Key key) {
        return DatastoreV1.Value.newBuilder().setKeyValue(key);
    }

    public static DatastoreV1.Value.Builder makeValue(DatastoreV1.Key.Builder key) {
        return DatastoreHelper.makeValue(key.build());
    }

    public static DatastoreV1.Value.Builder makeValue(long key) {
        return DatastoreV1.Value.newBuilder().setIntegerValue(key);
    }

    public static DatastoreV1.Value.Builder makeValue(double value) {
        return DatastoreV1.Value.newBuilder().setDoubleValue(value);
    }

    public static DatastoreV1.Value.Builder makeValue(boolean value) {
        return DatastoreV1.Value.newBuilder().setBooleanValue(value);
    }

    public static DatastoreV1.Value.Builder makeValue(String value) {
        return DatastoreV1.Value.newBuilder().setStringValue(value);
    }

    public static DatastoreV1.Value.Builder makeValue(DatastoreV1.Entity entity) {
        return DatastoreV1.Value.newBuilder().setEntityValue(entity);
    }

    public static DatastoreV1.Value.Builder makeValue(DatastoreV1.Entity.Builder entity) {
        return DatastoreHelper.makeValue(entity.build());
    }

    public static DatastoreV1.Value.Builder makeValue(ByteString blob) {
        return DatastoreV1.Value.newBuilder().setBlobValue(blob);
    }

    public static DatastoreV1.Value.Builder makeValue(Date date) {
        return DatastoreV1.Value.newBuilder().setTimestampMicrosecondsValue(date.getTime() * 1000L);
    }

    public static DatastoreV1.Key.Builder makeKey(Object ... elements) {
        DatastoreV1.Key.Builder key = DatastoreV1.Key.newBuilder();
        for (int pathIndex = 0; pathIndex < elements.length; pathIndex += 2) {
            String kind;
            DatastoreV1.Key.PathElement.Builder pathElement = DatastoreV1.Key.PathElement.newBuilder();
            Object element = elements[pathIndex];
            if (element instanceof DatastoreV1.Key) {
                key.addAllPathElement(((DatastoreV1.Key)element).getPathElementList());
                --pathIndex;
                continue;
            }
            try {
                kind = (String)element;
            }
            catch (ClassCastException e) {
                String string = String.valueOf(element.getClass());
                throw new IllegalArgumentException(new StringBuilder(29 + String.valueOf(string).length()).append("Expected string or Key, got: ").append(string).toString());
            }
            pathElement.setKind(kind);
            if (pathIndex + 1 < elements.length) {
                Object value = elements[pathIndex + 1];
                if (value instanceof String) {
                    pathElement.setName((String)value);
                } else if (value instanceof Long) {
                    pathElement.setId((Long)value);
                } else if (value instanceof Integer) {
                    pathElement.setId(((Integer)value).intValue());
                } else if (value instanceof Short) {
                    pathElement.setId(((Short)value).shortValue());
                } else {
                    String string = String.valueOf(value.getClass());
                    throw new IllegalArgumentException(new StringBuilder(33 + String.valueOf(string).length()).append("Expected string or integer, got: ").append(string).toString());
                }
            }
            key.addPathElement(pathElement);
        }
        return key;
    }

    public static Map<String, DatastoreV1.Value> getPropertyMap(DatastoreV1.EntityOrBuilder entity) {
        HashMap<String, DatastoreV1.Value> result = new HashMap<String, DatastoreV1.Value>();
        for (DatastoreV1.PropertyOrBuilder propertyOrBuilder : entity.getPropertyList()) {
            result.put(propertyOrBuilder.getName(), propertyOrBuilder.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    public static double getDouble(DatastoreV1.ValueOrBuilder value) {
        if (!value.hasDoubleValue()) {
            throw new IllegalArgumentException("Value does not contain a double.");
        }
        return value.getDoubleValue();
    }

    public static DatastoreV1.Key getKey(DatastoreV1.ValueOrBuilder value) {
        if (!value.hasKeyValue()) {
            throw new IllegalArgumentException("Value does not contain a key.");
        }
        return value.getKeyValue();
    }

    public static ByteString getByteString(DatastoreV1.ValueOrBuilder value) {
        if (value.getMeaning() == 18 && value.hasStringValue()) {
            return value.getStringValueBytes();
        }
        if (value.hasBlobValue()) {
            return value.getBlobValue();
        }
        throw new IllegalArgumentException("Value does not contain a blob.");
    }

    public static String getBlobKey(DatastoreV1.ValueOrBuilder value) {
        if (value.getMeaning() == 18 && value.hasStringValue()) {
            return value.getStringValue();
        }
        if (value.hasBlobKeyValue()) {
            return value.getBlobKeyValue();
        }
        throw new IllegalArgumentException("Value does not contain a blob key.");
    }

    public static DatastoreV1.Entity getEntity(DatastoreV1.ValueOrBuilder value) {
        if (!value.hasEntityValue()) {
            throw new IllegalArgumentException("Value does not contain an Entity.");
        }
        return value.getEntityValue();
    }

    public static String getString(DatastoreV1.ValueOrBuilder value) {
        if (!value.hasStringValue()) {
            throw new IllegalArgumentException("Value does not contain a string.");
        }
        return value.getStringValue();
    }

    public static boolean getBoolean(DatastoreV1.ValueOrBuilder value) {
        if (!value.hasBooleanValue()) {
            throw new IllegalArgumentException("Value does not contain a boolean.");
        }
        return value.getBooleanValue();
    }

    public static long getLong(DatastoreV1.ValueOrBuilder value) {
        if (!value.hasIntegerValue()) {
            throw new IllegalArgumentException("Value does not contain an integer.");
        }
        return value.getIntegerValue();
    }

    public static long getTimestamp(DatastoreV1.ValueOrBuilder value) {
        if (value.getMeaning() == 18 && value.hasIntegerValue()) {
            return value.getIntegerValue();
        }
        if (value.hasTimestampMicrosecondsValue()) {
            return value.getTimestampMicrosecondsValue();
        }
        throw new IllegalArgumentException("Value does not contain a timestamp.");
    }

    public static List<DatastoreV1.Value> getList(DatastoreV1.ValueOrBuilder value) {
        if (value.getListValueCount() == 0) {
            throw new IllegalArgumentException("Value does not contain a list.");
        }
        return value.getListValueList();
    }

    public static Date toDate(DatastoreV1.ValueOrBuilder value) {
        return new Date(DatastoreHelper.getTimestamp(value) / 1000L);
    }

    private static final class KeyComparator
    implements Comparator<DatastoreV1.Key> {
        static final KeyComparator INSTANCE = new KeyComparator();

        private KeyComparator() {
        }

        private int comparePathElement(DatastoreV1.Key.PathElement thisElement, DatastoreV1.Key.PathElement otherElement) {
            int result = thisElement.getKind().compareTo(otherElement.getKind());
            if (result != 0) {
                return result;
            }
            if (thisElement.hasId()) {
                if (!otherElement.hasId()) {
                    return -1;
                }
                return Long.valueOf(thisElement.getId()).compareTo(otherElement.getId());
            }
            if (otherElement.hasId()) {
                return 1;
            }
            return thisElement.getName().compareTo(otherElement.getName());
        }

        @Override
        public int compare(DatastoreV1.Key thisKey, DatastoreV1.Key otherKey) {
            if (!thisKey.getPartitionId().equals(otherKey.getPartitionId())) {
                throw new IllegalArgumentException("Cannot compare keys with different partition ids.");
            }
            Iterator<DatastoreV1.Key.PathElement> thisPath = thisKey.getPathElementList().iterator();
            Iterator<DatastoreV1.Key.PathElement> otherPath = otherKey.getPathElementList().iterator();
            while (thisPath.hasNext()) {
                if (!otherPath.hasNext()) {
                    return 1;
                }
                int result = this.comparePathElement(thisPath.next(), otherPath.next());
                if (result == 0) continue;
                return result;
            }
            return otherPath.hasNext() ? -1 : 0;
        }
    }
}

