/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.datastore.client;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.protobuf.ProtoHttpContent;
import com.google.api.services.datastore.client.DatastoreException;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

class RemoteRpc {
    private static final Logger logger = Logger.getLogger(RemoteRpc.class.getName());
    private final HttpRequestFactory client;
    private final HttpRequestInitializer initializer;
    private final String url;
    private final AtomicInteger rpcCount = new AtomicInteger(0);

    RemoteRpc(HttpRequestFactory client, HttpRequestInitializer initializer, String url) {
        this.client = client;
        this.initializer = initializer;
        this.url = url;
        try {
            this.resolveURL("dummyRpc");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(url).length()).append("Unable to construct RemoteRpc due to unsupported url: <").append(url).append(">").toString(), e);
        }
    }

    public InputStream call(String methodName, MessageLite request) throws DatastoreException {
        String string = String.valueOf(methodName);
        logger.fine(string.length() != 0 ? "remote datastore call ".concat(string) : new String("remote datastore call "));
        long startTime = System.currentTimeMillis();
        try {
            this.rpcCount.incrementAndGet();
            ProtoHttpContent payload = new ProtoHttpContent(request);
            HttpRequest httpRequest = this.client.buildPostRequest(this.resolveURL(methodName), (HttpContent)payload);
            if (this.initializer != null) {
                this.initializer.initialize(httpRequest);
            }
            HttpResponse httpResponse = httpRequest.execute();
            InputStream inputStream = httpResponse.getContent();
            return inputStream;
        }
        catch (HttpResponseException e) {
            throw RemoteRpc.makeException(this.url, methodName, e.getStatusCode(), e.getContent(), e);
        }
        catch (IOException e) {
            throw RemoteRpc.makeException(this.url, methodName, 503, "I/O error", e);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - startTime;
            logger.fine(new StringBuilder(51 + String.valueOf(methodName).length()).append("remote datastore call ").append(methodName).append(" took ").append(elapsedTime).append(" ms").toString());
        }
    }

    void resetRpcCount() {
        this.rpcCount.set(0);
    }

    int getRpcCount() {
        return this.rpcCount.get();
    }

    public String getUrl() {
        return this.url;
    }

    GenericUrl resolveURL(String path) {
        String string = this.url;
        return new GenericUrl(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(path).length()).append(string).append("/").append(path).toString());
    }

    HttpRequestFactory getHttpRequestFactory() {
        return this.client;
    }

    public static DatastoreException makeException(String url, String methodName, int code, String message, Throwable cause) {
        logger.fine(new StringBuilder(40 + String.valueOf(methodName).length() + String.valueOf(url).length() + String.valueOf(message).length()).append("remote datastore call ").append(methodName).append(" against ").append(url).append(" failed: ").append(message).toString());
        return new DatastoreException(methodName, code, message, cause);
    }
}

