/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.CredentialConfiguration;
import com.google.cloud.hadoop.util.CredentialFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class EntriesCredentialConfiguration
extends CredentialConfiguration {
    public static final String BASE_KEY_PREFIX = "google.cloud";
    public static final String ENABLE_SERVICE_ACCOUNTS_SUFFIX = ".auth.service.account.enable";
    public static final String SERVICE_ACCOUNT_EMAIL_SUFFIX = ".auth.service.account.email";
    public static final String SERVICE_ACCOUNT_KEYFILE_SUFFIX = ".auth.service.account.keyfile";
    public static final String JSON_KEYFILE_SUFFIX = ".auth.service.account.json.keyfile";
    public static final String CLIENT_ID_SUFFIX = ".auth.client.id";
    public static final String CLIENT_SECRET_SUFFIX = ".auth.client.secret";
    public static final String OAUTH_CLIENT_FILE_SUFFIX = ".auth.client.file";
    public static final String ENABLE_NULL_CREDENTIAL_SUFFIX = ".auth.null.enable";
    private final List<String> prefixes;

    public static EntriesBuilder newEntriesBuilder() {
        return new EntriesBuilder();
    }

    private static Optional<Boolean> maybeGetBoolean(Entries config, String key) {
        String value = config.get(key);
        if (value == null) {
            return Optional.absent();
        }
        return Optional.of((Object)Boolean.valueOf(value));
    }

    public EntriesCredentialConfiguration(List<String> prefixes) {
        this.prefixes = ImmutableList.copyOf(prefixes);
    }

    public void getConfigurationInto(Entries configuration) {
        for (String prefix : this.prefixes) {
            String string = String.valueOf(prefix);
            String string2 = String.valueOf(ENABLE_SERVICE_ACCOUNTS_SUFFIX);
            configuration.setBoolean(string2.length() != 0 ? string.concat(string2) : new String(string), this.isServiceAccountEnabled());
            if (this.getServiceAccountEmail() != null) {
                String string3 = String.valueOf(prefix);
                String string4 = String.valueOf(SERVICE_ACCOUNT_EMAIL_SUFFIX);
                configuration.set(string4.length() != 0 ? string3.concat(string4) : new String(string3), this.getServiceAccountEmail());
            }
            if (this.getServiceAccountKeyFile() != null) {
                String string5 = String.valueOf(prefix);
                String string6 = String.valueOf(SERVICE_ACCOUNT_KEYFILE_SUFFIX);
                configuration.set(string6.length() != 0 ? string5.concat(string6) : new String(string5), this.getServiceAccountKeyFile());
            }
            if (this.getServiceAccountJsonKeyFile() != null) {
                String string7 = String.valueOf(prefix);
                String string8 = String.valueOf(JSON_KEYFILE_SUFFIX);
                configuration.set(string8.length() != 0 ? string7.concat(string8) : new String(string7), this.getServiceAccountJsonKeyFile());
            }
            if (this.getClientId() != null) {
                String string9 = String.valueOf(prefix);
                String string10 = String.valueOf(CLIENT_ID_SUFFIX);
                configuration.set(string10.length() != 0 ? string9.concat(string10) : new String(string9), this.getClientId());
            }
            if (this.getClientSecret() != null) {
                String string11 = String.valueOf(prefix);
                String string12 = String.valueOf(CLIENT_SECRET_SUFFIX);
                configuration.set(string12.length() != 0 ? string11.concat(string12) : new String(string11), this.getClientSecret());
            }
            if (this.getOAuthCredentialFile() != null) {
                String string13 = String.valueOf(prefix);
                String string14 = String.valueOf(OAUTH_CLIENT_FILE_SUFFIX);
                configuration.set(string14.length() != 0 ? string13.concat(string14) : new String(string13), this.getOAuthCredentialFile());
            }
            String string15 = String.valueOf(prefix);
            String string16 = String.valueOf(ENABLE_NULL_CREDENTIAL_SUFFIX);
            configuration.setBoolean(string16.length() != 0 ? string15.concat(string16) : new String(string15), this.isNullCredentialEnabled());
        }
    }

    public void setConfiguration(Entries entries) {
        for (String prefix : this.prefixes) {
            String string = String.valueOf(prefix);
            String string2 = String.valueOf(ENABLE_SERVICE_ACCOUNTS_SUFFIX);
            Optional<Boolean> enableServiceAccounts = EntriesCredentialConfiguration.maybeGetBoolean(entries, string2.length() != 0 ? string.concat(string2) : new String(string));
            if (enableServiceAccounts.isPresent()) {
                this.setEnableServiceAccounts((Boolean)enableServiceAccounts.get());
            }
            String string3 = String.valueOf(prefix);
            String string4 = String.valueOf(SERVICE_ACCOUNT_EMAIL_SUFFIX);
            String serviceEmailAccount = entries.get(string4.length() != 0 ? string3.concat(string4) : new String(string3));
            if (serviceEmailAccount != null) {
                this.setServiceAccountEmail(serviceEmailAccount);
            }
            String string5 = String.valueOf(prefix);
            String string6 = String.valueOf(SERVICE_ACCOUNT_KEYFILE_SUFFIX);
            String serviceAccountKeyFile = entries.get(string6.length() != 0 ? string5.concat(string6) : new String(string5));
            if (serviceAccountKeyFile != null) {
                this.setServiceAccountKeyFile(serviceAccountKeyFile);
            }
            String string7 = String.valueOf(prefix);
            String string8 = String.valueOf(JSON_KEYFILE_SUFFIX);
            String serviceAccountJsonKeyFile = entries.get(string8.length() != 0 ? string7.concat(string8) : new String(string7));
            if (serviceAccountJsonKeyFile != null) {
                this.setServiceAccountJsonKeyFile(serviceAccountJsonKeyFile);
            }
            String string9 = String.valueOf(prefix);
            String string10 = String.valueOf(CLIENT_ID_SUFFIX);
            String clientId = entries.get(string10.length() != 0 ? string9.concat(string10) : new String(string9));
            if (clientId != null) {
                this.setClientId(clientId);
            }
            String string11 = String.valueOf(prefix);
            String string12 = String.valueOf(CLIENT_SECRET_SUFFIX);
            String clientSecret = entries.get(string12.length() != 0 ? string11.concat(string12) : new String(string11));
            if (clientSecret != null) {
                this.setClientSecret(clientSecret);
            }
            String string13 = String.valueOf(prefix);
            String string14 = String.valueOf(OAUTH_CLIENT_FILE_SUFFIX);
            String oAuthCredentialPath = entries.get(string14.length() != 0 ? string13.concat(string14) : new String(string13));
            if (oAuthCredentialPath != null) {
                this.setOAuthCredentialFile(oAuthCredentialPath);
            }
            String string15 = String.valueOf(prefix);
            String string16 = String.valueOf(ENABLE_NULL_CREDENTIAL_SUFFIX);
            Optional<Boolean> enableNullCredential = EntriesCredentialConfiguration.maybeGetBoolean(entries, string16.length() != 0 ? string15.concat(string16) : new String(string15));
            if (!enableNullCredential.isPresent()) continue;
            this.setNullCredentialEnabled((Boolean)enableNullCredential.get());
        }
    }

    public static class EntriesBuilder
    extends Builder<EntriesBuilder, EntriesCredentialConfiguration> {
        @Override
        public EntriesBuilder self() {
            return this;
        }

        @Override
        protected EntriesCredentialConfiguration beginBuild() {
            return new EntriesCredentialConfiguration(this.prefixes);
        }
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends EntriesCredentialConfiguration> {
        protected List<String> prefixes = new ArrayList<String>();
        private Entries configuration;
        private CredentialFactory credentialFactory = new CredentialFactory();

        public Builder() {
            this.prefixes.add(EntriesCredentialConfiguration.BASE_KEY_PREFIX);
        }

        protected abstract B self();

        protected abstract T beginBuild();

        public T build() {
            T concreteCredentialConfiguration = this.beginBuild();
            if (this.configuration != null) {
                ((EntriesCredentialConfiguration)concreteCredentialConfiguration).setConfiguration(this.configuration);
            }
            if (this.credentialFactory != null) {
                ((CredentialConfiguration)concreteCredentialConfiguration).setCredentialFactory(this.credentialFactory);
            }
            return concreteCredentialConfiguration;
        }

        @VisibleForTesting
        B withCredentialFactory(CredentialFactory credentialFactory) {
            this.credentialFactory = credentialFactory;
            return this.self();
        }

        public B withConfiguration(Entries configuration) {
            this.configuration = configuration;
            return this.self();
        }

        public B withOverridePrefix(String prefix) {
            this.prefixes.add(prefix);
            return this.self();
        }
    }

    public static interface Entries {
        public String get(String var1);

        public void set(String var1, String var2);

        public void setBoolean(String var1, boolean var2);
    }
}

