/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPropertyOrDefault(Class<?> referenceClass, String propertyFile, String key, String defaultValue) {
        try (InputStream stream = referenceClass.getResourceAsStream(propertyFile);){
            if (stream == null) {
                LOG.error("Could not load properties file '{}'", (Object)propertyFile);
                String string = defaultValue;
                return string;
            }
            Properties properties = new Properties();
            properties.load(stream);
            String value = properties.getProperty(key);
            if (value == null) {
                LOG.error("Key {} not found in properties file {}.", (Object)key, (Object)propertyFile);
                String string = defaultValue;
                return string;
            }
            String string = value;
            return string;
        }
        catch (IOException e) {
            LOG.error(String.format("Error while trying to get property value for key %s", key), (Throwable)e);
            return defaultValue;
        }
    }
}

