/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import java.io.IOException;

public abstract class RetryDeterminer<X extends Exception> {
    public static final RetryDeterminer<Exception> DEFAULT = new RetryDeterminer<Exception>(){

        @Override
        public boolean shouldRetry(Exception e) {
            if (e instanceof IOException) {
                return SOCKET_ERRORS.shouldRetry((IOException)e) || SERVER_ERRORS.shouldRetry((IOException)e);
            }
            return false;
        }
    };
    public static final RetryDeterminer<IOException> SOCKET_ERRORS = RetryDeterminer.createSocketErrorRetryDeterminer(new ApiErrorExtractor());
    public static final RetryDeterminer<IOException> SERVER_ERRORS = new RetryDeterminer<IOException>(){

        @Override
        public boolean shouldRetry(IOException e) {
            if (e instanceof HttpResponseException) {
                HttpResponseException httpException = (HttpResponseException)e;
                return httpException.getStatusCode() / 100 == 5;
            }
            return false;
        }
    };
    public static final RetryDeterminer<IOException> RATE_LIMIT_ERRORS = RetryDeterminer.createRateLimitedRetryDeterminer(new ApiErrorExtractor());

    public abstract boolean shouldRetry(X var1);

    public static RetryDeterminer<IOException> createRateLimitedRetryDeterminer(final ApiErrorExtractor errorExtractor) {
        return new RetryDeterminer<IOException>(){

            @Override
            public boolean shouldRetry(IOException e) {
                return errorExtractor.rateLimited(e);
            }
        };
    }

    private static RetryDeterminer<IOException> createSocketErrorRetryDeterminer(final ApiErrorExtractor errorExtractor) {
        return new RetryDeterminer<IOException>(){

            @Override
            public boolean shouldRetry(IOException e) {
                return errorExtractor.socketError(e);
            }
        };
    }
}

