/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.admin.v2.AppProfile;
import com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.admin.v2.CreateAppProfileRequest;
import com.google.bigtable.admin.v2.CreateClusterMetadata;
import com.google.bigtable.admin.v2.CreateClusterRequest;
import com.google.bigtable.admin.v2.CreateInstanceMetadata;
import com.google.bigtable.admin.v2.CreateInstanceRequest;
import com.google.bigtable.admin.v2.DeleteAppProfileRequest;
import com.google.bigtable.admin.v2.DeleteClusterRequest;
import com.google.bigtable.admin.v2.DeleteInstanceRequest;
import com.google.bigtable.admin.v2.GetAppProfileRequest;
import com.google.bigtable.admin.v2.GetClusterRequest;
import com.google.bigtable.admin.v2.GetInstanceRequest;
import com.google.bigtable.admin.v2.Instance;
import com.google.bigtable.admin.v2.ListAppProfilesRequest;
import com.google.bigtable.admin.v2.ListAppProfilesResponse;
import com.google.bigtable.admin.v2.ListClustersRequest;
import com.google.bigtable.admin.v2.ListClustersResponse;
import com.google.bigtable.admin.v2.ListInstancesRequest;
import com.google.bigtable.admin.v2.ListInstancesResponse;
import com.google.bigtable.admin.v2.PartialUpdateInstanceRequest;
import com.google.bigtable.admin.v2.UpdateAppProfileMetadata;
import com.google.bigtable.admin.v2.UpdateAppProfileRequest;
import com.google.bigtable.admin.v2.UpdateClusterMetadata;
import com.google.bigtable.admin.v2.UpdateInstanceMetadata;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.stub.BigtableInstanceAdminStub;
import com.google.cloud.bigtable.admin.v2.stub.GrpcBigtableInstanceAdminStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class BigtableInstanceAdminStubSettings
extends StubSettings<BigtableInstanceAdminStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/bigtable.admin").add((Object)"https://www.googleapis.com/auth/bigtable.admin.cluster").add((Object)"https://www.googleapis.com/auth/bigtable.admin.instance").add((Object)"https://www.googleapis.com/auth/bigtable.admin.table").add((Object)"https://www.googleapis.com/auth/cloud-bigtable.admin").add((Object)"https://www.googleapis.com/auth/cloud-bigtable.admin.cluster").add((Object)"https://www.googleapis.com/auth/cloud-bigtable.admin.table").add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings;
    private final OperationCallSettings<CreateInstanceRequest, Instance, CreateInstanceMetadata> createInstanceOperationSettings;
    private final UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings;
    private final UnaryCallSettings<ListInstancesRequest, ListInstancesResponse> listInstancesSettings;
    private final UnaryCallSettings<PartialUpdateInstanceRequest, Operation> partialUpdateInstanceSettings;
    private final OperationCallSettings<PartialUpdateInstanceRequest, Instance, UpdateInstanceMetadata> partialUpdateInstanceOperationSettings;
    private final UnaryCallSettings<DeleteInstanceRequest, Empty> deleteInstanceSettings;
    private final UnaryCallSettings<CreateClusterRequest, Operation> createClusterSettings;
    private final OperationCallSettings<CreateClusterRequest, Cluster, CreateClusterMetadata> createClusterOperationSettings;
    private final UnaryCallSettings<GetClusterRequest, Cluster> getClusterSettings;
    private final UnaryCallSettings<ListClustersRequest, ListClustersResponse> listClustersSettings;
    private final UnaryCallSettings<Cluster, Operation> updateClusterSettings;
    private final OperationCallSettings<Cluster, Cluster, UpdateClusterMetadata> updateClusterOperationSettings;
    private final UnaryCallSettings<DeleteClusterRequest, Empty> deleteClusterSettings;
    private final UnaryCallSettings<CreateAppProfileRequest, AppProfile> createAppProfileSettings;
    private final UnaryCallSettings<GetAppProfileRequest, AppProfile> getAppProfileSettings;
    private final PagedCallSettings<ListAppProfilesRequest, ListAppProfilesResponse, BigtableInstanceAdminClient.ListAppProfilesPagedResponse> listAppProfilesSettings;
    private final UnaryCallSettings<UpdateAppProfileRequest, Operation> updateAppProfileSettings;
    private final OperationCallSettings<UpdateAppProfileRequest, AppProfile, UpdateAppProfileMetadata> updateAppProfileOperationSettings;
    private final UnaryCallSettings<DeleteAppProfileRequest, Empty> deleteAppProfileSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListAppProfilesRequest, ListAppProfilesResponse, AppProfile> LIST_APP_PROFILES_PAGE_STR_DESC = new PagedListDescriptor<ListAppProfilesRequest, ListAppProfilesResponse, AppProfile>(){

        public String emptyToken() {
            return "";
        }

        public ListAppProfilesRequest injectToken(ListAppProfilesRequest payload, String token) {
            return ListAppProfilesRequest.newBuilder((ListAppProfilesRequest)payload).setPageToken(token).build();
        }

        public ListAppProfilesRequest injectPageSize(ListAppProfilesRequest payload, int pageSize) {
            throw new UnsupportedOperationException("page size is not supported by this API method");
        }

        public Integer extractPageSize(ListAppProfilesRequest payload) {
            throw new UnsupportedOperationException("page size is not supported by this API method");
        }

        public String extractNextToken(ListAppProfilesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AppProfile> extractResources(ListAppProfilesResponse payload) {
            return payload.getAppProfilesList();
        }
    };
    private static final PagedListResponseFactory<ListAppProfilesRequest, ListAppProfilesResponse, BigtableInstanceAdminClient.ListAppProfilesPagedResponse> LIST_APP_PROFILES_PAGE_STR_FACT = new PagedListResponseFactory<ListAppProfilesRequest, ListAppProfilesResponse, BigtableInstanceAdminClient.ListAppProfilesPagedResponse>(){

        public ApiFuture<BigtableInstanceAdminClient.ListAppProfilesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAppProfilesRequest, ListAppProfilesResponse> callable, ListAppProfilesRequest request, ApiCallContext context, ApiFuture<ListAppProfilesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_APP_PROFILES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BigtableInstanceAdminClient.ListAppProfilesPagedResponse.createAsync((PageContext<ListAppProfilesRequest, ListAppProfilesResponse, AppProfile>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings() {
        return this.createInstanceSettings;
    }

    public OperationCallSettings<CreateInstanceRequest, Instance, CreateInstanceMetadata> createInstanceOperationSettings() {
        return this.createInstanceOperationSettings;
    }

    public UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings() {
        return this.getInstanceSettings;
    }

    public UnaryCallSettings<ListInstancesRequest, ListInstancesResponse> listInstancesSettings() {
        return this.listInstancesSettings;
    }

    public UnaryCallSettings<PartialUpdateInstanceRequest, Operation> partialUpdateInstanceSettings() {
        return this.partialUpdateInstanceSettings;
    }

    public OperationCallSettings<PartialUpdateInstanceRequest, Instance, UpdateInstanceMetadata> partialUpdateInstanceOperationSettings() {
        return this.partialUpdateInstanceOperationSettings;
    }

    public UnaryCallSettings<DeleteInstanceRequest, Empty> deleteInstanceSettings() {
        return this.deleteInstanceSettings;
    }

    public UnaryCallSettings<CreateClusterRequest, Operation> createClusterSettings() {
        return this.createClusterSettings;
    }

    public OperationCallSettings<CreateClusterRequest, Cluster, CreateClusterMetadata> createClusterOperationSettings() {
        return this.createClusterOperationSettings;
    }

    public UnaryCallSettings<GetClusterRequest, Cluster> getClusterSettings() {
        return this.getClusterSettings;
    }

    public UnaryCallSettings<ListClustersRequest, ListClustersResponse> listClustersSettings() {
        return this.listClustersSettings;
    }

    public UnaryCallSettings<Cluster, Operation> updateClusterSettings() {
        return this.updateClusterSettings;
    }

    public OperationCallSettings<Cluster, Cluster, UpdateClusterMetadata> updateClusterOperationSettings() {
        return this.updateClusterOperationSettings;
    }

    public UnaryCallSettings<DeleteClusterRequest, Empty> deleteClusterSettings() {
        return this.deleteClusterSettings;
    }

    public UnaryCallSettings<CreateAppProfileRequest, AppProfile> createAppProfileSettings() {
        return this.createAppProfileSettings;
    }

    public UnaryCallSettings<GetAppProfileRequest, AppProfile> getAppProfileSettings() {
        return this.getAppProfileSettings;
    }

    public PagedCallSettings<ListAppProfilesRequest, ListAppProfilesResponse, BigtableInstanceAdminClient.ListAppProfilesPagedResponse> listAppProfilesSettings() {
        return this.listAppProfilesSettings;
    }

    public UnaryCallSettings<UpdateAppProfileRequest, Operation> updateAppProfileSettings() {
        return this.updateAppProfileSettings;
    }

    public OperationCallSettings<UpdateAppProfileRequest, AppProfile, UpdateAppProfileMetadata> updateAppProfileOperationSettings() {
        return this.updateAppProfileOperationSettings;
    }

    public UnaryCallSettings<DeleteAppProfileRequest, Empty> deleteAppProfileSettings() {
        return this.deleteAppProfileSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BigtableInstanceAdminStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBigtableInstanceAdminStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "bigtableadmin.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BigtableInstanceAdminStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BigtableInstanceAdminStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BigtableInstanceAdminStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createInstanceSettings = settingsBuilder.createInstanceSettings().build();
        this.createInstanceOperationSettings = settingsBuilder.createInstanceOperationSettings().build();
        this.getInstanceSettings = settingsBuilder.getInstanceSettings().build();
        this.listInstancesSettings = settingsBuilder.listInstancesSettings().build();
        this.partialUpdateInstanceSettings = settingsBuilder.partialUpdateInstanceSettings().build();
        this.partialUpdateInstanceOperationSettings = settingsBuilder.partialUpdateInstanceOperationSettings().build();
        this.deleteInstanceSettings = settingsBuilder.deleteInstanceSettings().build();
        this.createClusterSettings = settingsBuilder.createClusterSettings().build();
        this.createClusterOperationSettings = settingsBuilder.createClusterOperationSettings().build();
        this.getClusterSettings = settingsBuilder.getClusterSettings().build();
        this.listClustersSettings = settingsBuilder.listClustersSettings().build();
        this.updateClusterSettings = settingsBuilder.updateClusterSettings().build();
        this.updateClusterOperationSettings = settingsBuilder.updateClusterOperationSettings().build();
        this.deleteClusterSettings = settingsBuilder.deleteClusterSettings().build();
        this.createAppProfileSettings = settingsBuilder.createAppProfileSettings().build();
        this.getAppProfileSettings = settingsBuilder.getAppProfileSettings().build();
        this.listAppProfilesSettings = settingsBuilder.listAppProfilesSettings().build();
        this.updateAppProfileSettings = settingsBuilder.updateAppProfileSettings().build();
        this.updateAppProfileOperationSettings = settingsBuilder.updateAppProfileOperationSettings().build();
        this.deleteAppProfileSettings = settingsBuilder.deleteAppProfileSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BigtableInstanceAdminStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings;
        private final OperationCallSettings.Builder<CreateInstanceRequest, Instance, CreateInstanceMetadata> createInstanceOperationSettings;
        private final UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings;
        private final UnaryCallSettings.Builder<ListInstancesRequest, ListInstancesResponse> listInstancesSettings;
        private final UnaryCallSettings.Builder<PartialUpdateInstanceRequest, Operation> partialUpdateInstanceSettings;
        private final OperationCallSettings.Builder<PartialUpdateInstanceRequest, Instance, UpdateInstanceMetadata> partialUpdateInstanceOperationSettings;
        private final UnaryCallSettings.Builder<DeleteInstanceRequest, Empty> deleteInstanceSettings;
        private final UnaryCallSettings.Builder<CreateClusterRequest, Operation> createClusterSettings;
        private final OperationCallSettings.Builder<CreateClusterRequest, Cluster, CreateClusterMetadata> createClusterOperationSettings;
        private final UnaryCallSettings.Builder<GetClusterRequest, Cluster> getClusterSettings;
        private final UnaryCallSettings.Builder<ListClustersRequest, ListClustersResponse> listClustersSettings;
        private final UnaryCallSettings.Builder<Cluster, Operation> updateClusterSettings;
        private final OperationCallSettings.Builder<Cluster, Cluster, UpdateClusterMetadata> updateClusterOperationSettings;
        private final UnaryCallSettings.Builder<DeleteClusterRequest, Empty> deleteClusterSettings;
        private final UnaryCallSettings.Builder<CreateAppProfileRequest, AppProfile> createAppProfileSettings;
        private final UnaryCallSettings.Builder<GetAppProfileRequest, AppProfile> getAppProfileSettings;
        private final PagedCallSettings.Builder<ListAppProfilesRequest, ListAppProfilesResponse, BigtableInstanceAdminClient.ListAppProfilesPagedResponse> listAppProfilesSettings;
        private final UnaryCallSettings.Builder<UpdateAppProfileRequest, Operation> updateAppProfileSettings;
        private final OperationCallSettings.Builder<UpdateAppProfileRequest, AppProfile, UpdateAppProfileMetadata> updateAppProfileOperationSettings;
        private final UnaryCallSettings.Builder<DeleteAppProfileRequest, Empty> deleteAppProfileSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.getInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.partialUpdateInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.partialUpdateInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.deleteInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClusterOperationSettings = OperationCallSettings.newBuilder();
            this.getClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listClustersSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateClusterOperationSettings = OperationCallSettings.newBuilder();
            this.deleteClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAppProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAppProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAppProfilesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_APP_PROFILES_PAGE_STR_FACT);
            this.updateAppProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAppProfileOperationSettings = OperationCallSettings.newBuilder();
            this.deleteAppProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createInstanceSettings, this.getInstanceSettings, this.listInstancesSettings, this.partialUpdateInstanceSettings, this.deleteInstanceSettings, this.createClusterSettings, this.getClusterSettings, this.listClustersSettings, this.updateClusterSettings, this.deleteClusterSettings, this.createAppProfileSettings, this.getAppProfileSettings, (Object[])new UnaryCallSettings.Builder[]{this.listAppProfilesSettings, this.updateAppProfileSettings, this.deleteAppProfileSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BigtableInstanceAdminStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BigtableInstanceAdminStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BigtableInstanceAdminStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(BigtableInstanceAdminStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.partialUpdateInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listClustersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createAppProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getAppProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listAppProfilesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateAppProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteAppProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateInstanceMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.partialUpdateInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateInstanceMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateClusterMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateClusterMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateAppProfileOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AppProfile.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateAppProfileMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        protected Builder(BigtableInstanceAdminStubSettings settings) {
            super((StubSettings)settings);
            this.createInstanceSettings = settings.createInstanceSettings.toBuilder();
            this.createInstanceOperationSettings = settings.createInstanceOperationSettings.toBuilder();
            this.getInstanceSettings = settings.getInstanceSettings.toBuilder();
            this.listInstancesSettings = settings.listInstancesSettings.toBuilder();
            this.partialUpdateInstanceSettings = settings.partialUpdateInstanceSettings.toBuilder();
            this.partialUpdateInstanceOperationSettings = settings.partialUpdateInstanceOperationSettings.toBuilder();
            this.deleteInstanceSettings = settings.deleteInstanceSettings.toBuilder();
            this.createClusterSettings = settings.createClusterSettings.toBuilder();
            this.createClusterOperationSettings = settings.createClusterOperationSettings.toBuilder();
            this.getClusterSettings = settings.getClusterSettings.toBuilder();
            this.listClustersSettings = settings.listClustersSettings.toBuilder();
            this.updateClusterSettings = settings.updateClusterSettings.toBuilder();
            this.updateClusterOperationSettings = settings.updateClusterOperationSettings.toBuilder();
            this.deleteClusterSettings = settings.deleteClusterSettings.toBuilder();
            this.createAppProfileSettings = settings.createAppProfileSettings.toBuilder();
            this.getAppProfileSettings = settings.getAppProfileSettings.toBuilder();
            this.listAppProfilesSettings = settings.listAppProfilesSettings.toBuilder();
            this.updateAppProfileSettings = settings.updateAppProfileSettings.toBuilder();
            this.updateAppProfileOperationSettings = settings.updateAppProfileOperationSettings.toBuilder();
            this.deleteAppProfileSettings = settings.deleteAppProfileSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createInstanceSettings, this.getInstanceSettings, this.listInstancesSettings, this.partialUpdateInstanceSettings, this.deleteInstanceSettings, this.createClusterSettings, this.getClusterSettings, this.listClustersSettings, this.updateClusterSettings, this.deleteClusterSettings, this.createAppProfileSettings, this.getAppProfileSettings, (Object[])new UnaryCallSettings.Builder[]{this.listAppProfilesSettings, this.updateAppProfileSettings, this.deleteAppProfileSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings});
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings() {
            return this.createInstanceSettings;
        }

        public OperationCallSettings.Builder<CreateInstanceRequest, Instance, CreateInstanceMetadata> createInstanceOperationSettings() {
            return this.createInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings() {
            return this.getInstanceSettings;
        }

        public UnaryCallSettings.Builder<ListInstancesRequest, ListInstancesResponse> listInstancesSettings() {
            return this.listInstancesSettings;
        }

        public UnaryCallSettings.Builder<PartialUpdateInstanceRequest, Operation> partialUpdateInstanceSettings() {
            return this.partialUpdateInstanceSettings;
        }

        public OperationCallSettings.Builder<PartialUpdateInstanceRequest, Instance, UpdateInstanceMetadata> partialUpdateInstanceOperationSettings() {
            return this.partialUpdateInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstanceRequest, Empty> deleteInstanceSettings() {
            return this.deleteInstanceSettings;
        }

        public UnaryCallSettings.Builder<CreateClusterRequest, Operation> createClusterSettings() {
            return this.createClusterSettings;
        }

        public OperationCallSettings.Builder<CreateClusterRequest, Cluster, CreateClusterMetadata> createClusterOperationSettings() {
            return this.createClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<GetClusterRequest, Cluster> getClusterSettings() {
            return this.getClusterSettings;
        }

        public UnaryCallSettings.Builder<ListClustersRequest, ListClustersResponse> listClustersSettings() {
            return this.listClustersSettings;
        }

        public UnaryCallSettings.Builder<Cluster, Operation> updateClusterSettings() {
            return this.updateClusterSettings;
        }

        public OperationCallSettings.Builder<Cluster, Cluster, UpdateClusterMetadata> updateClusterOperationSettings() {
            return this.updateClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteClusterRequest, Empty> deleteClusterSettings() {
            return this.deleteClusterSettings;
        }

        public UnaryCallSettings.Builder<CreateAppProfileRequest, AppProfile> createAppProfileSettings() {
            return this.createAppProfileSettings;
        }

        public UnaryCallSettings.Builder<GetAppProfileRequest, AppProfile> getAppProfileSettings() {
            return this.getAppProfileSettings;
        }

        public PagedCallSettings.Builder<ListAppProfilesRequest, ListAppProfilesResponse, BigtableInstanceAdminClient.ListAppProfilesPagedResponse> listAppProfilesSettings() {
            return this.listAppProfilesSettings;
        }

        public UnaryCallSettings.Builder<UpdateAppProfileRequest, Operation> updateAppProfileSettings() {
            return this.updateAppProfileSettings;
        }

        public OperationCallSettings.Builder<UpdateAppProfileRequest, AppProfile, UpdateAppProfileMetadata> updateAppProfileOperationSettings() {
            return this.updateAppProfileOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteAppProfileRequest, Empty> deleteAppProfileSettings() {
            return this.deleteAppProfileSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public BigtableInstanceAdminStubSettings build() throws IOException {
            return new BigtableInstanceAdminStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

