/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.v2.ReadModifyWriteRule;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.RowFilter;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.bigtable.v2.TableName;
import com.google.cloud.bigtable.data.v2.BaseBigtableDataSettings;
import com.google.cloud.bigtable.data.v2.stub.BigtableStub;
import com.google.cloud.bigtable.data.v2.stub.BigtableStubSettings;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class BaseBigtableDataClient
implements BackgroundResource {
    private final BaseBigtableDataSettings settings;
    private final BigtableStub stub;

    public static final BaseBigtableDataClient create() throws IOException {
        return BaseBigtableDataClient.create(BaseBigtableDataSettings.newBuilder().build());
    }

    public static final BaseBigtableDataClient create(BaseBigtableDataSettings settings) throws IOException {
        return new BaseBigtableDataClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BaseBigtableDataClient create(BigtableStub stub) {
        return new BaseBigtableDataClient(stub);
    }

    protected BaseBigtableDataClient(BaseBigtableDataSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BigtableStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BaseBigtableDataClient(BigtableStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BaseBigtableDataSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BigtableStub getStub() {
        return this.stub;
    }

    public final ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable() {
        return this.stub.readRowsCallable();
    }

    public final ServerStreamingCallable<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysCallable() {
        return this.stub.sampleRowKeysCallable();
    }

    public final MutateRowResponse mutateRow(TableName tableName, ByteString rowKey, List<Mutation> mutations) {
        MutateRowRequest request = MutateRowRequest.newBuilder().setTableName(tableName == null ? null : tableName.toString()).setRowKey(rowKey).addAllMutations(mutations).build();
        return this.mutateRow(request);
    }

    public final MutateRowResponse mutateRow(String tableName, ByteString rowKey, List<Mutation> mutations) {
        MutateRowRequest request = MutateRowRequest.newBuilder().setTableName(tableName).setRowKey(rowKey).addAllMutations(mutations).build();
        return this.mutateRow(request);
    }

    public final MutateRowResponse mutateRow(MutateRowRequest request) {
        return (MutateRowResponse)this.mutateRowCallable().call((Object)request);
    }

    public final UnaryCallable<MutateRowRequest, MutateRowResponse> mutateRowCallable() {
        return this.stub.mutateRowCallable();
    }

    public final ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> mutateRowsCallable() {
        return this.stub.mutateRowsCallable();
    }

    public final CheckAndMutateRowResponse checkAndMutateRow(TableName tableName, ByteString rowKey, RowFilter predicateFilter, List<Mutation> trueMutations, List<Mutation> falseMutations) {
        CheckAndMutateRowRequest request = CheckAndMutateRowRequest.newBuilder().setTableName(tableName == null ? null : tableName.toString()).setRowKey(rowKey).setPredicateFilter(predicateFilter).addAllTrueMutations(trueMutations).addAllFalseMutations(falseMutations).build();
        return this.checkAndMutateRow(request);
    }

    public final CheckAndMutateRowResponse checkAndMutateRow(String tableName, ByteString rowKey, RowFilter predicateFilter, List<Mutation> trueMutations, List<Mutation> falseMutations) {
        CheckAndMutateRowRequest request = CheckAndMutateRowRequest.newBuilder().setTableName(tableName).setRowKey(rowKey).setPredicateFilter(predicateFilter).addAllTrueMutations(trueMutations).addAllFalseMutations(falseMutations).build();
        return this.checkAndMutateRow(request);
    }

    public final CheckAndMutateRowResponse checkAndMutateRow(CheckAndMutateRowRequest request) {
        return (CheckAndMutateRowResponse)this.checkAndMutateRowCallable().call((Object)request);
    }

    public final UnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRowCallable() {
        return this.stub.checkAndMutateRowCallable();
    }

    public final ReadModifyWriteRowResponse readModifyWriteRow(TableName tableName, ByteString rowKey, List<ReadModifyWriteRule> rules) {
        ReadModifyWriteRowRequest request = ReadModifyWriteRowRequest.newBuilder().setTableName(tableName == null ? null : tableName.toString()).setRowKey(rowKey).addAllRules(rules).build();
        return this.readModifyWriteRow(request);
    }

    public final ReadModifyWriteRowResponse readModifyWriteRow(String tableName, ByteString rowKey, List<ReadModifyWriteRule> rules) {
        ReadModifyWriteRowRequest request = ReadModifyWriteRowRequest.newBuilder().setTableName(tableName).setRowKey(rowKey).addAllRules(rules).build();
        return this.readModifyWriteRow(request);
    }

    public final ReadModifyWriteRowResponse readModifyWriteRow(ReadModifyWriteRowRequest request) {
        return (ReadModifyWriteRowResponse)this.readModifyWriteRowCallable().call((Object)request);
    }

    public final UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readModifyWriteRowCallable() {
        return this.stub.readModifyWriteRowCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

