/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import javax.annotation.Nonnull;

abstract class Range<T, R extends Range<T, R>> {
    private BoundType startBound;
    private T start;
    private BoundType endBound;
    private T end;

    Range() {
        this(BoundType.UNBOUNDED, null, BoundType.UNBOUNDED, null);
    }

    Range(BoundType startBound, T start, BoundType endBound, T end) {
        this.startBound = startBound;
        this.start = start;
        this.endBound = endBound;
        this.end = end;
    }

    public R of(@Nonnull T startClosed, @Nonnull T endOpen) {
        return ((Range)this.startClosed(startClosed)).endOpen(endOpen);
    }

    public R startUnbounded() {
        this.start = null;
        this.startBound = BoundType.UNBOUNDED;
        return this.thisT();
    }

    public R startOpen(@Nonnull T start) {
        this.start = Preconditions.checkNotNull(start, (Object)"Start can't be null");
        this.startBound = BoundType.OPEN;
        return this.thisT();
    }

    public R startClosed(@Nonnull T start) {
        this.start = Preconditions.checkNotNull(start, (Object)"Start can't be null");
        this.startBound = BoundType.CLOSED;
        return this.thisT();
    }

    public R endUnbounded() {
        this.end = null;
        this.endBound = BoundType.UNBOUNDED;
        return this.thisT();
    }

    public R endOpen(@Nonnull T end) {
        this.end = Preconditions.checkNotNull(end, (Object)"End can't be null");
        this.endBound = BoundType.OPEN;
        return this.thisT();
    }

    public R endClosed(@Nonnull T end) {
        this.end = Preconditions.checkNotNull(end, (Object)"End can't be null");
        this.endBound = BoundType.CLOSED;
        return this.thisT();
    }

    public BoundType getStartBound() {
        return this.startBound;
    }

    public T getStart() {
        Preconditions.checkState((this.startBound != BoundType.UNBOUNDED ? 1 : 0) != 0, (Object)"Start is unbounded");
        return this.start;
    }

    public BoundType getEndBound() {
        return this.endBound;
    }

    public T getEnd() {
        Preconditions.checkState((this.endBound != BoundType.UNBOUNDED ? 1 : 0) != 0, (Object)"End is unbounded");
        return this.end;
    }

    private R thisT() {
        return (R)this;
    }

    public static final class ByteStringRange
    extends AbstractByteStringRange<ByteStringRange> {
        public static ByteStringRange unbounded() {
            return new ByteStringRange(BoundType.UNBOUNDED, null, BoundType.UNBOUNDED, null);
        }

        public static ByteStringRange create(ByteString closedStart, ByteString openEnd) {
            return new ByteStringRange(BoundType.CLOSED, closedStart, BoundType.OPEN, openEnd);
        }

        public static ByteStringRange create(String closedStart, String openEnd) {
            return new ByteStringRange(BoundType.CLOSED, ByteStringRange.wrap(closedStart), BoundType.OPEN, ByteStringRange.wrap(openEnd));
        }

        private ByteStringRange(BoundType startBound, ByteString start, BoundType endBound, ByteString end) {
            super(startBound, start, endBound, end);
        }
    }

    public static final class TimestampRange
    extends AbstractTimestampRange<TimestampRange> {
        public static TimestampRange unbounded() {
            return new TimestampRange(BoundType.UNBOUNDED, null, BoundType.UNBOUNDED, null);
        }

        public static TimestampRange create(long closedStart, long openEnd) {
            return new TimestampRange(BoundType.CLOSED, closedStart, BoundType.OPEN, openEnd);
        }

        private TimestampRange(BoundType startBound, Long start, BoundType endBound, Long end) {
            super(startBound, start, endBound, end);
        }
    }

    static abstract class AbstractByteStringRange<R extends AbstractByteStringRange<R>>
    extends Range<ByteString, R>
    implements Cloneable {
        AbstractByteStringRange() {
            this(BoundType.UNBOUNDED, null, BoundType.UNBOUNDED, null);
        }

        AbstractByteStringRange(BoundType startBound, ByteString start, BoundType endBound, ByteString end) {
            super(startBound, start, endBound, end);
        }

        @Override
        public R of(String startClosed, String endOpen) {
            return (R)((AbstractByteStringRange)this.of(AbstractByteStringRange.wrap(startClosed), AbstractByteStringRange.wrap(endOpen)));
        }

        @Override
        public R startOpen(String start) {
            return (R)((AbstractByteStringRange)this.startOpen(AbstractByteStringRange.wrap(start)));
        }

        @Override
        public R startClosed(String start) {
            return (R)((AbstractByteStringRange)this.startClosed(AbstractByteStringRange.wrap(start)));
        }

        @Override
        public R endOpen(String end) {
            return (R)((AbstractByteStringRange)this.endOpen(AbstractByteStringRange.wrap(end)));
        }

        @Override
        public R endClosed(String end) {
            return (R)((AbstractByteStringRange)this.endClosed(AbstractByteStringRange.wrap(end)));
        }

        protected R clone() {
            try {
                return (R)((AbstractByteStringRange)super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("should never happen", e);
            }
        }

        static ByteString wrap(String str) {
            return ByteString.copyFromUtf8((String)str);
        }
    }

    static abstract class AbstractTimestampRange<R extends AbstractTimestampRange<R>>
    extends Range<Long, R>
    implements Cloneable {
        AbstractTimestampRange() {
        }

        AbstractTimestampRange(BoundType startBound, Long start, BoundType endBound, Long end) {
            super(startBound, start, endBound, end);
        }

        protected R clone() {
            try {
                return (R)((AbstractTimestampRange)super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("should never happen", e);
            }
        }
    }

    public static enum BoundType {
        OPEN,
        CLOSED,
        UNBOUNDED;

    }
}

