/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.Callables;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.stub.BigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.GrpcBigtableStub;
import com.google.cloud.bigtable.data.v2.stub.SampleRowKeysCallable;
import java.io.IOException;
import java.util.List;

@InternalApi
public class EnhancedBigtableStub
implements AutoCloseable {
    private final EnhancedBigtableStubSettings settings;
    private final GrpcBigtableStub stub;
    private final ClientContext clientContext;
    private final RequestContext requestContext;
    private final ServerStreamingCallable<Query, Row> readRowsCallable;
    private final UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable;
    private final UnaryCallable<RowMutation, Void> mutateRowCallable;

    public static EnhancedBigtableStub create(EnhancedBigtableStubSettings settings) throws IOException {
        BigtableStubSettings.Builder baseSettingsBuilder = (BigtableStubSettings.Builder)((BigtableStubSettings.Builder)((BigtableStubSettings.Builder)BigtableStubSettings.newBuilder().setTransportChannelProvider(settings.getTransportChannelProvider())).setEndpoint(settings.getEndpoint())).setCredentialsProvider(settings.getCredentialsProvider());
        baseSettingsBuilder.sampleRowKeysSettings().setSimpleTimeoutNoRetries(settings.sampleRowKeysSettings().getRetrySettings().getTotalTimeout()).setRetryableCodes(settings.sampleRowKeysSettings().getRetryableCodes());
        BigtableStubSettings baseSettings = baseSettingsBuilder.build();
        ClientContext clientContext = ClientContext.create((StubSettings)baseSettings);
        GrpcBigtableStub stub = new GrpcBigtableStub(baseSettings, clientContext);
        return new EnhancedBigtableStub(settings, clientContext, stub);
    }

    @InternalApi(value="Visible for testing")
    EnhancedBigtableStub(EnhancedBigtableStubSettings settings, ClientContext clientContext, GrpcBigtableStub stub) {
        this.settings = settings;
        this.clientContext = clientContext;
        this.stub = stub;
        this.requestContext = RequestContext.create(settings.getInstanceName(), settings.getAppProfileId());
        this.readRowsCallable = this.createReadRowsCallable(new DefaultRowAdapter());
        this.sampleRowKeysCallable = this.createSampleRowKeysCallable();
        this.mutateRowCallable = this.createMutateRowCallable();
    }

    public <RowT> ServerStreamingCallable<Query, RowT> createReadRowsCallable(RowAdapter<RowT> rowAdapter) {
        return new ServerStreamingCallable<Query, RowT>(){

            public void call(Query query, ResponseObserver<RowT> responseObserver, ApiCallContext context) {
                throw new UnsupportedOperationException("todo");
            }
        };
    }

    private UnaryCallable<String, List<KeyOffset>> createSampleRowKeysCallable() {
        UnaryCallable spoolable = this.stub.sampleRowKeysCallable().all();
        UnaryCallable retryable = Callables.retrying((UnaryCallable)spoolable, this.settings.sampleRowKeysSettings(), (ClientContext)this.clientContext);
        UnaryCallable withContext = retryable.withDefaultCallContext(this.clientContext.getDefaultCallContext());
        return new SampleRowKeysCallable((UnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>>)withContext, this.requestContext);
    }

    private UnaryCallable<RowMutation, Void> createMutateRowCallable() {
        return new UnaryCallable<RowMutation, Void>(){

            public ApiFuture<Void> futureCall(RowMutation request, ApiCallContext context) {
                throw new UnsupportedOperationException("todo");
            }
        };
    }

    public ServerStreamingCallable<Query, Row> readRowsCallable() {
        return this.readRowsCallable;
    }

    public UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable() {
        return this.sampleRowKeysCallable;
    }

    public UnaryCallable<RowMutation, Void> mutateRowCallable() {
        return this.mutateRowCallable;
    }

    @Override
    public void close() throws Exception {
        this.stub.close();
    }
}

