/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.grpc.ChannelPrimer;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.OpencensusTracerFactory;
import com.google.cloud.bigtable.data.v2.internal.RefreshChannel;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.stub.BigtableBatchingCallSettings;
import com.google.cloud.bigtable.data.v2.stub.BigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsBatchingDescriptor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.threeten.bp.Duration;

public class EnhancedBigtableStubSettings
extends StubSettings<EnhancedBigtableStubSettings> {
    private static final Logger logger = Logger.getLogger(EnhancedBigtableStubSettings.class.getName());
    private static final int MAX_MESSAGE_SIZE = 0x10000000;
    private static final String SERVER_DEFAULT_APP_PROFILE_ID = "";
    private static final String DIRECT_PATH_ENV_VAR = "GOOGLE_CLOUD_ENABLE_DIRECT_PATH";
    private static final String DIRECT_PATH_ENDPOINT = "directpath-bigtable.googleapis.com:443";
    private static final Set<StatusCode.Code> IDEMPOTENT_RETRY_CODES = ImmutableSet.of((Object)StatusCode.Code.DEADLINE_EXCEEDED, (Object)StatusCode.Code.UNAVAILABLE);
    private static final RetrySettings IDEMPOTENT_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)10L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMinutes((long)1L)).setInitialRpcTimeout(Duration.ofSeconds((long)20L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofSeconds((long)20L)).setTotalTimeout(Duration.ofMinutes((long)10L)).build();
    private static final Set<StatusCode.Code> READ_ROWS_RETRY_CODES = ImmutableSet.builder().addAll(IDEMPOTENT_RETRY_CODES).add((Object)StatusCode.Code.ABORTED).build();
    private static final RetrySettings READ_ROWS_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)10L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMinutes((long)1L)).setJittered(true).setInitialRpcTimeout(Duration.ofMinutes((long)5L)).setRpcTimeoutMultiplier(2.0).setMaxRpcTimeout(Duration.ofMinutes((long)5L)).setTotalTimeout(Duration.ofHours((long)12L)).build();
    private static final RetrySettings MUTATE_ROWS_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)10L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMinutes((long)1L)).setInitialRpcTimeout(Duration.ofMinutes((long)1L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMinutes((long)1L)).setTotalTimeout(Duration.ofMinutes((long)10L)).build();
    private static final ImmutableList<String> JWT_ENABLED_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/bigtable.data").add((Object)"https://www.googleapis.com/auth/cloud-bigtable.data").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final String projectId;
    private final String instanceId;
    private final String appProfileId;
    private final boolean isRefreshingChannel;
    private final ServerStreamingCallSettings<Query, Row> readRowsSettings;
    private final UnaryCallSettings<Query, Row> readRowSettings;
    private final UnaryCallSettings<String, List<KeyOffset>> sampleRowKeysSettings;
    private final UnaryCallSettings<RowMutation, Void> mutateRowSettings;
    private final BigtableBatchingCallSettings bulkMutateRowsSettings;
    private final UnaryCallSettings<ConditionalRowMutation, Boolean> checkAndMutateRowSettings;
    private final UnaryCallSettings<ReadModifyWriteRow, Row> readModifyWriteRowSettings;

    private EnhancedBigtableStubSettings(Builder builder) {
        super((StubSettings.Builder)builder);
        if (DIRECT_PATH_ENDPOINT.equals(builder.getEndpoint())) {
            logger.warning("Connecting to Bigtable using DirectPath. This is currently an experimental feature and should not be used in production.");
        }
        Preconditions.checkState((boolean)builder.readRowSettings.getRetryableCodes().equals(builder.readRowsSettings.getRetryableCodes()), (Object)"Single ReadRow retry codes must match ReadRows retry codes");
        this.projectId = builder.projectId;
        this.instanceId = builder.instanceId;
        this.appProfileId = builder.appProfileId;
        this.isRefreshingChannel = builder.isRefreshingChannel;
        this.readRowsSettings = builder.readRowsSettings.build();
        this.readRowSettings = builder.readRowSettings.build();
        this.sampleRowKeysSettings = builder.sampleRowKeysSettings.build();
        this.mutateRowSettings = builder.mutateRowSettings.build();
        this.bulkMutateRowsSettings = builder.bulkMutateRowsSettings.build();
        this.checkAndMutateRowSettings = builder.checkAndMutateRowSettings.build();
        this.readModifyWriteRowSettings = builder.readModifyWriteRowSettings.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getAppProfileId() {
        return this.appProfileId;
    }

    @BetaApi(value="This API depends on experimental gRPC APIs")
    public boolean isRefreshingChannel() {
        return this.isRefreshingChannel;
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return BigtableStubSettings.defaultGrpcTransportProviderBuilder().setChannelsPerCpu(2.0).setMaxInboundMessageSize(Integer.valueOf(0x10000000));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EnhancedBigtableStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return BigtableStubSettings.defaultCredentialsProviderBuilder().setJwtEnabledScopes(JWT_ENABLED_SCOPES);
    }

    public ServerStreamingCallSettings<Query, Row> readRowsSettings() {
        return this.readRowsSettings;
    }

    public UnaryCallSettings<String, List<KeyOffset>> sampleRowKeysSettings() {
        return this.sampleRowKeysSettings;
    }

    public UnaryCallSettings<Query, Row> readRowSettings() {
        return this.readRowSettings;
    }

    public UnaryCallSettings<RowMutation, Void> mutateRowSettings() {
        return this.mutateRowSettings;
    }

    public BigtableBatchingCallSettings bulkMutateRowsSettings() {
        return this.bulkMutateRowsSettings;
    }

    public UnaryCallSettings<ConditionalRowMutation, Boolean> checkAndMutateRowSettings() {
        return this.checkAndMutateRowSettings;
    }

    public UnaryCallSettings<ReadModifyWriteRow, Row> readModifyWriteRowSettings() {
        return this.readModifyWriteRowSettings;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends StubSettings.Builder<EnhancedBigtableStubSettings, Builder> {
        private String projectId;
        private String instanceId;
        private String appProfileId;
        private boolean isRefreshingChannel;
        private final ServerStreamingCallSettings.Builder<Query, Row> readRowsSettings;
        private final UnaryCallSettings.Builder<Query, Row> readRowSettings;
        private final UnaryCallSettings.Builder<String, List<KeyOffset>> sampleRowKeysSettings;
        private final UnaryCallSettings.Builder<RowMutation, Void> mutateRowSettings;
        private final BigtableBatchingCallSettings.Builder bulkMutateRowsSettings;
        private final UnaryCallSettings.Builder<ConditionalRowMutation, Boolean> checkAndMutateRowSettings;
        private final UnaryCallSettings.Builder<ReadModifyWriteRow, Row> readModifyWriteRowSettings;

        private Builder() {
            this.appProfileId = EnhancedBigtableStubSettings.SERVER_DEFAULT_APP_PROFILE_ID;
            this.isRefreshingChannel = false;
            this.setCredentialsProvider((CredentialsProvider)EnhancedBigtableStubSettings.defaultCredentialsProviderBuilder().build());
            BigtableStubSettings.Builder baseDefaults = BigtableStubSettings.newBuilder();
            if (Builder.isDirectPathEnabled()) {
                this.setEndpoint(EnhancedBigtableStubSettings.DIRECT_PATH_ENDPOINT);
            } else {
                this.setEndpoint(baseDefaults.getEndpoint());
            }
            this.setTransportChannelProvider(EnhancedBigtableStubSettings.defaultTransportChannelProvider());
            this.setStreamWatchdogCheckInterval(baseDefaults.getStreamWatchdogCheckInterval());
            this.setStreamWatchdogProvider(baseDefaults.getStreamWatchdogProvider());
            this.setTracerFactory((ApiTracerFactory)new OpencensusTracerFactory((Map)ImmutableMap.of((Object)"gax", (Object)GaxGrpcProperties.getGaxGrpcVersion(), (Object)"grpc", (Object)GaxGrpcProperties.getGrpcVersion(), (Object)"gapic", (Object)GaxProperties.getLibraryVersion(EnhancedBigtableStubSettings.class))));
            this.readRowsSettings = ServerStreamingCallSettings.newBuilder();
            this.readRowsSettings.setRetryableCodes(READ_ROWS_RETRY_CODES).setRetrySettings(READ_ROWS_RETRY_SETTINGS).setIdleTimeout(Duration.ofMinutes((long)5L));
            this.readRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.readRowSettings.setRetryableCodes(this.readRowsSettings.getRetryableCodes()).setRetrySettings(baseDefaults.readRowsSettings().getRetrySettings().toBuilder().setTotalTimeout(IDEMPOTENT_RETRY_SETTINGS.getTotalTimeout()).build());
            this.sampleRowKeysSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.sampleRowKeysSettings.setRetryableCodes(IDEMPOTENT_RETRY_CODES).setRetrySettings(IDEMPOTENT_RETRY_SETTINGS);
            this.mutateRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            Builder.copyRetrySettings(baseDefaults.mutateRowSettings(), this.mutateRowSettings);
            this.bulkMutateRowsSettings = BigtableBatchingCallSettings.newBuilder(new MutateRowsBatchingDescriptor()).setRetryableCodes(IDEMPOTENT_RETRY_CODES).setRetrySettings(MUTATE_ROWS_RETRY_SETTINGS).setBatchingSettings(BatchingSettings.newBuilder().setIsEnabled(Boolean.valueOf(true)).setElementCountThreshold(Long.valueOf(100L)).setRequestByteThreshold(Long.valueOf(0x1400000L)).setDelayThreshold(Duration.ofSeconds((long)1L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).setMaxOutstandingRequestBytes(Long.valueOf(0x6400000L)).setMaxOutstandingElementCount(Long.valueOf(1000L)).build()).build());
            this.checkAndMutateRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            Builder.copyRetrySettings(baseDefaults.checkAndMutateRowSettings(), this.checkAndMutateRowSettings);
            this.readModifyWriteRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            Builder.copyRetrySettings(baseDefaults.readModifyWriteRowSettings(), this.readModifyWriteRowSettings);
        }

        private Builder(EnhancedBigtableStubSettings settings) {
            super((StubSettings)settings);
            this.projectId = settings.projectId;
            this.instanceId = settings.instanceId;
            this.appProfileId = settings.appProfileId;
            this.isRefreshingChannel = settings.isRefreshingChannel;
            this.readRowsSettings = settings.readRowsSettings.toBuilder();
            this.readRowSettings = settings.readRowSettings.toBuilder();
            this.sampleRowKeysSettings = settings.sampleRowKeysSettings.toBuilder();
            this.mutateRowSettings = settings.mutateRowSettings.toBuilder();
            this.bulkMutateRowsSettings = settings.bulkMutateRowsSettings.toBuilder();
            this.checkAndMutateRowSettings = settings.checkAndMutateRowSettings.toBuilder();
            this.readModifyWriteRowSettings = settings.readModifyWriteRowSettings.toBuilder();
        }

        private static void copyRetrySettings(UnaryCallSettings.Builder<?, ?> source, UnaryCallSettings.Builder<?, ?> dest) {
            dest.setRetryableCodes(source.getRetryableCodes());
            dest.setRetrySettings(source.getRetrySettings());
        }

        private static boolean isDirectPathEnabled() {
            String whiteList = System.getenv(EnhancedBigtableStubSettings.DIRECT_PATH_ENV_VAR);
            if (whiteList == null) {
                return false;
            }
            for (String service : whiteList.split(",")) {
                if (service.isEmpty() || !EnhancedBigtableStubSettings.DIRECT_PATH_ENDPOINT.contains(service)) continue;
                return true;
            }
            return false;
        }

        public Builder setProjectId(@Nonnull String projectId) {
            Preconditions.checkNotNull((Object)projectId);
            this.projectId = projectId;
            return this;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public Builder setInstanceId(@Nonnull String instanceId) {
            Preconditions.checkNotNull((Object)instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public Builder setAppProfileId(@Nonnull String appProfileId) {
            Preconditions.checkNotNull((Object)appProfileId, (Object)"AppProfileId can't be null");
            this.appProfileId = appProfileId;
            return this;
        }

        public Builder setDefaultAppProfileId() {
            this.setAppProfileId(EnhancedBigtableStubSettings.SERVER_DEFAULT_APP_PROFILE_ID);
            return this;
        }

        public String getAppProfileId() {
            return this.appProfileId;
        }

        @BetaApi(value="This API depends on experimental gRPC APIs")
        public Builder setRefreshingChannel(boolean isRefreshingChannel) {
            this.isRefreshingChannel = isRefreshingChannel;
            return this;
        }

        @BetaApi(value="This API depends on experimental gRPC APIs")
        public boolean isRefreshingChannel() {
            return this.isRefreshingChannel;
        }

        public ServerStreamingCallSettings.Builder<Query, Row> readRowsSettings() {
            return this.readRowsSettings;
        }

        public UnaryCallSettings.Builder<Query, Row> readRowSettings() {
            return this.readRowSettings;
        }

        public UnaryCallSettings.Builder<String, List<KeyOffset>> sampleRowKeysSettings() {
            return this.sampleRowKeysSettings;
        }

        public UnaryCallSettings.Builder<RowMutation, Void> mutateRowSettings() {
            return this.mutateRowSettings;
        }

        public BigtableBatchingCallSettings.Builder bulkMutateRowsSettings() {
            return this.bulkMutateRowsSettings;
        }

        public UnaryCallSettings.Builder<ConditionalRowMutation, Boolean> checkAndMutateRowSettings() {
            return this.checkAndMutateRowSettings;
        }

        public UnaryCallSettings.Builder<ReadModifyWriteRow, Row> readModifyWriteRowSettings() {
            return this.readModifyWriteRowSettings;
        }

        public EnhancedBigtableStubSettings build() {
            Preconditions.checkState((this.projectId != null ? 1 : 0) != 0, (Object)"Project id must be set");
            Preconditions.checkState((this.instanceId != null ? 1 : 0) != 0, (Object)"Instance id must be set");
            if (this.isRefreshingChannel) {
                Preconditions.checkArgument((boolean)(this.getTransportChannelProvider() instanceof InstantiatingGrpcChannelProvider), (Object)"refreshingChannel only works with InstantiatingGrpcChannelProviders");
                InstantiatingGrpcChannelProvider.Builder channelBuilder = ((InstantiatingGrpcChannelProvider)this.getTransportChannelProvider()).toBuilder().setChannelPrimer((ChannelPrimer)new RefreshChannel());
                this.setTransportChannelProvider((TransportChannelProvider)channelBuilder.build());
            }
            return new EnhancedBigtableStubSettings(this);
        }
    }
}

