/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.ResourceId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public abstract class ForwardingRuleId
extends ResourceId {
    private static final long serialVersionUID = -4352410760458355391L;
    private final String rule;

    ForwardingRuleId(String project, String rule) {
        super(project);
        this.rule = (String)Preconditions.checkNotNull((Object)rule);
    }

    public abstract Type getType();

    public String getRule() {
        return this.rule;
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("rule", (Object)this.rule);
    }

    @Override
    final int baseHashCode() {
        return Objects.hash(super.baseHashCode(), this.rule);
    }

    @Override
    final boolean baseEquals(ResourceId resourceId) {
        return resourceId instanceof ForwardingRuleId && super.baseEquals(resourceId) && Objects.equals(this.rule, ((ForwardingRuleId)resourceId).rule);
    }

    @Override
    abstract ForwardingRuleId setProjectId(String var1);

    static enum Type {
        GLOBAL,
        REGION;

    }
}

