/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.Cluster;
import com.google.cloud.dataproc.v1.ClusterControllerClient;
import com.google.cloud.dataproc.v1.ClusterOperationMetadata;
import com.google.cloud.dataproc.v1.CreateClusterRequest;
import com.google.cloud.dataproc.v1.DeleteClusterRequest;
import com.google.cloud.dataproc.v1.DiagnoseClusterRequest;
import com.google.cloud.dataproc.v1.DiagnoseClusterResults;
import com.google.cloud.dataproc.v1.GetClusterRequest;
import com.google.cloud.dataproc.v1.ListClustersRequest;
import com.google.cloud.dataproc.v1.ListClustersResponse;
import com.google.cloud.dataproc.v1.UpdateClusterRequest;
import com.google.cloud.dataproc.v1.stub.ClusterControllerStub;
import com.google.cloud.dataproc.v1.stub.ClusterControllerStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcClusterControllerStub
extends ClusterControllerStub {
    private static final MethodDescriptor<CreateClusterRequest, Operation> createClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.ClusterController/CreateCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateClusterRequest, Operation> updateClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.ClusterController/UpdateCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteClusterRequest, Operation> deleteClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.ClusterController/DeleteCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetClusterRequest, Cluster> getClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.ClusterController/GetCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)GetClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Cluster.getDefaultInstance())).build();
    private static final MethodDescriptor<ListClustersRequest, ListClustersResponse> listClustersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.ClusterController/ListClusters").setRequestMarshaller(ProtoUtils.marshaller((Message)ListClustersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListClustersResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DiagnoseClusterRequest, Operation> diagnoseClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.ClusterController/DiagnoseCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)DiagnoseClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable;
    private final OperationCallable<CreateClusterRequest, Cluster, ClusterOperationMetadata> createClusterOperationCallable;
    private final UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable;
    private final OperationCallable<UpdateClusterRequest, Cluster, ClusterOperationMetadata> updateClusterOperationCallable;
    private final UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable;
    private final OperationCallable<DeleteClusterRequest, Empty, ClusterOperationMetadata> deleteClusterOperationCallable;
    private final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable;
    private final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable;
    private final UnaryCallable<ListClustersRequest, ClusterControllerClient.ListClustersPagedResponse> listClustersPagedCallable;
    private final UnaryCallable<DiagnoseClusterRequest, Operation> diagnoseClusterCallable;
    private final OperationCallable<DiagnoseClusterRequest, Empty, DiagnoseClusterResults> diagnoseClusterOperationCallable;

    public static final GrpcClusterControllerStub create(ClusterControllerStubSettings settings) throws IOException {
        return new GrpcClusterControllerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcClusterControllerStub create(ClientContext clientContext) throws IOException {
        return new GrpcClusterControllerStub(ClusterControllerStubSettings.newBuilder().build(), clientContext);
    }

    protected GrpcClusterControllerStub(ClusterControllerStubSettings settings, ClientContext clientContext) throws IOException {
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext);
        GrpcCallSettings createClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createClusterMethodDescriptor).build();
        GrpcCallSettings updateClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateClusterMethodDescriptor).build();
        GrpcCallSettings deleteClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteClusterMethodDescriptor).build();
        GrpcCallSettings getClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getClusterMethodDescriptor).build();
        GrpcCallSettings listClustersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listClustersMethodDescriptor).build();
        GrpcCallSettings diagnoseClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(diagnoseClusterMethodDescriptor).build();
        this.createClusterCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)createClusterTransportSettings, settings.createClusterSettings(), (ClientContext)clientContext);
        this.createClusterOperationCallable = GrpcCallableFactory.createOperationCallable((GrpcCallSettings)createClusterTransportSettings, settings.createClusterOperationSettings(), (ClientContext)clientContext, (OperationsStub)this.operationsStub);
        this.updateClusterCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)updateClusterTransportSettings, settings.updateClusterSettings(), (ClientContext)clientContext);
        this.updateClusterOperationCallable = GrpcCallableFactory.createOperationCallable((GrpcCallSettings)updateClusterTransportSettings, settings.updateClusterOperationSettings(), (ClientContext)clientContext, (OperationsStub)this.operationsStub);
        this.deleteClusterCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)deleteClusterTransportSettings, settings.deleteClusterSettings(), (ClientContext)clientContext);
        this.deleteClusterOperationCallable = GrpcCallableFactory.createOperationCallable((GrpcCallSettings)deleteClusterTransportSettings, settings.deleteClusterOperationSettings(), (ClientContext)clientContext, (OperationsStub)this.operationsStub);
        this.getClusterCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)getClusterTransportSettings, settings.getClusterSettings(), (ClientContext)clientContext);
        this.listClustersCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)listClustersTransportSettings, settings.listClustersSettings(), (ClientContext)clientContext);
        this.listClustersPagedCallable = GrpcCallableFactory.createPagedCallable((GrpcCallSettings)listClustersTransportSettings, settings.listClustersSettings(), (ClientContext)clientContext);
        this.diagnoseClusterCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)diagnoseClusterTransportSettings, settings.diagnoseClusterSettings(), (ClientContext)clientContext);
        this.diagnoseClusterOperationCallable = GrpcCallableFactory.createOperationCallable((GrpcCallSettings)diagnoseClusterTransportSettings, settings.diagnoseClusterOperationSettings(), (ClientContext)clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public OperationCallable<CreateClusterRequest, Cluster, ClusterOperationMetadata> createClusterOperationCallable() {
        return this.createClusterOperationCallable;
    }

    @Override
    public UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.createClusterCallable;
    }

    @Override
    public OperationCallable<UpdateClusterRequest, Cluster, ClusterOperationMetadata> updateClusterOperationCallable() {
        return this.updateClusterOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable() {
        return this.updateClusterCallable;
    }

    @Override
    public OperationCallable<DeleteClusterRequest, Empty, ClusterOperationMetadata> deleteClusterOperationCallable() {
        return this.deleteClusterOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable() {
        return this.deleteClusterCallable;
    }

    @Override
    public UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.getClusterCallable;
    }

    @Override
    public UnaryCallable<ListClustersRequest, ClusterControllerClient.ListClustersPagedResponse> listClustersPagedCallable() {
        return this.listClustersPagedCallable;
    }

    @Override
    public UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.listClustersCallable;
    }

    @Override
    public OperationCallable<DiagnoseClusterRequest, Empty, DiagnoseClusterResults> diagnoseClusterOperationCallable() {
        return this.diagnoseClusterOperationCallable;
    }

    @Override
    public UnaryCallable<DiagnoseClusterRequest, Operation> diagnoseClusterCallable() {
        return this.diagnoseClusterCallable;
    }

    public final void close() throws Exception {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

