/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.CreateDocumentRequest;
import com.google.cloud.dialogflow.v2.DeleteDocumentRequest;
import com.google.cloud.dialogflow.v2.Document;
import com.google.cloud.dialogflow.v2.DocumentName;
import com.google.cloud.dialogflow.v2.DocumentsSettings;
import com.google.cloud.dialogflow.v2.GetDocumentRequest;
import com.google.cloud.dialogflow.v2.KnowledgeBaseName;
import com.google.cloud.dialogflow.v2.KnowledgeOperationMetadata;
import com.google.cloud.dialogflow.v2.ListDocumentsRequest;
import com.google.cloud.dialogflow.v2.ListDocumentsResponse;
import com.google.cloud.dialogflow.v2.ReloadDocumentRequest;
import com.google.cloud.dialogflow.v2.UpdateDocumentRequest;
import com.google.cloud.dialogflow.v2.stub.DocumentsStub;
import com.google.cloud.dialogflow.v2.stub.DocumentsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DocumentsClient
implements BackgroundResource {
    private final DocumentsSettings settings;
    private final DocumentsStub stub;
    private final OperationsClient operationsClient;

    public static final DocumentsClient create() throws IOException {
        return DocumentsClient.create(DocumentsSettings.newBuilder().build());
    }

    public static final DocumentsClient create(DocumentsSettings settings) throws IOException {
        return new DocumentsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DocumentsClient create(DocumentsStub stub) {
        return new DocumentsClient(stub);
    }

    protected DocumentsClient(DocumentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DocumentsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DocumentsClient(DocumentsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DocumentsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DocumentsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListDocumentsPagedResponse listDocuments(KnowledgeBaseName parent) {
        ListDocumentsRequest request = ListDocumentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDocuments(request);
    }

    public final ListDocumentsPagedResponse listDocuments(String parent) {
        ListDocumentsRequest request = ListDocumentsRequest.newBuilder().setParent(parent).build();
        return this.listDocuments(request);
    }

    public final ListDocumentsPagedResponse listDocuments(ListDocumentsRequest request) {
        return (ListDocumentsPagedResponse)((Object)this.listDocumentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDocumentsRequest, ListDocumentsPagedResponse> listDocumentsPagedCallable() {
        return this.stub.listDocumentsPagedCallable();
    }

    public final UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable() {
        return this.stub.listDocumentsCallable();
    }

    public final Document getDocument(DocumentName name) {
        GetDocumentRequest request = GetDocumentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDocument(request);
    }

    public final Document getDocument(String name) {
        GetDocumentRequest request = GetDocumentRequest.newBuilder().setName(name).build();
        return this.getDocument(request);
    }

    public final Document getDocument(GetDocumentRequest request) {
        return (Document)this.getDocumentCallable().call((Object)request);
    }

    public final UnaryCallable<GetDocumentRequest, Document> getDocumentCallable() {
        return this.stub.getDocumentCallable();
    }

    public final OperationFuture<Document, KnowledgeOperationMetadata> createDocumentAsync(KnowledgeBaseName parent, Document document) {
        CreateDocumentRequest request = CreateDocumentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDocument(document).build();
        return this.createDocumentAsync(request);
    }

    public final OperationFuture<Document, KnowledgeOperationMetadata> createDocumentAsync(String parent, Document document) {
        CreateDocumentRequest request = CreateDocumentRequest.newBuilder().setParent(parent).setDocument(document).build();
        return this.createDocumentAsync(request);
    }

    public final OperationFuture<Document, KnowledgeOperationMetadata> createDocumentAsync(CreateDocumentRequest request) {
        return this.createDocumentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDocumentRequest, Document, KnowledgeOperationMetadata> createDocumentOperationCallable() {
        return this.stub.createDocumentOperationCallable();
    }

    public final UnaryCallable<CreateDocumentRequest, Operation> createDocumentCallable() {
        return this.stub.createDocumentCallable();
    }

    public final OperationFuture<Empty, KnowledgeOperationMetadata> deleteDocumentAsync(DocumentName name) {
        DeleteDocumentRequest request = DeleteDocumentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDocumentAsync(request);
    }

    public final OperationFuture<Empty, KnowledgeOperationMetadata> deleteDocumentAsync(String name) {
        DeleteDocumentRequest request = DeleteDocumentRequest.newBuilder().setName(name).build();
        return this.deleteDocumentAsync(request);
    }

    public final OperationFuture<Empty, KnowledgeOperationMetadata> deleteDocumentAsync(DeleteDocumentRequest request) {
        return this.deleteDocumentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDocumentRequest, Empty, KnowledgeOperationMetadata> deleteDocumentOperationCallable() {
        return this.stub.deleteDocumentOperationCallable();
    }

    public final UnaryCallable<DeleteDocumentRequest, Operation> deleteDocumentCallable() {
        return this.stub.deleteDocumentCallable();
    }

    public final OperationFuture<Document, KnowledgeOperationMetadata> updateDocumentAsync(Document document, FieldMask updateMask) {
        UpdateDocumentRequest request = UpdateDocumentRequest.newBuilder().setDocument(document).setUpdateMask(updateMask).build();
        return this.updateDocumentAsync(request);
    }

    public final OperationFuture<Document, KnowledgeOperationMetadata> updateDocumentAsync(UpdateDocumentRequest request) {
        return this.updateDocumentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDocumentRequest, Document, KnowledgeOperationMetadata> updateDocumentOperationCallable() {
        return this.stub.updateDocumentOperationCallable();
    }

    public final UnaryCallable<UpdateDocumentRequest, Operation> updateDocumentCallable() {
        return this.stub.updateDocumentCallable();
    }

    public final OperationFuture<Document, KnowledgeOperationMetadata> reloadDocumentAsync(DocumentName name, String contentUri) {
        ReloadDocumentRequest request = ReloadDocumentRequest.newBuilder().setName(name == null ? null : name.toString()).setContentUri(contentUri).build();
        return this.reloadDocumentAsync(request);
    }

    public final OperationFuture<Document, KnowledgeOperationMetadata> reloadDocumentAsync(String name, String contentUri) {
        ReloadDocumentRequest request = ReloadDocumentRequest.newBuilder().setName(name).setContentUri(contentUri).build();
        return this.reloadDocumentAsync(request);
    }

    public final OperationFuture<Document, KnowledgeOperationMetadata> reloadDocumentAsync(ReloadDocumentRequest request) {
        return this.reloadDocumentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ReloadDocumentRequest, Document, KnowledgeOperationMetadata> reloadDocumentOperationCallable() {
        return this.stub.reloadDocumentOperationCallable();
    }

    public final UnaryCallable<ReloadDocumentRequest, Operation> reloadDocumentCallable() {
        return this.stub.reloadDocumentCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDocumentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDocumentsRequest, ListDocumentsResponse, Document, ListDocumentsPage, ListDocumentsFixedSizeCollection> {
        private ListDocumentsFixedSizeCollection(List<ListDocumentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDocumentsFixedSizeCollection createEmptyCollection() {
            return new ListDocumentsFixedSizeCollection(null, 0);
        }

        protected ListDocumentsFixedSizeCollection createCollection(List<ListDocumentsPage> pages, int collectionSize) {
            return new ListDocumentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDocumentsPage
    extends AbstractPage<ListDocumentsRequest, ListDocumentsResponse, Document, ListDocumentsPage> {
        private ListDocumentsPage(PageContext<ListDocumentsRequest, ListDocumentsResponse, Document> context, ListDocumentsResponse response) {
            super(context, (Object)response);
        }

        private static ListDocumentsPage createEmptyPage() {
            return new ListDocumentsPage(null, null);
        }

        protected ListDocumentsPage createPage(PageContext<ListDocumentsRequest, ListDocumentsResponse, Document> context, ListDocumentsResponse response) {
            return new ListDocumentsPage(context, response);
        }

        public ApiFuture<ListDocumentsPage> createPageAsync(PageContext<ListDocumentsRequest, ListDocumentsResponse, Document> context, ApiFuture<ListDocumentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDocumentsPagedResponse
    extends AbstractPagedListResponse<ListDocumentsRequest, ListDocumentsResponse, Document, ListDocumentsPage, ListDocumentsFixedSizeCollection> {
        public static ApiFuture<ListDocumentsPagedResponse> createAsync(PageContext<ListDocumentsRequest, ListDocumentsResponse, Document> context, ApiFuture<ListDocumentsResponse> futureResponse) {
            ApiFuture<ListDocumentsPage> futurePage = ListDocumentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDocumentsPagedResponse((ListDocumentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDocumentsPagedResponse(ListDocumentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDocumentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

